/*
 * Decompiled with CFR 0.152.
 */
package io.github.smiley4.schemakenerator.swagger.steps;

import io.github.smiley4.schemakenerator.core.data.BaseTypeData;
import io.github.smiley4.schemakenerator.core.data.Bundle;
import io.github.smiley4.schemakenerator.core.data.BundleKt;
import io.github.smiley4.schemakenerator.core.data.TypeId;
import io.github.smiley4.schemakenerator.swagger.data.CompiledSwaggerSchema;
import io.github.smiley4.schemakenerator.swagger.data.SwaggerSchema;
import io.github.smiley4.schemakenerator.swagger.steps.SwaggerSchemaCompileUtils;
import io.github.smiley4.schemakenerator.swagger.steps.SwaggerSchemaUtils;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\n*\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/github/smiley4/schemakenerator/swagger/steps/SwaggerSchemaCompileInlineStep;", "", "<init>", "()V", "schemaUtils", "Lio/github/smiley4/schemakenerator/swagger/steps/SwaggerSchemaUtils;", "compile", "Lio/github/smiley4/schemakenerator/swagger/data/CompiledSwaggerSchema;", "bundle", "Lio/github/smiley4/schemakenerator/core/data/Bundle;", "Lio/github/smiley4/schemakenerator/swagger/data/SwaggerSchema;", "setNullable", "", "schema", "Lio/swagger/v3/oas/models/media/Schema;", "handleDiscriminatorMappings", "root", "find", "", "id", "Lio/github/smiley4/schemakenerator/core/data/TypeId;", "schema-kenerator-swagger"})
@SourceDebugExtension(value={"SMAP\nSwaggerSchemaCompileInlineStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerSchemaCompileInlineStep.kt\nio/github/smiley4/schemakenerator/swagger/steps/SwaggerSchemaCompileInlineStep\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class SwaggerSchemaCompileInlineStep {
    @NotNull
    private final SwaggerSchemaUtils schemaUtils = new SwaggerSchemaUtils();

    @NotNull
    public final CompiledSwaggerSchema compile(@NotNull Bundle<SwaggerSchema> bundle) {
        Intrinsics.checkNotNullParameter(bundle, (String)"bundle");
        List schemaList = BundleKt.flatten(bundle);
        SwaggerSchemaCompileUtils.INSTANCE.copyTypeToTypes(schemaList);
        Schema root = SwaggerSchemaCompileUtils.resolveReferences$default(SwaggerSchemaCompileUtils.INSTANCE, ((SwaggerSchema)bundle.getData()).getSwagger(), 0, arg_0 -> SwaggerSchemaCompileInlineStep.compile$lambda$1(this, schemaList, arg_0), 2, null);
        this.handleDiscriminatorMappings(root);
        BaseTypeData baseTypeData = ((SwaggerSchema)bundle.getData()).getTypeData();
        Map map = MapsKt.emptyMap();
        return new CompiledSwaggerSchema(baseTypeData, root, map);
    }

    private final void setNullable(Schema<?> schema) {
        if (schema.getTypes() != null) {
            Set set = SetsKt.setOf((Object)"null");
            Set set2 = schema.getTypes();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getTypes(...)");
            schema.setTypes(SetsKt.plus((Set)set, (Iterable)set2));
        }
        if (schema.getAnyOf() != null) {
            List list = schema.getAnyOf();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnyOf(...)");
            if (!((Collection)list).isEmpty()) {
                List list2 = schema.getAnyOf();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnyOf(...)");
                schema.setAnyOf(CollectionsKt.plus((Collection)list2, this.schemaUtils.nullSchema()));
            }
        }
        if (schema.getOneOf() != null) {
            List list = schema.getOneOf();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOneOf(...)");
            if (!((Collection)list).isEmpty()) {
                List list3 = schema.getOneOf();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getOneOf(...)");
                schema.setOneOf(CollectionsKt.plus((Collection)list3, this.schemaUtils.nullSchema()));
            }
        }
    }

    private final void handleDiscriminatorMappings(Schema<?> root) {
        SwaggerSchemaCompileUtils.INSTANCE.iterate(root, arg_0 -> SwaggerSchemaCompileInlineStep.handleDiscriminatorMappings$lambda$2(root, arg_0));
    }

    private final SwaggerSchema find(Collection<SwaggerSchema> $this$find, TypeId id) {
        Object v0;
        block1: {
            Iterable iterable = $this$find;
            for (Object t : iterable) {
                SwaggerSchema it = (SwaggerSchema)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTypeData().getId(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final Schema compile$lambda$1(SwaggerSchemaCompileInlineStep this$0, List $schemaList, Schema refObj) {
        Schema<?> schema;
        Intrinsics.checkNotNullParameter((Object)refObj, (String)"refObj");
        String string = refObj.get$ref();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get$ref(...)");
        TypeId referencedId = TypeId.Companion.parse(string);
        SwaggerSchema referencedSchema = this$0.find($schemaList, referencedId);
        if (referencedSchema != null) {
            Schema<?> schema2;
            Schema<?> it = schema2 = SwaggerSchemaCompileUtils.INSTANCE.merge(refObj, referencedSchema.getSwagger());
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getNullable(), (Object)true)) {
                it.setNullable(null);
                this$0.setNullable(it);
            }
            if (Intrinsics.areEqual((Object)it.getNullable(), (Object)false)) {
                it.setNullable(null);
            }
            schema = schema2;
        } else {
            schema = refObj;
        }
        return schema;
    }

    private static final Unit handleDiscriminatorMappings$lambda$2(Schema $root, Schema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($root.getDiscriminator() != null) {
            $root.getDiscriminator().setMapping(null);
        }
        return Unit.INSTANCE;
    }
}

