/**
 * Copyright 2015 The original authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
**/

package io.sundr.adapter.apt;

import java.util.Optional;

import javax.lang.model.element.TypeElement;

import io.sundr.adapter.api.TypeLookup;

public class AptLookup implements TypeLookup<TypeElement> {

  @Override
  public boolean isAvailable() {
    try {
      return AptContext.getContext() != null;
    } catch (Throwable t) {
      return false;
    }
  }

  @Override
  public Optional<TypeElement> forName(String fullyQualifiedName) {
    return Optional.ofNullable(AptContext.getContext().getElements().getTypeElement(fullyQualifiedName));
  }
}
