/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.KeyValueConverter;
import io.vertx.ext.consul.TxnOperationType;
import io.vertx.ext.consul.TxnResult;
import java.util.Map;

@DataObject(generateConverter=true)
public class KeyValue
implements TxnResult {
    private String key;
    private String value;
    private String session;
    private long flags;
    private long createIndex;
    private long modifyIndex;
    private long lockIndex;

    public KeyValue() {
    }

    public KeyValue(KeyValue other) {
        this.key = other.key;
        this.value = other.value;
        this.session = other.session;
        this.flags = other.flags;
        this.createIndex = other.createIndex;
        this.modifyIndex = other.modifyIndex;
        this.lockIndex = other.lockIndex;
    }

    public KeyValue(JsonObject json) {
        KeyValueConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        KeyValueConverter.toJson(this, jsonObject);
        return jsonObject;
    }

    @GenIgnore
    public boolean isPresent() {
        return this.key != null;
    }

    public String getKey() {
        return this.key;
    }

    public KeyValue setKey(String key) {
        this.key = key;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public KeyValue setValue(String value) {
        this.value = value;
        return this;
    }

    public String getSession() {
        return this.session;
    }

    public KeyValue setSession(String session) {
        this.session = session;
        return this;
    }

    public long getFlags() {
        return this.flags;
    }

    public KeyValue setFlags(long flags) {
        this.flags = flags;
        return this;
    }

    public long getCreateIndex() {
        return this.createIndex;
    }

    public KeyValue setCreateIndex(long createIndex) {
        this.createIndex = createIndex;
        return this;
    }

    public long getModifyIndex() {
        return this.modifyIndex;
    }

    public KeyValue setModifyIndex(long modifyIndex) {
        this.modifyIndex = modifyIndex;
        return this;
    }

    public long getLockIndex() {
        return this.lockIndex;
    }

    public KeyValue setLockIndex(long lockIndex) {
        this.lockIndex = lockIndex;
        return this;
    }

    @Override
    @GenIgnore
    public TxnOperationType getOperationType() {
        return TxnOperationType.KV;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValue keyValue = (KeyValue)o;
        if (this.flags != keyValue.flags) {
            return false;
        }
        if (this.createIndex != keyValue.createIndex) {
            return false;
        }
        if (this.modifyIndex != keyValue.modifyIndex) {
            return false;
        }
        if (this.lockIndex != keyValue.lockIndex) {
            return false;
        }
        if (this.key != null ? !this.key.equals(keyValue.key) : keyValue.key != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(keyValue.value) : keyValue.value != null) {
            return false;
        }
        return this.session != null ? this.session.equals(keyValue.session) : keyValue.session == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.session != null ? this.session.hashCode() : 0);
        result = 31 * result + (int)(this.flags ^ this.flags >>> 32);
        result = 31 * result + (int)(this.createIndex ^ this.createIndex >>> 32);
        result = 31 * result + (int)(this.modifyIndex ^ this.modifyIndex >>> 32);
        result = 31 * result + (int)(this.lockIndex ^ this.lockIndex >>> 32);
        return result;
    }
}

