/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Node;
import java.util.HashMap;
import java.util.Map;

class NodeParser {
    private static final String NODE_KEY = "Node";
    private static final String ADDRESS_KEY = "Address";
    private static final String TAGGED_ADDRESSES_KEY = "TaggedAddresses";
    private static final String LAN_KEY = "lan";
    private static final String WAN_KEY = "wan";
    private static final String ID_KEY = "ID";
    private static final String DATACENTER_KEY = "Datacenter";
    private static final String META_KEY = "Meta";

    NodeParser() {
    }

    static Node parse(JsonObject json) {
        Map<String, String> metaMap;
        Node node = new Node().setId(json.getString(ID_KEY)).setName(json.getString(NODE_KEY)).setAddress(json.getString(ADDRESS_KEY)).setDatacenter(json.getString(DATACENTER_KEY));
        JsonObject tagged = json.getJsonObject(TAGGED_ADDRESSES_KEY);
        if (tagged != null) {
            node.setLanAddress(tagged.getString(LAN_KEY)).setWanAddress(tagged.getString(WAN_KEY));
        }
        if (!(metaMap = NodeParser.mapOfStringsFromJsonObject(json.getJsonObject(META_KEY))).isEmpty()) {
            node.setNodeMeta(metaMap);
        }
        return node;
    }

    private static Map<String, String> mapOfStringsFromJsonObject(JsonObject jsonObject) {
        Map map;
        HashMap<String, String> result = new HashMap<String, String>();
        if (jsonObject != null && !(map = jsonObject.getMap()).isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                result.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return result;
    }
}

