/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.TxnServiceOperation;
import io.vertx.ext.consul.TxnServiceVerb;
import java.util.Base64;
import java.util.Map;

public class TxnServiceOperationConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, TxnServiceOperation obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "node": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setNode((String)member.getValue());
                    break;
                }
                case "serviceOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setServiceOptions(new ServiceOptions((JsonObject)member.getValue()));
                    break;
                }
                case "type": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setType(TxnServiceVerb.valueOf((String)member.getValue()));
                }
            }
        }
    }

    public static void toJson(TxnServiceOperation obj, JsonObject json) {
        TxnServiceOperationConverter.toJson(obj, json.getMap());
    }

    public static void toJson(TxnServiceOperation obj, Map<String, Object> json) {
        if (obj.getNode() != null) {
            json.put("node", obj.getNode());
        }
        if (obj.getServiceOptions() != null) {
            json.put("serviceOptions", obj.getServiceOptions().toJson());
        }
        if (obj.getType() != null) {
            json.put("type", obj.getType().name());
        }
    }
}

