/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.CheckStatus;
import java.util.ArrayList;
import java.util.Map;

public class CheckOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, CheckOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "serviceId": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setServiceId((String)member.getValue());
                    break;
                }
                case "status": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setStatus(CheckStatus.valueOf((String)member.getValue()));
                    break;
                }
                case "scriptArgs": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setScriptArgs(list);
                    break;
                }
                case "http": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHttp((String)member.getValue());
                    break;
                }
                case "grpc": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setGrpc((String)member.getValue());
                    break;
                }
                case "grpcTls": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setGrpcTls((Boolean)member.getValue());
                    break;
                }
                case "tlsSkipVerify": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTlsSkipVerify((Boolean)member.getValue());
                    break;
                }
                case "ttl": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTtl((String)member.getValue());
                    break;
                }
                case "tcp": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTcp((String)member.getValue());
                    break;
                }
                case "interval": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setInterval((String)member.getValue());
                    break;
                }
                case "id": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setId((String)member.getValue());
                    break;
                }
                case "name": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setName((String)member.getValue());
                    break;
                }
                case "notes": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setNotes((String)member.getValue());
                    break;
                }
                case "deregisterAfter": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDeregisterAfter((String)member.getValue());
                }
            }
        }
    }

    static void toJson(CheckOptions obj, JsonObject json) {
        CheckOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(CheckOptions obj, Map<String, Object> json) {
        if (obj.getServiceId() != null) {
            json.put("serviceId", obj.getServiceId());
        }
        if (obj.getStatus() != null) {
            json.put("status", obj.getStatus().name());
        }
        if (obj.getScriptArgs() != null) {
            JsonArray array = new JsonArray();
            obj.getScriptArgs().forEach(item -> array.add(item));
            json.put("scriptArgs", array);
        }
        if (obj.getHttp() != null) {
            json.put("http", obj.getHttp());
        }
        if (obj.getGrpc() != null) {
            json.put("grpc", obj.getGrpc());
        }
        json.put("grpcTls", obj.isGrpcTls());
        json.put("tlsSkipVerify", obj.isTlsSkipVerify());
        if (obj.getTtl() != null) {
            json.put("ttl", obj.getTtl());
        }
        if (obj.getTcp() != null) {
            json.put("tcp", obj.getTcp());
        }
        if (obj.getInterval() != null) {
            json.put("interval", obj.getInterval());
        }
        if (obj.getId() != null) {
            json.put("id", obj.getId());
        }
        if (obj.getName() != null) {
            json.put("name", obj.getName());
        }
        if (obj.getNotes() != null) {
            json.put("notes", obj.getNotes());
        }
        if (obj.getDeregisterAfter() != null) {
            json.put("deregisterAfter", obj.getDeregisterAfter());
        }
    }
}

