/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.CheckList;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.CheckQueryOptions;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.ConsulClient;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.Coordinate;
import io.vertx.ext.consul.CoordinateList;
import io.vertx.ext.consul.DcCoordinates;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.EventListOptions;
import io.vertx.ext.consul.EventOptions;
import io.vertx.ext.consul.HealthState;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.KeyValueOptions;
import io.vertx.ext.consul.MaintenanceOptions;
import io.vertx.ext.consul.Node;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.NodeQueryOptions;
import io.vertx.ext.consul.PreparedQueryDefinition;
import io.vertx.ext.consul.PreparedQueryExecuteOptions;
import io.vertx.ext.consul.PreparedQueryExecuteResponse;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntry;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.SessionList;
import io.vertx.ext.consul.SessionOptions;
import io.vertx.ext.consul.TxnRequest;
import io.vertx.ext.consul.TxnResponse;
import io.vertx.ext.consul.impl.CheckParser;
import io.vertx.ext.consul.impl.CoordinateParser;
import io.vertx.ext.consul.impl.EventParser;
import io.vertx.ext.consul.impl.KVParser;
import io.vertx.ext.consul.impl.NodeParser;
import io.vertx.ext.consul.impl.Query;
import io.vertx.ext.consul.impl.ServiceEntryParser;
import io.vertx.ext.consul.impl.ServiceParser;
import io.vertx.ext.consul.impl.SessionParser;
import io.vertx.ext.consul.impl.TxnResponseParser;
import io.vertx.ext.consul.impl.Utils;
import io.vertx.ext.consul.policy.AclPolicy;
import io.vertx.ext.consul.token.AclToken;
import io.vertx.ext.consul.token.CloneAclTokenOptions;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ConsulClientImpl
implements ConsulClient {
    private static final String TOKEN_HEADER = "X-Consul-Token";
    private static final String INDEX_HEADER = "X-Consul-Index";
    private static final List<Integer> DEFAULT_VALID_CODES = Collections.singletonList(HttpResponseStatus.OK.code());
    private static final List<Integer> TXN_VALID_CODES = Arrays.asList(HttpResponseStatus.OK.code(), HttpResponseStatus.CONFLICT.code());
    private static final List<Integer> KV_VALID_CODES = Arrays.asList(HttpResponseStatus.OK.code(), HttpResponseStatus.NOT_FOUND.code());
    private final WebClient webClient;
    private final String aclToken;
    private final String dc;
    private final long timeoutMs;

    public ConsulClientImpl(Vertx vertx, ConsulClientOptions options) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(options);
        this.webClient = WebClient.create((Vertx)vertx, (WebClientOptions)options);
        this.aclToken = options.getAclToken();
        this.dc = options.getDc();
        this.timeoutMs = options.getTimeout();
    }

    @Override
    public Future<JsonObject> agentInfo() {
        return this.requestObject(HttpMethod.GET, "/v1/agent/self", null, null, (obj, headers) -> obj);
    }

    @Override
    public Future<CoordinateList> coordinateNodes() {
        return this.coordinateNodesWithOptions(null);
    }

    @Override
    public Future<CoordinateList> coordinateNodesWithOptions(BlockingQueryOptions options) {
        return this.requestArray(HttpMethod.GET, "/v1/coordinate/nodes", new Query().put(options), null, (arr, headers) -> {
            List<Coordinate> list = arr.stream().map(obj -> CoordinateParser.parse((JsonObject)obj)).collect(Collectors.toList());
            return new CoordinateList().setList(list).setIndex(Long.parseLong(headers.get(INDEX_HEADER)));
        });
    }

    @Override
    public Future<List<DcCoordinates>> coordinateDatacenters() {
        return this.requestArray(HttpMethod.GET, "/v1/coordinate/datacenters", null, null, (arr, headers) -> arr.stream().map(obj -> CoordinateParser.parseDc((JsonObject)obj)).collect(Collectors.toList()));
    }

    @Override
    public Future<List<String>> getKeys(String keyPrefix) {
        return this.getKeysWithOptions(keyPrefix, null);
    }

    @Override
    public Future<List<String>> getKeysWithOptions(String keyPrefix, BlockingQueryOptions options) {
        Query query = Query.of("recurse", true).put("keys", true).put(options);
        return this.request(KV_VALID_CODES, HttpMethod.GET, "/v1/kv/" + Utils.urlEncode(keyPrefix), query, null, resp -> {
            if (resp.statusCode() == HttpResponseStatus.NOT_FOUND.code()) {
                return new ArrayList();
            }
            return resp.bodyAsJsonArray().stream().map(Object::toString).collect(Collectors.toList());
        });
    }

    @Override
    public Future<KeyValue> getValue(String key) {
        return this.getValueWithOptions(key, null);
    }

    @Override
    public Future<KeyValue> getValueWithOptions(String key, BlockingQueryOptions options) {
        return this.request(KV_VALID_CODES, HttpMethod.GET, "/v1/kv/" + Utils.urlEncode(key), new Query().put(options), null, resp -> {
            if (resp.statusCode() == HttpResponseStatus.NOT_FOUND.code()) {
                return new KeyValue();
            }
            return KVParser.parse(resp.bodyAsJsonArray().getJsonObject(0));
        });
    }

    @Override
    public Future<Void> deleteValue(String key) {
        return this.requestVoid(HttpMethod.DELETE, "/v1/kv/" + Utils.urlEncode(key), null, null);
    }

    @Override
    public Future<KeyValueList> getValues(String keyPrefix) {
        return this.getValuesWithOptions(keyPrefix, null);
    }

    @Override
    public Future<KeyValueList> getValuesWithOptions(String keyPrefix, BlockingQueryOptions options) {
        Query query = Query.of("recurse", true).put(options);
        return this.request(KV_VALID_CODES, HttpMethod.GET, "/v1/kv/" + Utils.urlEncode(keyPrefix), query, null, resp -> {
            if (resp.statusCode() == HttpResponseStatus.NOT_FOUND.code()) {
                return new KeyValueList();
            }
            List<KeyValue> list = resp.bodyAsJsonArray().stream().map(obj -> KVParser.parse((JsonObject)obj)).collect(Collectors.toList());
            return new KeyValueList().setList(list).setIndex(Long.parseLong(resp.headers().get(INDEX_HEADER)));
        });
    }

    @Override
    public Future<Void> deleteValues(String keyPrefix) {
        return this.requestVoid(HttpMethod.DELETE, "/v1/kv/" + Utils.urlEncode(keyPrefix), Query.of("recurse", true), null);
    }

    @Override
    public Future<Boolean> putValue(String key, String value) {
        return this.putValueWithOptions(key, value, null);
    }

    @Override
    public Future<Boolean> putValueWithOptions(String key, String value, KeyValueOptions options) {
        Query query = new Query();
        if (options != null) {
            query.put("flags", Long.toUnsignedString(options.getFlags())).put("acquire", options.getAcquireSession()).put("release", options.getReleaseSession());
            long cas = options.getCasIndex();
            if (cas >= 0L) {
                query.put("cas", cas);
            }
        }
        return this.requestString(HttpMethod.PUT, "/v1/kv/" + Utils.urlEncode(key), query, value, (bool, headers) -> Boolean.valueOf(bool));
    }

    @Override
    public Future<TxnResponse> transaction(TxnRequest request) {
        String boby = request.toJson().getJsonArray("operations").encode();
        return this.request(TXN_VALID_CODES, HttpMethod.PUT, "/v1/txn", null, boby, resp -> TxnResponseParser.parse(resp.bodyAsJsonObject()));
    }

    @Override
    public Future<String> createAclPolicy(AclPolicy policy) {
        if (policy.getRules() == null) {
            return Future.failedFuture((Throwable)new RuntimeException("Missing required request parameter: 'rules'"));
        }
        if (policy.getName() == null) {
            return Future.failedFuture((Throwable)new RuntimeException("Missing required request parameter: 'name'"));
        }
        return this.requestObject(HttpMethod.PUT, "/v1/acl/policy", null, policy.toJson().encode(), (obj, headers) -> obj.getString("ID"));
    }

    @Override
    public Future<AclPolicy> readPolicy(String id) {
        return this.requestObject(HttpMethod.GET, "/v1/acl/policy/" + Utils.urlEncode(id), null, null, (obj, headers) -> new AclPolicy((JsonObject)obj));
    }

    @Override
    public Future<AclPolicy> readPolicyByName(String name) {
        return this.requestObject(HttpMethod.GET, "/v1/acl/policy/name/" + Utils.urlEncode(name), null, null, (obj, headers) -> new AclPolicy((JsonObject)obj));
    }

    @Override
    public Future<AclPolicy> updatePolicy(String id, AclPolicy policy) {
        return this.requestObject(HttpMethod.PUT, "/v1/acl/policy/" + Utils.urlEncode(id), null, policy.toJson().encode(), (obj, headers) -> new AclPolicy((JsonObject)obj));
    }

    @Override
    public Future<Boolean> deletePolicy(String id) {
        return this.requestString(HttpMethod.DELETE, "/v1/acl/policy/" + Utils.urlEncode(id), null, null, (str, headers) -> Boolean.parseBoolean(str));
    }

    @Override
    public Future<List<AclPolicy>> getAclPolicies() {
        return this.requestArray(HttpMethod.GET, "/v1/acl/policies", null, null, (array, header) -> array.stream().map(obj -> new AclPolicy((JsonObject)obj)).collect(Collectors.toList()));
    }

    @Override
    public Future<AclToken> createAclToken(AclToken token) {
        return this.requestObject(HttpMethod.PUT, "/v1/acl/token", null, token.toJson().encode(), (obj, headers) -> new AclToken((JsonObject)obj));
    }

    @Override
    public Future<AclToken> updateAclToken(String accessorId, AclToken token) {
        return this.requestObject(HttpMethod.PUT, "/v1/acl/token/" + Utils.urlEncode(accessorId), null, token.toJson().encode(), (obj, headers) -> new AclToken((JsonObject)obj));
    }

    @Override
    public Future<AclToken> cloneAclToken(String accessorId, CloneAclTokenOptions cloneAclTokenOptions) {
        return this.requestObject(HttpMethod.PUT, "/v1/acl/token/" + Utils.urlEncode(accessorId) + "/clone", null, cloneAclTokenOptions.toJson().encode(), (obj, headers) -> new AclToken((JsonObject)obj));
    }

    @Override
    public Future<List<AclToken>> getAclTokens() {
        return this.requestArray(HttpMethod.GET, "/v1/acl/tokens", null, null, (arr, headers) -> arr.stream().map(obj -> new AclToken((JsonObject)obj)).collect(Collectors.toList()));
    }

    @Override
    public Future<AclToken> readAclToken(String accessorId) {
        return this.requestObject(HttpMethod.GET, "/v1/acl/token/" + Utils.urlEncode(accessorId), null, null, (obj, headers) -> new AclToken((JsonObject)obj));
    }

    @Override
    public Future<Boolean> deleteAclToken(String accessorId) {
        return this.requestString(HttpMethod.DELETE, "/v1/acl/token/" + Utils.urlEncode(accessorId), null, null, (str, headers) -> Boolean.parseBoolean(str));
    }

    @Override
    public Future<Event> fireEvent(String name) {
        return this.fireEventWithOptions(name, null);
    }

    @Override
    public Future<Event> fireEventWithOptions(String name, EventOptions options) {
        Query query = new Query();
        if (options != null) {
            query.put("node", options.getNode()).put("service", options.getService()).put("tag", options.getTag());
        }
        String body = options == null || options.getPayload() == null ? "" : options.getPayload();
        return this.requestObject(HttpMethod.PUT, "/v1/event/fire/" + Utils.urlEncode(name), query, body, (jsonObject, headers) -> EventParser.parse(jsonObject));
    }

    @Override
    public Future<EventList> listEvents() {
        return this.listEventsWithOptions(null);
    }

    @Override
    public Future<EventList> listEventsWithOptions(EventListOptions options) {
        Query query = options == null ? null : Query.of(options.getBlockingOptions()).put("name", options.getName());
        return this.requestArray(HttpMethod.GET, "/v1/event/list", query, null, (jsonArray, headers) -> {
            List<Event> list = jsonArray.stream().map(obj -> EventParser.parse((JsonObject)obj)).collect(Collectors.toList());
            return new EventList().setList(list).setIndex(Long.parseUnsignedLong(headers.get(INDEX_HEADER)));
        });
    }

    @Override
    public Future<Void> registerService(ServiceOptions serviceOptions) {
        JsonObject jsonOpts = new JsonObject().put("ID", (Object)serviceOptions.getId()).put("Name", (Object)serviceOptions.getName()).put("Tags", serviceOptions.getTags()).put("Address", (Object)serviceOptions.getAddress()).put("Port", (Object)serviceOptions.getPort());
        if (serviceOptions.getCheckOptions() != null) {
            jsonOpts.put("Check", (Object)ConsulClientImpl.checkOpts(serviceOptions.getCheckOptions(), "CheckID", false));
        }
        if (serviceOptions.getCheckListOptions() != null) {
            jsonOpts.put("Checks", (Object)ConsulClientImpl.checkListOpts(serviceOptions.getCheckListOptions(), "CheckID", false));
        }
        if (serviceOptions.getMeta() != null && !serviceOptions.getMeta().isEmpty()) {
            jsonOpts.put("Meta", serviceOptions.getMeta());
        }
        if (serviceOptions.getConnectOptions() != null) {
            jsonOpts.put("Connect", (Object)serviceOptions.getConnectOptions().toJson());
        }
        return this.requestVoid(HttpMethod.PUT, "/v1/agent/service/register", null, jsonOpts.encode());
    }

    @Override
    public Future<Void> maintenanceService(MaintenanceOptions opts) {
        Query query = Query.of("enable", opts.isEnable()).put("reason", opts.getReason());
        return this.requestVoid(HttpMethod.PUT, "/v1/agent/service/maintenance/" + Utils.urlEncode(opts.getId()), query, null);
    }

    @Override
    public Future<Void> deregisterService(String id) {
        return this.requestVoid(HttpMethod.PUT, "/v1/agent/service/deregister/" + Utils.urlEncode(id), null, null);
    }

    @Override
    public Future<ServiceList> catalogServiceNodes(String service) {
        return this.catalogServiceNodesWithOptions(service, null);
    }

    @Override
    public Future<ServiceList> catalogServiceNodesWithOptions(String service, ServiceQueryOptions options) {
        Query query = options == null ? null : Query.of("tag", options.getTag()).put("near", options.getNear()).put(options.getBlockingOptions());
        return this.requestArray(HttpMethod.GET, "/v1/catalog/service/" + Utils.urlEncode(service), query, null, (arr, headers) -> {
            List<Service> list = arr.stream().map(obj -> new Service((JsonObject)obj)).collect(Collectors.toList());
            return new ServiceList().setList(list).setIndex(Long.parseLong(headers.get(INDEX_HEADER)));
        });
    }

    @Override
    public Future<List<String>> catalogDatacenters() {
        return this.requestArray(HttpMethod.GET, "/v1/catalog/datacenters", null, null, (arr, headers) -> Utils.listOf(arr));
    }

    @Override
    public Future<NodeList> catalogNodes() {
        return this.catalogNodesWithOptions(null);
    }

    @Override
    public Future<NodeList> catalogNodesWithOptions(NodeQueryOptions options) {
        Query query = options == null ? null : Query.of("near", options.getNear()).put(options.getBlockingOptions());
        return this.requestArray(HttpMethod.GET, "/v1/catalog/nodes", query, null, (arr, headers) -> {
            List<Node> list = arr.stream().map(obj -> NodeParser.parse((JsonObject)obj)).collect(Collectors.toList());
            return new NodeList().setList(list).setIndex(Long.parseLong(headers.get(INDEX_HEADER)));
        });
    }

    @Override
    public Future<CheckList> healthChecks(String service) {
        return this.healthChecksWithOptions(service, null);
    }

    private Query fromCheckQueryOptions(CheckQueryOptions options) {
        Query query = new Query();
        if (options != null) {
            if (options.getBlockingOptions() != null) {
                query.put(options.getBlockingOptions());
            }
            if (options.getNear() != null) {
                query.put("near", options.getNear());
            }
            if (options.getDc() != null && !options.getDc().isEmpty()) {
                query.put("dc", options.getDc());
            }
            if (options.getFilter() != null && !options.getFilter().isEmpty()) {
                query.put("filter", options.getFilter());
            }
        }
        return query;
    }

    @Override
    public Future<CheckList> healthChecksWithOptions(String service, CheckQueryOptions options) {
        return this.requestArray(HttpMethod.GET, "/v1/health/checks/" + Utils.urlEncode(service), this.fromCheckQueryOptions(options), null, (arr, headers) -> {
            List<Check> list = arr.stream().map(obj -> CheckParser.parse((JsonObject)obj)).collect(Collectors.toList());
            return new CheckList().setList(list).setIndex(Long.parseLong(headers.get(INDEX_HEADER)));
        });
    }

    @Override
    public Future<CheckList> healthState(HealthState healthState) {
        return this.healthStateWithOptions(healthState, null);
    }

    @Override
    public Future<CheckList> healthStateWithOptions(HealthState healthState, CheckQueryOptions options) {
        return this.requestArray(HttpMethod.GET, "/v1/health/state/" + healthState.key, this.fromCheckQueryOptions(options), null, (arr, headers) -> {
            List<Check> list = arr.stream().map(obj -> CheckParser.parse((JsonObject)obj)).collect(Collectors.toList());
            return new CheckList().setList(list).setIndex(Long.parseLong(headers.get(INDEX_HEADER)));
        });
    }

    @Override
    public Future<ServiceEntryList> healthServiceNodes(String service, boolean passing) {
        return this.healthServiceNodesWithOptions(service, passing, null);
    }

    @Override
    public Future<ServiceEntryList> healthServiceNodesWithOptions(String service, boolean passing, ServiceQueryOptions options) {
        Query query = new Query().put("passing", passing ? Integer.valueOf(1) : null);
        if (options != null) {
            query.put(options.getBlockingOptions()).put("near", options.getNear()).put("tag", options.getTag());
        }
        return this.requestArray(HttpMethod.GET, "/v1/health/service/" + Utils.urlEncode(service), query, null, (arr, headers) -> {
            List<ServiceEntry> list = arr.stream().map(obj -> ServiceEntryParser.parse((JsonObject)obj)).collect(Collectors.toList());
            return new ServiceEntryList().setList(list).setIndex(Long.parseLong(headers.get(INDEX_HEADER)));
        });
    }

    @Override
    public Future<CheckList> healthNodesWithOptions(String node, CheckQueryOptions options) {
        return this.requestArray(HttpMethod.GET, "/v1/health/node/" + Utils.urlEncode(node), this.fromCheckQueryOptions(options), options.toJson().encode(), (arr, headers) -> {
            List<Check> list = arr.stream().map(obj -> CheckParser.parse((JsonObject)obj)).collect(Collectors.toList());
            return new CheckList().setList(list).setIndex(Long.parseLong(headers.get(INDEX_HEADER)));
        });
    }

    @Override
    public Future<ServiceList> catalogServices() {
        return this.catalogServicesWithOptions(null);
    }

    @Override
    public Future<ServiceList> catalogServicesWithOptions(BlockingQueryOptions options) {
        return this.requestObject(HttpMethod.GET, "/v1/catalog/services", Query.of(options), null, (json, headers) -> {
            List<Service> list = json.stream().map(ServiceParser::parseCatalogInfo).collect(Collectors.toList());
            return new ServiceList().setList(list).setIndex(Long.parseLong(headers.get(INDEX_HEADER)));
        });
    }

    @Override
    public Future<List<Check>> localChecks() {
        return this.requestObject(HttpMethod.GET, "/v1/agent/checks", null, null, (json, headers) -> json.stream().map(obj -> CheckParser.parse((JsonObject)obj.getValue())).collect(Collectors.toList()));
    }

    @Override
    public Future<List<Service>> localServices() {
        return this.requestObject(HttpMethod.GET, "/v1/agent/services", null, null, (json, headers) -> json.stream().map(obj -> ServiceParser.parseAgentInfo((JsonObject)obj.getValue())).collect(Collectors.toList()));
    }

    @Override
    public Future<ServiceList> catalogNodeServices(String node) {
        return this.catalogNodeServicesWithOptions(node, null);
    }

    @Override
    public Future<ServiceList> catalogNodeServicesWithOptions(String node, BlockingQueryOptions options) {
        return this.requestObject(HttpMethod.GET, "/v1/catalog/node/" + Utils.urlEncode(node), Query.of(options), null, (json, headers) -> {
            JsonObject nodeInfo = json.getJsonObject("Node");
            String nodeName = nodeInfo.getString("Node");
            String nodeAddress = nodeInfo.getString("Address");
            List<Service> list = json.getJsonObject("Services").stream().map(obj -> ServiceParser.parseNodeInfo(nodeName, nodeAddress, (JsonObject)obj.getValue())).collect(Collectors.toList());
            return new ServiceList().setList(list).setIndex(Long.parseLong(headers.get(INDEX_HEADER)));
        });
    }

    @Override
    public Future<Void> registerCheck(CheckOptions checkOptions) {
        return this.requestVoid(HttpMethod.PUT, "/v1/agent/check/register", null, ConsulClientImpl.checkOpts(checkOptions, "ID", true).encode());
    }

    private static JsonObject checkOpts(CheckOptions checkOptions, String checkIdKey, boolean extended) {
        JsonObject json = new JsonObject().put(checkIdKey, (Object)checkOptions.getId()).put("Name", (Object)checkOptions.getName()).put("Notes", (Object)checkOptions.getNotes()).put("ScriptArgs", checkOptions.getScriptArgs()).put("HTTP", (Object)checkOptions.getHttp()).put("Header", checkOptions.getHeaders()).put("TLSSkipVerify", (Object)checkOptions.isTlsSkipVerify()).put("GRPC", (Object)checkOptions.getGrpc()).put("Interval", (Object)checkOptions.getInterval()).put("TTL", (Object)checkOptions.getTtl()).put("TCP", (Object)checkOptions.getTcp());
        if (checkOptions.getGrpc() != null) {
            json.put("GRPCUseTLS", (Object)checkOptions.isGrpcTls());
        }
        if (checkOptions.getDeregisterAfter() != null) {
            json.put("DeregisterCriticalServiceAfter", (Object)checkOptions.getDeregisterAfter());
        }
        if (checkOptions.getStatus() != null) {
            json.put("Status", (Object)checkOptions.getStatus().key);
        }
        if (extended && checkOptions.getServiceId() != null) {
            json.put("ServiceID", (Object)checkOptions.getServiceId());
        }
        return json;
    }

    private static JsonArray checkListOpts(List<CheckOptions> listChecks, String checkIdKey, boolean extended) {
        JsonArray jsonArray = new JsonArray();
        listChecks.stream().map(c -> ConsulClientImpl.checkOpts(c, checkIdKey, extended)).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        return jsonArray;
    }

    @Override
    public Future<Void> deregisterCheck(String checkId) {
        return this.requestVoid(HttpMethod.PUT, "/v1/agent/check/deregister/" + Utils.urlEncode(checkId), null, null);
    }

    @Override
    public Future<Void> passCheck(String checkId) {
        return this.passCheckWithNote(checkId, null);
    }

    @Override
    public Future<Void> passCheckWithNote(String checkId, String note) {
        return this.requestVoid(HttpMethod.PUT, "/v1/agent/check/pass/" + Utils.urlEncode(checkId), Query.of("note", note), null);
    }

    @Override
    public Future<Void> warnCheck(String checkId) {
        return this.warnCheckWithNote(checkId, null);
    }

    @Override
    public Future<Void> warnCheckWithNote(String checkId, String note) {
        return this.requestVoid(HttpMethod.PUT, "/v1/agent/check/warn/" + Utils.urlEncode(checkId), Query.of("note", note), null);
    }

    @Override
    public Future<Void> failCheck(String checkId) {
        return this.failCheckWithNote(checkId, null);
    }

    @Override
    public Future<Void> failCheckWithNote(String checkId, String note) {
        return this.requestVoid(HttpMethod.PUT, "/v1/agent/check/fail/" + Utils.urlEncode(checkId), Query.of("note", note), null);
    }

    @Override
    public Future<Void> updateCheck(String checkId, CheckStatus status) {
        return this.updateCheckWithNote(checkId, status, null);
    }

    @Override
    public Future<Void> updateCheckWithNote(String checkId, CheckStatus status, String note) {
        JsonObject put = new JsonObject().put("Status", (Object)status.key);
        if (note != null) {
            put.put("Output", (Object)note);
        }
        return this.requestVoid(HttpMethod.PUT, "/v1/agent/check/update/" + Utils.urlEncode(checkId), null, put.encode());
    }

    @Override
    public Future<String> leaderStatus() {
        return this.requestString(HttpMethod.GET, "/v1/status/leader", null, null, (leader, headers) -> leader.substring(1, leader.length() - 2));
    }

    @Override
    public Future<List<String>> peersStatus() {
        return this.requestArray(HttpMethod.GET, "/v1/status/peers", null, null, (arr, headers) -> arr.stream().map(obj -> (String)obj).collect(Collectors.toList()));
    }

    @Override
    public Future<String> createSession() {
        return this.createSessionWithOptions(null);
    }

    @Override
    public Future<String> createSessionWithOptions(SessionOptions options) {
        String body = options == null ? null : options.toJson().encode();
        return this.requestObject(HttpMethod.PUT, "/v1/session/create", null, body, (obj, headers) -> obj.getString("ID"));
    }

    @Override
    public Future<Session> infoSession(String id) {
        return this.infoSessionWithOptions(id, null);
    }

    @Override
    public Future<Session> infoSessionWithOptions(String id, BlockingQueryOptions options) {
        return this.requestArray(HttpMethod.GET, "/v1/session/info/" + Utils.urlEncode(id), Query.of(options), null, (sessions, headers) -> {
            if (sessions.size() == 0) {
                throw new RuntimeException("Unknown session ID: " + id);
            }
            return SessionParser.parse(sessions.getJsonObject(0), Long.parseLong(headers.get(INDEX_HEADER)));
        });
    }

    @Override
    public Future<Session> renewSession(String id) {
        return this.requestArray(HttpMethod.PUT, "/v1/session/renew/" + Utils.urlEncode(id), null, null, (arr, headers) -> SessionParser.parse(arr.getJsonObject(0)));
    }

    @Override
    public Future<SessionList> listSessions() {
        return this.listSessionsWithOptions(null);
    }

    @Override
    public Future<SessionList> listSessionsWithOptions(BlockingQueryOptions options) {
        return this.requestArray(HttpMethod.GET, "/v1/session/list", Query.of(options), null, (arr, headers) -> {
            List<Session> list = arr.stream().map(obj -> SessionParser.parse((JsonObject)obj)).collect(Collectors.toList());
            return new SessionList().setList(list).setIndex(Long.parseLong(headers.get(INDEX_HEADER)));
        });
    }

    @Override
    public Future<SessionList> listNodeSessions(String nodeId) {
        return this.listNodeSessionsWithOptions(nodeId, null);
    }

    @Override
    public Future<SessionList> listNodeSessionsWithOptions(String nodeId, BlockingQueryOptions options) {
        return this.requestArray(HttpMethod.GET, "/v1/session/node/" + Utils.urlEncode(nodeId), Query.of(options), null, (arr, headers) -> {
            List<Session> list = arr.stream().map(obj -> SessionParser.parse((JsonObject)obj)).collect(Collectors.toList());
            return new SessionList().setList(list).setIndex(Long.parseLong(headers.get(INDEX_HEADER)));
        });
    }

    @Override
    public Future<Void> destroySession(String id) {
        return this.requestVoid(HttpMethod.PUT, "/v1/session/destroy/" + Utils.urlEncode(id), null, null);
    }

    @Override
    public Future<String> createPreparedQuery(PreparedQueryDefinition definition) {
        return this.requestObject(HttpMethod.POST, "/v1/query", null, definition.toJson().encode(), (obj, headers) -> obj.getString("ID"));
    }

    @Override
    public Future<PreparedQueryDefinition> getPreparedQuery(String id) {
        return this.getPreparedQueryList(id).map(list -> (PreparedQueryDefinition)list.get(0));
    }

    @Override
    public Future<List<PreparedQueryDefinition>> getAllPreparedQueries() {
        return this.getPreparedQueryList(null);
    }

    @Override
    public Future<Void> updatePreparedQuery(PreparedQueryDefinition definition) {
        String path = "/v1/query/" + Utils.urlEncode(definition.getId());
        return this.requestVoid(HttpMethod.PUT, path, null, definition.toJson().encode());
    }

    private Future<List<PreparedQueryDefinition>> getPreparedQueryList(String id) {
        String path = "/v1/query" + (String)(id == null ? "" : "/" + Utils.urlEncode(id));
        return this.requestArray(HttpMethod.GET, path, null, null, (arr, headers) -> arr.stream().map(obj -> new PreparedQueryDefinition((JsonObject)obj)).collect(Collectors.toList()));
    }

    @Override
    public Future<Void> deletePreparedQuery(String id) {
        return this.requestVoid(HttpMethod.DELETE, "/v1/query/" + Utils.urlEncode(id), null, null);
    }

    @Override
    public Future<PreparedQueryExecuteResponse> executePreparedQuery(String query) {
        return this.executePreparedQueryWithOptions(query, null);
    }

    @Override
    public Future<PreparedQueryExecuteResponse> executePreparedQueryWithOptions(String query, PreparedQueryExecuteOptions options) {
        String path = "/v1/query/" + Utils.urlEncode(query) + "/execute";
        Query q = new Query();
        if (options != null) {
            q.put("near", options.getNear()).put("limit", options.getLimit());
        }
        return this.requestObject(HttpMethod.GET, path, q, null, (obj, headers) -> new PreparedQueryExecuteResponse().setService(obj.getString("Service")).setDc(obj.getString("Datacenter")).setFailovers(obj.getInteger("Failovers")).setDnsTtl(obj.getJsonObject("DNS").getString("TTL")).setNodes(obj.getJsonArray("Nodes").stream().map(o -> ServiceEntryParser.parse((JsonObject)o)).collect(Collectors.toList())));
    }

    @Override
    public Future<Void> registerCatalogService(Node nodeOptions, ServiceOptions serviceOptions) {
        String wanAddress;
        JsonObject nodeJsonOpts = new JsonObject().put("Node", (Object)nodeOptions.getName()).put("Address", (Object)nodeOptions.getAddress());
        if (this.notEmptyString(nodeOptions.getId())) {
            nodeJsonOpts.put("ID", (Object)nodeOptions.getId());
        }
        HashMap<String, String> taggedAddresses = new HashMap<String, String>();
        String lanAddress = nodeOptions.getLanAddress();
        if (lanAddress != null && !lanAddress.isEmpty()) {
            taggedAddresses.put("lan", lanAddress);
        }
        if ((wanAddress = nodeOptions.getWanAddress()) != null && !wanAddress.isEmpty()) {
            taggedAddresses.put("wan", wanAddress);
        }
        if (!taggedAddresses.isEmpty()) {
            nodeJsonOpts.put("TaggedAddresses", taggedAddresses);
        }
        if (this.notEmptyString(nodeOptions.getDatacenter())) {
            nodeJsonOpts.put("Datacenter", (Object)nodeOptions.getDatacenter());
        }
        if (nodeOptions.getNodeMeta() != null && !nodeOptions.getNodeMeta().isEmpty()) {
            nodeJsonOpts.put("NodeMeta", nodeOptions.getNodeMeta());
        }
        if (serviceOptions != null) {
            JsonObject serviceJsonOpts = new JsonObject().put("ID", (Object)serviceOptions.getId()).put("Service", (Object)serviceOptions.getName()).put("Tags", serviceOptions.getTags()).put("Address", (Object)serviceOptions.getAddress()).put("Port", (Object)serviceOptions.getPort()).put("Meta", serviceOptions.getMeta());
            nodeJsonOpts.put("Service", (Object)serviceJsonOpts);
        }
        Map map = nodeJsonOpts.getMap();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() != null) continue;
            nodeJsonOpts.remove((String)entry.getKey());
        }
        return this.requestVoid(HttpMethod.PUT, "/v1/catalog/register", null, nodeJsonOpts.encode());
    }

    private boolean notEmptyString(String str) {
        return str != null && !str.isEmpty();
    }

    @Override
    public Future<Void> deregisterCatalogService(String nodeId, String serviceId) {
        JsonObject jsonOpts = new JsonObject().put("Node", (Object)nodeId).put("ServiceID", (Object)serviceId);
        return this.requestVoid(HttpMethod.PUT, "/v1/catalog/deregister", null, jsonOpts.encode());
    }

    @Override
    public void close() {
        this.webClient.close();
    }

    private <T> Future<T> requestArray(HttpMethod method, String path, Query query, String body, BiFunction<JsonArray, MultiMap, T> mapper) {
        return this.request(DEFAULT_VALID_CODES, method, path, query, body, resp -> mapper.apply(resp.bodyAsJsonArray(), resp.headers()));
    }

    private <T> Future<T> requestObject(HttpMethod method, String path, Query query, String body, BiFunction<JsonObject, MultiMap, T> mapper) {
        return this.request(DEFAULT_VALID_CODES, method, path, query, body, resp -> mapper.apply(resp.bodyAsJsonObject(), resp.headers()));
    }

    private <T> Future<T> requestString(HttpMethod method, String path, Query query, String body, BiFunction<String, MultiMap, T> mapper) {
        return this.request(DEFAULT_VALID_CODES, method, path, query, body, resp -> mapper.apply(resp.bodyAsString().trim(), resp.headers()));
    }

    private <T> Future<T> requestVoid(HttpMethod method, String path, Query query, String body) {
        return this.request(DEFAULT_VALID_CODES, method, path, query, body, resp -> null);
    }

    private <T> Future<T> request(List<Integer> validCodes, HttpMethod method, String path, Query query, String body, Function<HttpResponse<Buffer>, T> mapper) {
        if (query == null) {
            query = new Query();
        }
        if (this.dc != null) {
            query.put("dc", this.dc);
        }
        HttpRequest rq = this.webClient.request(method, path);
        query.entrySet().forEach(e -> rq.addQueryParam((String)e.getKey(), (String)e.getValue()));
        if (this.aclToken != null) {
            rq.putHeader(TOKEN_HEADER, this.aclToken);
        }
        if (this.timeoutMs > 0L) {
            rq.timeout(this.timeoutMs);
        }
        return rq.sendBuffer(body == null ? Buffer.buffer() : Buffer.buffer((String)body)).map(resp -> {
            if (validCodes.contains(resp.statusCode())) {
                return mapper.apply((HttpResponse<Buffer>)resp);
            }
            throw new VertxException(String.format("Status message: '%s'. Body: '%s' ", resp.statusMessage(), resp.bodyAsString()), true);
        });
    }
}

