/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.VertxOptions;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import io.vertx.test.faketracer.FakeTracerFactory;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class VertxOptionsTest
extends VertxTestBase {
    @Test
    public void testOptions() {
        VertxOptions options = new VertxOptions();
        this.assertEquals(2 * Runtime.getRuntime().availableProcessors(), options.getEventLoopPoolSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setEventLoopPoolSize(rand));
        this.assertEquals(rand, options.getEventLoopPoolSize());
        try {
            options.setEventLoopPoolSize(0);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEquals(20L, options.getWorkerPoolSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setWorkerPoolSize(rand));
        this.assertEquals(rand, options.getWorkerPoolSize());
        try {
            options.setWorkerPoolSize(0);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEquals(20L, options.getInternalBlockingPoolSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setInternalBlockingPoolSize(rand));
        this.assertEquals(rand, options.getInternalBlockingPoolSize());
        try {
            options.setInternalBlockingPoolSize(0);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEquals(0L, options.getEventBusOptions().getPort());
        options.getEventBusOptions().setPort(1234);
        this.assertEquals(1234L, options.getEventBusOptions().getPort());
        try {
            options.getEventBusOptions().setPort(-1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            options.getEventBusOptions().setPort(65536);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEquals(-1L, options.getEventBusOptions().getClusterPublicPort());
        options.getEventBusOptions().setClusterPublicPort(1234);
        this.assertEquals(1234L, options.getEventBusOptions().getClusterPublicPort());
        try {
            options.getEventBusOptions().setClusterPublicPort(-1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            options.getEventBusOptions().setClusterPublicPort(65536);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertNull(options.getEventBusOptions().getHost());
        String randString = TestUtils.randomUnicodeString(100);
        options.getEventBusOptions().setHost(randString);
        this.assertEquals(randString, options.getEventBusOptions().getHost());
        this.assertEquals(null, options.getEventBusOptions().getClusterPublicHost());
        randString = TestUtils.randomUnicodeString(100);
        options.getEventBusOptions().setClusterPublicHost(randString);
        this.assertEquals(randString, options.getEventBusOptions().getClusterPublicHost());
        this.assertEquals(20000L, options.getEventBusOptions().getClusterPingInterval());
        long randomLong = TestUtils.randomPositiveLong();
        options.getEventBusOptions().setClusterPingInterval(randomLong);
        this.assertEquals(randomLong, options.getEventBusOptions().getClusterPingInterval());
        try {
            options.getEventBusOptions().setClusterPingInterval(-1L);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException e) {
            this.assertEquals(randomLong, options.getEventBusOptions().getClusterPingInterval());
        }
        this.assertEquals(20000L, options.getEventBusOptions().getClusterPingReplyInterval());
        randomLong = TestUtils.randomPositiveLong();
        options.getEventBusOptions().setClusterPingReplyInterval(randomLong);
        this.assertEquals(randomLong, options.getEventBusOptions().getClusterPingReplyInterval());
        try {
            options.getEventBusOptions().setClusterPingReplyInterval(-1L);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException e) {
            this.assertEquals(randomLong, options.getEventBusOptions().getClusterPingReplyInterval());
        }
        this.assertEquals(1000L, options.getBlockedThreadCheckInterval());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setBlockedThreadCheckInterval((long)rand));
        this.assertEquals(rand, options.getBlockedThreadCheckInterval());
        try {
            options.setBlockedThreadCheckInterval(0L);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.assertEquals(2000000000L, options.getMaxEventLoopExecuteTime());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setMaxEventLoopExecuteTime((long)rand));
        this.assertEquals(rand, options.getMaxEventLoopExecuteTime());
        try {
            options.setMaxEventLoopExecuteTime(0L);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.assertEquals(60000000000L, options.getMaxWorkerExecuteTime());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setMaxWorkerExecuteTime((long)rand));
        this.assertEquals(rand, options.getMaxWorkerExecuteTime());
        try {
            options.setMaxWorkerExecuteTime(0L);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        FakeClusterManager mgr = new FakeClusterManager();
        this.assertNull(options.getClusterManager());
        this.assertEquals(options, options.setClusterManager((ClusterManager)mgr));
        this.assertSame(mgr, options.getClusterManager());
        this.assertFalse(options.isHAEnabled());
        this.assertEquals(options, options.setHAEnabled(true));
        this.assertTrue(options.isHAEnabled());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(1L, options.getQuorumSize());
        this.assertEquals(options, options.setQuorumSize(rand));
        this.assertEquals(rand, options.getQuorumSize());
        try {
            options.setQuorumSize(0);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            options.setQuorumSize(-1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEquals("__DEFAULT__", options.getHAGroup());
        randString = TestUtils.randomUnicodeString(100);
        this.assertEquals(options, options.setHAGroup(randString));
        this.assertEquals(randString, options.getHAGroup());
        try {
            options.setHAGroup(null);
            this.fail("Should throw exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.assertNotNull(options.getMetricsOptions());
        try {
            options.setWarningExceptionTime(-1L);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertEquals(options, options.setWarningExceptionTime(1000000000L));
        this.assertEquals(1000000000L, options.getWarningExceptionTime());
        this.assertEquals(options, options.setMaxEventLoopExecuteTimeUnit(TimeUnit.SECONDS));
        this.assertEquals((Object)TimeUnit.SECONDS, (Object)options.getMaxEventLoopExecuteTimeUnit());
        this.assertEquals(options, options.setMaxWorkerExecuteTimeUnit(TimeUnit.MILLISECONDS));
        this.assertEquals((Object)TimeUnit.MILLISECONDS, (Object)options.getMaxWorkerExecuteTimeUnit());
        this.assertEquals(options, options.setWarningExceptionTimeUnit(TimeUnit.MINUTES));
        this.assertEquals((Object)TimeUnit.MINUTES, (Object)options.getWarningExceptionTimeUnit());
        this.assertEquals(options, options.setBlockedThreadCheckIntervalUnit(TimeUnit.MILLISECONDS));
        this.assertEquals((Object)TimeUnit.MILLISECONDS, (Object)options.getBlockedThreadCheckIntervalUnit());
    }

    @Test
    public void testCopyOptions() {
        VertxOptions options = new VertxOptions();
        int clusterPort = TestUtils.randomPortInt();
        int clusterPublicPort = TestUtils.randomPortInt();
        int eventLoopPoolSize = TestUtils.randomPositiveInt();
        int internalBlockingPoolSize = TestUtils.randomPositiveInt();
        int workerPoolSize = TestUtils.randomPositiveInt();
        int blockedThreadCheckInterval = TestUtils.randomPositiveInt();
        String clusterHost = TestUtils.randomAlphaString(100);
        String clusterPublicHost = TestUtils.randomAlphaString(100);
        long clusterPingInterval = TestUtils.randomPositiveLong();
        long clusterPingReplyInterval = TestUtils.randomPositiveLong();
        int maxEventLoopExecuteTime = TestUtils.randomPositiveInt();
        int maxWorkerExecuteTime = TestUtils.randomPositiveInt();
        Random rand = new Random();
        boolean haEnabled = rand.nextBoolean();
        boolean fileResolverCachingEnabled = rand.nextBoolean();
        boolean metricsEnabled = rand.nextBoolean();
        boolean useDaemonThread = rand.nextBoolean();
        int quorumSize = 51214;
        String haGroup = TestUtils.randomAlphaString(100);
        long warningExceptionTime = TestUtils.randomPositiveLong();
        TimeUnit maxEventLoopExecuteTimeUnit = TimeUnit.SECONDS;
        TimeUnit maxWorkerExecuteTimeUnit = TimeUnit.MILLISECONDS;
        TimeUnit warningExceptionTimeUnit = TimeUnit.MINUTES;
        TimeUnit blockedThreadCheckIntervalUnit = TimeUnit.MINUTES;
        options.getEventBusOptions().setPort(clusterPort);
        options.getEventBusOptions().setClusterPublicPort(clusterPublicPort);
        options.setEventLoopPoolSize(eventLoopPoolSize);
        options.setInternalBlockingPoolSize(internalBlockingPoolSize);
        options.setWorkerPoolSize(workerPoolSize);
        options.setBlockedThreadCheckInterval((long)blockedThreadCheckInterval);
        options.getEventBusOptions().setHost(clusterHost);
        options.getEventBusOptions().setClusterPublicHost(clusterPublicHost);
        options.getEventBusOptions().setClusterPingInterval(clusterPingInterval);
        options.getEventBusOptions().setClusterPingReplyInterval(clusterPingReplyInterval);
        options.setMaxEventLoopExecuteTime((long)maxEventLoopExecuteTime);
        options.setMaxWorkerExecuteTime((long)maxWorkerExecuteTime);
        options.setHAEnabled(haEnabled);
        options.setQuorumSize(quorumSize);
        options.setHAGroup(haGroup);
        options.setMetricsOptions(new MetricsOptions().setEnabled(metricsEnabled));
        options.setTracingOptions(new TracingOptions().setFactory((VertxTracerFactory)new FakeTracerFactory()));
        options.setWarningExceptionTime(warningExceptionTime);
        options.setMaxEventLoopExecuteTimeUnit(maxEventLoopExecuteTimeUnit);
        options.setMaxWorkerExecuteTimeUnit(maxWorkerExecuteTimeUnit);
        options.setWarningExceptionTimeUnit(warningExceptionTimeUnit);
        options.setBlockedThreadCheckIntervalUnit(blockedThreadCheckIntervalUnit);
        options.setUseDaemonThread(Boolean.valueOf(useDaemonThread));
        options = new VertxOptions(options);
        this.assertEquals(clusterPort, options.getEventBusOptions().getPort());
        this.assertEquals(clusterPublicPort, options.getEventBusOptions().getClusterPublicPort());
        this.assertEquals(clusterPingInterval, options.getEventBusOptions().getClusterPingInterval());
        this.assertEquals(clusterPingReplyInterval, options.getEventBusOptions().getClusterPingReplyInterval());
        this.assertEquals(eventLoopPoolSize, options.getEventLoopPoolSize());
        this.assertEquals(internalBlockingPoolSize, options.getInternalBlockingPoolSize());
        this.assertEquals(workerPoolSize, options.getWorkerPoolSize());
        this.assertEquals(blockedThreadCheckInterval, options.getBlockedThreadCheckInterval());
        this.assertEquals(clusterHost, options.getEventBusOptions().getHost());
        this.assertEquals(clusterPublicHost, options.getEventBusOptions().getClusterPublicHost());
        this.assertEquals(maxEventLoopExecuteTime, options.getMaxEventLoopExecuteTime());
        this.assertEquals(maxWorkerExecuteTime, options.getMaxWorkerExecuteTime());
        this.assertEquals(haEnabled, options.isHAEnabled());
        this.assertEquals(quorumSize, options.getQuorumSize());
        this.assertEquals(haGroup, options.getHAGroup());
        MetricsOptions metricsOptions = options.getMetricsOptions();
        this.assertNotNull(metricsOptions);
        this.assertEquals(metricsEnabled, metricsOptions.isEnabled());
        TracingOptions tracingOptions = options.getTracingOptions();
        this.assertNotNull(tracingOptions);
        this.assertTrue(tracingOptions.getFactory() instanceof FakeTracerFactory);
        this.assertEquals(warningExceptionTime, options.getWarningExceptionTime());
        this.assertEquals((Object)maxEventLoopExecuteTimeUnit, (Object)options.getMaxEventLoopExecuteTimeUnit());
        this.assertEquals((Object)maxWorkerExecuteTimeUnit, (Object)options.getMaxWorkerExecuteTimeUnit());
        this.assertEquals((Object)warningExceptionTimeUnit, (Object)options.getWarningExceptionTimeUnit());
        this.assertEquals((Object)blockedThreadCheckIntervalUnit, (Object)options.getBlockedThreadCheckIntervalUnit());
        this.assertEquals(useDaemonThread, options.getUseDaemonThread());
    }

    @Test
    public void testDefaultJsonOptions() {
        VertxOptions def = new VertxOptions();
        VertxOptions json = new VertxOptions(new JsonObject());
        this.assertEquals(def.getEventLoopPoolSize(), json.getEventLoopPoolSize());
        this.assertEquals(def.getWorkerPoolSize(), json.getWorkerPoolSize());
        this.assertEquals(def.getEventBusOptions().getHost(), json.getEventBusOptions().getHost());
        this.assertEquals(def.getEventBusOptions().getClusterPublicHost(), json.getEventBusOptions().getClusterPublicHost());
        this.assertEquals(def.getEventBusOptions().getClusterPublicPort(), json.getEventBusOptions().getClusterPublicPort());
        this.assertEquals(def.getEventBusOptions().getClusterPingInterval(), json.getEventBusOptions().getClusterPingInterval());
        this.assertEquals(def.getEventBusOptions().getClusterPingReplyInterval(), json.getEventBusOptions().getClusterPingReplyInterval());
        this.assertEquals(def.getBlockedThreadCheckInterval(), json.getBlockedThreadCheckInterval());
        this.assertEquals(def.getMaxEventLoopExecuteTime(), json.getMaxEventLoopExecuteTime());
        this.assertEquals(def.getMaxWorkerExecuteTime(), json.getMaxWorkerExecuteTime());
        this.assertEquals(def.getInternalBlockingPoolSize(), json.getInternalBlockingPoolSize());
        this.assertEquals(def.isHAEnabled(), json.isHAEnabled());
        this.assertEquals(def.getQuorumSize(), json.getQuorumSize());
        this.assertEquals(def.getHAGroup(), json.getHAGroup());
        this.assertEquals(def.getWarningExceptionTime(), json.getWarningExceptionTime());
        this.assertEquals((Object)def.getMaxEventLoopExecuteTimeUnit(), (Object)json.getMaxEventLoopExecuteTimeUnit());
        this.assertEquals((Object)def.getMaxWorkerExecuteTimeUnit(), (Object)json.getMaxWorkerExecuteTimeUnit());
        this.assertEquals((Object)def.getWarningExceptionTimeUnit(), (Object)json.getWarningExceptionTimeUnit());
        this.assertEquals((Object)def.getBlockedThreadCheckIntervalUnit(), (Object)json.getBlockedThreadCheckIntervalUnit());
        this.assertEquals(def.getUseDaemonThread(), json.getUseDaemonThread());
    }

    @Test
    public void testDefaultJsonVertxOptions() {
        VertxOptions vertxOptions1 = new VertxOptions();
        JsonObject json = vertxOptions1.toJson();
        VertxOptions vertxOptions2 = new VertxOptions(json);
        this.assertEquals(json, vertxOptions2.toJson());
    }

    @Test
    public void testJsonOptions() {
        VertxOptions options = new VertxOptions(new JsonObject());
        this.assertEquals(0L, options.getEventBusOptions().getPort());
        this.assertEquals(-1L, options.getEventBusOptions().getClusterPublicPort());
        this.assertEquals(20000L, options.getEventBusOptions().getClusterPingInterval());
        this.assertEquals(20000L, options.getEventBusOptions().getClusterPingReplyInterval());
        this.assertEquals(2 * Runtime.getRuntime().availableProcessors(), options.getEventLoopPoolSize());
        this.assertEquals(20L, options.getInternalBlockingPoolSize());
        this.assertEquals(20L, options.getWorkerPoolSize());
        this.assertEquals(1000L, options.getBlockedThreadCheckInterval());
        this.assertNull(options.getEventBusOptions().getHost());
        this.assertNull(options.getEventBusOptions().getClusterPublicHost());
        this.assertEquals(null, options.getClusterManager());
        this.assertEquals(2000000000L, options.getMaxEventLoopExecuteTime());
        this.assertEquals(60000000000L, options.getMaxWorkerExecuteTime());
        this.assertFalse(options.isHAEnabled());
        this.assertEquals(1L, options.getQuorumSize());
        this.assertEquals("__DEFAULT__", options.getHAGroup());
        this.assertNotNull(options.getMetricsOptions());
        this.assertEquals(5000000000L, options.getWarningExceptionTime());
        this.assertEquals((Object)TimeUnit.NANOSECONDS, (Object)options.getMaxEventLoopExecuteTimeUnit());
        this.assertEquals((Object)TimeUnit.NANOSECONDS, (Object)options.getMaxWorkerExecuteTimeUnit());
        this.assertEquals((Object)TimeUnit.NANOSECONDS, (Object)options.getWarningExceptionTimeUnit());
        this.assertEquals((Object)TimeUnit.MILLISECONDS, (Object)options.getBlockedThreadCheckIntervalUnit());
        int clusterPort = TestUtils.randomPortInt();
        int clusterPublicPort = TestUtils.randomPortInt();
        int eventLoopPoolSize = TestUtils.randomPositiveInt();
        int internalBlockingPoolSize = TestUtils.randomPositiveInt();
        int workerPoolSize = TestUtils.randomPositiveInt();
        int blockedThreadCheckInterval = TestUtils.randomPositiveInt();
        String clusterHost = TestUtils.randomAlphaString(100);
        String clusterPublicHost = TestUtils.randomAlphaString(100);
        long clusterPingInterval = TestUtils.randomPositiveLong();
        long clusterPingReplyInterval = TestUtils.randomPositiveLong();
        int maxEventLoopExecuteTime = TestUtils.randomPositiveInt();
        int maxWorkerExecuteTime = TestUtils.randomPositiveInt();
        int proxyOperationTimeout = TestUtils.randomPositiveInt();
        long warningExceptionTime = TestUtils.randomPositiveLong();
        Random rand = new Random();
        boolean haEnabled = rand.nextBoolean();
        boolean fileResolverCachingEnabled = rand.nextBoolean();
        int quorumSize = TestUtils.randomShort() + 1;
        String haGroup = TestUtils.randomAlphaString(100);
        boolean classPathResolvingEnabled = rand.nextBoolean();
        boolean metricsEnabled = rand.nextBoolean();
        boolean jmxEnabled = rand.nextBoolean();
        String jmxDomain = TestUtils.randomAlphaString(100);
        TimeUnit maxEventLoopExecuteTimeUnit = TimeUnit.SECONDS;
        TimeUnit maxWorkerExecuteTimeUnit = TimeUnit.MILLISECONDS;
        TimeUnit warningExceptionTimeUnit = TimeUnit.MINUTES;
        TimeUnit blockedThreadCheckIntervalUnit = TimeUnit.MINUTES;
        boolean useDaemonThread = rand.nextBoolean();
        options = new VertxOptions(new JsonObject().put("eventBusOptions", (Object)new JsonObject().put("port", (Object)clusterPort).put("clusterPublicPort", (Object)clusterPublicPort).put("host", (Object)clusterHost).put("clusterPublicHost", (Object)clusterPublicHost).put("clusterPingInterval", (Object)clusterPingInterval).put("clusterPingReplyInterval", (Object)clusterPingReplyInterval)).put("eventLoopPoolSize", (Object)eventLoopPoolSize).put("internalBlockingPoolSize", (Object)internalBlockingPoolSize).put("workerPoolSize", (Object)workerPoolSize).put("blockedThreadCheckInterval", (Object)blockedThreadCheckInterval).put("maxEventLoopExecuteTime", (Object)maxEventLoopExecuteTime).put("maxWorkerExecuteTime", (Object)maxWorkerExecuteTime).put("proxyOperationTimeout", (Object)proxyOperationTimeout).put("haEnabled", (Object)haEnabled).put("fileResolverCachingEnabled", (Object)fileResolverCachingEnabled).put("quorumSize", (Object)quorumSize).put("haGroup", (Object)haGroup).put("warningExceptionTime", (Object)warningExceptionTime).put("fileSystemOptions", (Object)new JsonObject().put("classPathResolvingEnabled", (Object)classPathResolvingEnabled).put("fileCachingEnabled", (Object)fileResolverCachingEnabled)).put("metricsOptions", (Object)new JsonObject().put("enabled", (Object)metricsEnabled).put("jmxEnabled", (Object)jmxEnabled).put("jmxDomain", (Object)jmxDomain)).put("tracingOptions", (Object)new JsonObject()).put("maxEventLoopExecuteTimeUnit", (Object)maxEventLoopExecuteTimeUnit).put("maxWorkerExecuteTimeUnit", (Object)maxWorkerExecuteTimeUnit).put("warningExceptionTimeUnit", (Object)warningExceptionTimeUnit).put("blockedThreadCheckIntervalUnit", (Object)blockedThreadCheckIntervalUnit).put("useDaemonThread", (Object)useDaemonThread));
        this.assertEquals(clusterPort, options.getEventBusOptions().getPort());
        this.assertEquals(clusterPublicPort, options.getEventBusOptions().getClusterPublicPort());
        this.assertEquals(clusterPublicHost, options.getEventBusOptions().getClusterPublicHost());
        this.assertEquals(clusterPingInterval, options.getEventBusOptions().getClusterPingInterval());
        this.assertEquals(clusterPingReplyInterval, options.getEventBusOptions().getClusterPingReplyInterval());
        this.assertEquals(eventLoopPoolSize, options.getEventLoopPoolSize());
        this.assertEquals(internalBlockingPoolSize, options.getInternalBlockingPoolSize());
        this.assertEquals(workerPoolSize, options.getWorkerPoolSize());
        this.assertEquals(blockedThreadCheckInterval, options.getBlockedThreadCheckInterval());
        this.assertEquals(clusterHost, options.getEventBusOptions().getHost());
        this.assertEquals(null, options.getClusterManager());
        this.assertEquals(maxEventLoopExecuteTime, options.getMaxEventLoopExecuteTime());
        this.assertEquals(maxWorkerExecuteTime, options.getMaxWorkerExecuteTime());
        this.assertEquals(haEnabled, options.isHAEnabled());
        this.assertEquals(quorumSize, options.getQuorumSize());
        this.assertEquals(haGroup, options.getHAGroup());
        FileSystemOptions fileSystemOptions = options.getFileSystemOptions();
        this.assertEquals(classPathResolvingEnabled, fileSystemOptions.isClassPathResolvingEnabled());
        this.assertEquals(fileResolverCachingEnabled, fileSystemOptions.isFileCachingEnabled());
        MetricsOptions metricsOptions = options.getMetricsOptions();
        this.assertEquals(metricsEnabled, metricsOptions.isEnabled());
        this.assertNotNull(options.getTracingOptions());
        this.assertEquals(warningExceptionTime, options.getWarningExceptionTime());
        this.assertEquals((Object)maxEventLoopExecuteTimeUnit, (Object)options.getMaxEventLoopExecuteTimeUnit());
        this.assertEquals((Object)maxWorkerExecuteTimeUnit, (Object)options.getMaxWorkerExecuteTimeUnit());
        this.assertEquals((Object)warningExceptionTimeUnit, (Object)options.getWarningExceptionTimeUnit());
        this.assertEquals((Object)blockedThreadCheckIntervalUnit, (Object)options.getBlockedThreadCheckIntervalUnit());
        this.assertEquals(useDaemonThread, options.getUseDaemonThread());
    }
}

