/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.VertxOptions;
import io.vertx.test.core.VertxTestBase;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class VertxUseDaemonThreadTest
extends VertxTestBase {
    @Parameterized.Parameter
    public Boolean useDaemonThread;

    @Parameterized.Parameters(name="{index}: useDaemonThread={0}")
    public static List<Object[]> params() {
        return Arrays.asList({true}, {false}, {null});
    }

    @Override
    protected VertxOptions getOptions() {
        return super.getOptions().setUseDaemonThread(this.useDaemonThread);
    }

    @Test
    public void testUseDaemonThread() {
        this.vertx.runOnContext(v -> {
            Thread current = Thread.currentThread();
            if (this.useDaemonThread != null) {
                this.assertEquals((boolean)this.useDaemonThread, current.isDaemon());
            } else {
                this.assertFalse(current.isDaemon());
            }
            this.testComplete();
        });
        this.await();
    }
}

