/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.core.VertxOptions;
import io.vertx.core.impl.Utils;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import org.junit.Assume;
import org.junit.Test;

public class ClusterHostTest
extends VertxTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        Assume.assumeTrue((boolean)Utils.isLinux());
    }

    @Test
    public void testClusterHostHintFromClusterManager() {
        FakeClusterManager clusterManager = new FakeClusterManager(){

            public String clusterHost() {
                return "127.0.0.3";
            }
        };
        this.clusteredVertx(new VertxOptions().setClusterManager((ClusterManager)clusterManager), this.onSuccess(clusteredVertx -> this.assertEquals("127.0.0.3", clusterManager.getNodeInfo().host())));
    }

    @Test
    public void testClusterPublicHostHintFromClusterManager() {
        FakeClusterManager clusterManager = new FakeClusterManager(){

            public String clusterHost() {
                return "127.0.0.2";
            }

            public String clusterPublicHost() {
                return "127.0.0.3";
            }
        };
        this.clusteredVertx(new VertxOptions().setClusterManager((ClusterManager)clusterManager), this.onSuccess(clusteredVertx -> this.assertEquals("127.0.0.3", clusterManager.getNodeInfo().host())));
    }

    @Test
    public void testUserSuppliedHostPrecedence() {
        FakeClusterManager clusterManager = new FakeClusterManager(){

            public String clusterHost() {
                return "127.0.0.2";
            }

            public String clusterPublicHost() {
                return "127.0.0.3";
            }
        };
        VertxOptions options = new VertxOptions().setClusterManager((ClusterManager)clusterManager);
        options.getEventBusOptions().setHost("127.0.0.4");
        this.clusteredVertx(options, this.onSuccess(clusteredVertx -> this.assertEquals("127.0.0.4", clusterManager.getNodeInfo().host())));
    }
}

