/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.vertx.core.file.FileResolverTestBase;
import io.vertx.core.file.ZipFileResolverTest;
import io.vertx.test.core.TestUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.junit.Assert;

public class WarFileResolverTest
extends FileResolverTestBase {
    static File getFiles(File baseDir) throws Exception {
        File file = Files.createTempFile(TestUtils.MAVEN_TARGET_DIR.toPath(), "", "files.war", new FileAttribute[0]).toFile();
        Assert.assertTrue((boolean)file.delete());
        return ZipFileResolverTest.getFiles(baseDir, file, out -> {
            try {
                return new JarOutputStream((OutputStream)out);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }, JarEntry::new);
    }

    @Override
    protected ClassLoader resourcesLoader(File baseDir) throws Exception {
        File files = WarFileResolverTest.getFiles(baseDir);
        return new URLClassLoader(new URL[]{files.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
    }
}

