/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.ReadStream;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class HttpRequestStreamTest
extends VertxTestBase {
    private HttpServer server;
    private NetClient netClient;
    private HttpClient client;

    @Override
    protected void tearDown() throws Exception {
        if (this.netClient != null) {
            this.netClient.close();
        }
        if (this.client != null) {
            this.client.close();
        }
        if (this.server != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.server.close(asyncResult -> {
                this.assertTrue(asyncResult.succeeded());
                latch.countDown();
            });
            this.awaitLatch(latch);
        }
        super.tearDown();
    }

    @Test
    public void testReadStreamPauseResume() {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setAcceptBacklog(10).setPort(8080));
        ReadStream httpStream = this.server.requestStream();
        AtomicBoolean paused = new AtomicBoolean();
        httpStream.handler(req -> {
            this.assertFalse(paused.get());
            HttpServerResponse response = req.response();
            response.setStatusCode(200).end();
            response.close();
        });
        this.server.listen(listenAR -> {
            this.assertTrue(listenAR.succeeded());
            paused.set(true);
            httpStream.pause();
            this.netClient = this.vertx.createNetClient(new NetClientOptions().setConnectTimeout(1000));
            this.netClient.connect(8080, "localhost", socketAR -> {
                this.assertTrue(socketAR.succeeded());
                NetSocket socket = (NetSocket)socketAR.result();
                socket.write("GET / HTTP/1.1\r\n\r\n");
                Buffer buffer = Buffer.buffer();
                socket.handler(arg_0 -> ((Buffer)buffer).appendBuffer(arg_0));
                socket.closeHandler(v -> {
                    this.assertEquals(0L, buffer.length());
                    paused.set(false);
                    httpStream.resume();
                    this.client = this.vertx.createHttpClient(new HttpClientOptions());
                    this.client.request(new RequestOptions().setPort(Integer.valueOf(8080)).setHost("localhost").setURI(path)).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
                        this.assertEquals(200L, resp.statusCode());
                        this.testComplete();
                    }))));
                });
            });
        });
        this.await();
    }

    @Test
    public void testClosingServerClosesRequestStreamEndHandler() {
        this.waitFor(2);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        ReadStream stream = this.server.requestStream();
        stream.endHandler(v -> this.complete());
        stream.handler(req -> {});
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.server.close(v -> {
                this.assertTrue(ar.succeeded());
                this.complete();
            });
        });
        this.await();
    }

    @Test
    public void testCloseServerAsynchronously() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        AtomicInteger done = new AtomicInteger();
        ReadStream stream = this.server.requestStream();
        stream.handler(req -> {});
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        stream.endHandler(v -> {
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.assertNull(stack.get());
            if (done.incrementAndGet() == 2) {
                this.testComplete();
            }
        });
        this.server.listen(ar -> {
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.assertNull(stack.get());
            this.server.close(v -> {
                this.assertTrue(Vertx.currentContext().isEventLoopContext());
                if (done.incrementAndGet() == 2) {
                    this.testComplete();
                }
            });
        });
        this.await();
    }
}

