/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.RequestOptions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Test;

public class HttpClientRequestBaseTest
extends HttpTestBase {
    @Test
    public void testPathCacheAndQueryCache() {
        this.server.requestHandler(req -> {});
        this.server.listen(this.testAddress, this.onSuccess(server -> this.client.request(new RequestOptions(this.requestOptions).setURI("/?"), this.onSuccess(req -> {
            this.assertThat(req.getURI(), CoreMatchers.is((Object)"/?"));
            this.assertThat(req.path(), CoreMatchers.is((Object)"/"));
            this.assertThat(req.query(), CoreMatchers.is((Object)""));
            req.setURI("/index.html");
            this.assertThat(req.getURI(), CoreMatchers.is((Object)"/index.html"));
            this.assertThat(req.path(), CoreMatchers.is((Object)"/index.html"));
            this.assertThat(req.query(), CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            req.setURI("/foo?bar");
            this.assertThat(req.getURI(), CoreMatchers.is((Object)"/foo?bar"));
            this.assertThat(req.path(), CoreMatchers.is((Object)"/foo"));
            this.assertThat(req.query(), CoreMatchers.is((Object)"bar"));
            req.setURI("/baz?key=value");
            this.assertThat(req.getURI(), CoreMatchers.is((Object)"/baz?key=value"));
            this.assertThat(req.path(), CoreMatchers.is((Object)"/baz"));
            this.assertThat(req.query(), CoreMatchers.is((Object)"key=value"));
            req.setURI("");
            this.assertThat(req.getURI(), CoreMatchers.is((Object)""));
            this.assertThat(req.path(), CoreMatchers.is((Object)""));
            this.assertThat(req.query(), CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            req.setURI("?");
            this.assertThat(req.getURI(), CoreMatchers.is((Object)"?"));
            this.assertThat(req.path(), CoreMatchers.is((Object)""));
            this.assertThat(req.query(), CoreMatchers.is((Object)""));
            this.testComplete();
        }))));
        this.await();
    }
}

