/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher;

import io.vertx.core.Launcher;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.launcher.commands.CommandTestBase;
import io.vertx.core.impl.launcher.commands.HttpTestVerticle;
import io.vertx.core.impl.launcher.commands.RunCommandTest;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.launcher.DefaultCommand;
import io.vertx.test.fakecluster.FakeClusterManager;
import io.vertx.test.fakemetrics.FakeMetricsFactory;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class LauncherExtensibilityTest
extends CommandTestBase {
    private static AtomicReference<Boolean> spy = new AtomicReference();
    private Vertx vertx;

    @Override
    @After
    public void tearDown() throws InterruptedException {
        spy.set(false);
        super.tearDown();
        this.close(this.vertx);
    }

    @Test
    public void testExtendingMainVerticle() {
        Launcher myLauncher = new Launcher(){

            protected String getMainVerticle() {
                return HttpTestVerticle.class.getName();
            }

            public void afterStartingVertx(Vertx vertx) {
                LauncherExtensibilityTest.this.vertx = vertx;
            }
        };
        myLauncher.dispatch(new String[0]);
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
    }

    @Test
    public void testThatALauncherCanAddACommand() {
        Launcher myLauncher = new Launcher(){

            protected void load() {
                super.load();
                this.register(FooCommand.class);
            }
        };
        myLauncher.dispatch(new String[]{"foo"});
        Assertions.assertThat((Iterable)myLauncher.getCommandNames()).contains((Object[])new String[]{"foo"});
        this.assertWaitUntil(spy::get);
    }

    @Test
    public void testThatALauncherCanHideACommand() {
        Launcher myLauncher = new Launcher(){

            protected void load() {
                super.load();
                this.unregister("start");
            }
        };
        this.record();
        myLauncher.dispatch(new String[]{"start"});
        this.stop();
        Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"The command 'start' is not a valid command."});
        Assertions.assertThat((Iterable)myLauncher.getCommandNames()).doesNotContain((Object[])new String[]{"start"});
    }

    @Test
    public void testThatCustomLauncherCanUpdateConfigurationWhenNoneArePassed() throws IOException {
        final long time = System.nanoTime();
        Launcher myLauncher = new Launcher(){

            protected String getMainVerticle() {
                return HttpTestVerticle.class.getName();
            }

            public void afterStartingVertx(Vertx vertx) {
                LauncherExtensibilityTest.this.vertx = vertx;
            }

            public void afterConfigParsed(JsonObject config) {
                config.put("time", (Object)time);
            }
        };
        myLauncher.dispatch(new String[0]);
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        Assertions.assertThat((Long)RunCommandTest.getContent().getJsonObject("conf").getLong("time")).isEqualTo(time);
    }

    @Test
    public void testThatCustomLauncherCanUpdateConfiguration() throws IOException {
        final long time = System.nanoTime();
        Launcher myLauncher = new Launcher(){

            protected String getMainVerticle() {
                return HttpTestVerticle.class.getName();
            }

            public void afterStartingVertx(Vertx vertx) {
                LauncherExtensibilityTest.this.vertx = vertx;
            }

            public void afterConfigParsed(JsonObject config) {
                config.put("time", (Object)time);
            }
        };
        myLauncher.dispatch(new String[]{"-conf=\"{\"time\":345667}"});
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        Assertions.assertThat((Long)RunCommandTest.getContent().getJsonObject("conf").getLong("time")).isEqualTo(time);
    }

    @Test
    public void testThatCustomLauncherCanCustomizeMetricsOption() throws Exception {
        Launcher myLauncher = new Launcher(){

            protected String getMainVerticle() {
                return HttpTestVerticle.class.getName();
            }

            public void afterStartingVertx(Vertx vertx) {
                LauncherExtensibilityTest.this.vertx = vertx;
            }

            public void beforeStartingVertx(VertxOptions options) {
                options.getMetricsOptions().setEnabled(true).setFactory((VertxMetricsFactory)new FakeMetricsFactory());
            }
        };
        myLauncher.dispatch(new String[0]);
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        Assertions.assertThat((Boolean)RunCommandTest.getContent().getBoolean("metrics")).isEqualTo(true);
    }

    @Test
    public void testThatCustomLauncherCanCustomizeClusterManager() throws Exception {
        final FakeClusterManager clusterManager = new FakeClusterManager();
        Launcher myLauncher = new Launcher(){

            protected String getMainVerticle() {
                return HttpTestVerticle.class.getName();
            }

            public void afterStartingVertx(Vertx vertx) {
                LauncherExtensibilityTest.this.vertx = vertx;
            }

            public void beforeStartingVertx(VertxOptions options) {
                options.setClusterManager((ClusterManager)clusterManager);
            }
        };
        myLauncher.dispatch(new String[]{"-cluster"});
        this.assertWaitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
        Assertions.assertThat((Boolean)RunCommandTest.getContent().getBoolean("clustered")).isEqualTo(true);
        Assert.assertSame((Object)clusterManager, (Object)((VertxInternal)this.vertx).getClusterManager());
    }

    @Name(value="foo")
    public static class FooCommand
    extends DefaultCommand {
        public void run() throws CLIException {
            spy.set(true);
        }
    }
}

