/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.utils;

import io.vertx.core.impl.utils.ConcurrentCyclicSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentCyclicSequenceTest {
    @Test
    public void testEmpty() {
        ConcurrentCyclicSequence empty = new ConcurrentCyclicSequence();
        for (int j = 0; j < 1; ++j) {
            for (int i = 0; i < 3; ++i) {
                Assert.assertEquals((long)0L, (long)empty.size());
                Assert.assertEquals((long)0L, (long)empty.index());
                Assert.assertEquals(null, (Object)empty.first());
                empty.next();
            }
            empty = empty.remove((Object)"does-not-exist");
        }
    }

    @Test
    public void testAdd() {
        ConcurrentCyclicSequence seq = new ConcurrentCyclicSequence().add((Object)"s1");
        Assert.assertEquals(Collections.singletonList("s1"), ConcurrentCyclicSequenceTest.toList(seq));
        Assert.assertEquals(Arrays.asList("s1", "s2"), ConcurrentCyclicSequenceTest.toList(seq.add((Object)"s2")));
        Assert.assertEquals(Collections.singletonList("s1"), ConcurrentCyclicSequenceTest.toList(seq));
    }

    @Test
    public void testRemove() {
        ConcurrentCyclicSequence seq = new ConcurrentCyclicSequence().add((Object)"s1").add((Object)"s2").add((Object)"s1").add((Object)"s2");
        Assert.assertEquals(Arrays.asList("s1", "s2", "s1", "s2"), ConcurrentCyclicSequenceTest.toList(seq));
        Assert.assertEquals(Arrays.asList("s1", "s1", "s2"), ConcurrentCyclicSequenceTest.toList(seq.remove((Object)"s2")));
        Assert.assertEquals(Arrays.asList("s1", "s1"), ConcurrentCyclicSequenceTest.toList(seq.remove((Object)"s2").remove((Object)"s2")));
        Assert.assertEquals(Arrays.asList("s2", "s1", "s2"), ConcurrentCyclicSequenceTest.toList(seq.remove((Object)"s1")));
        Assert.assertEquals(Arrays.asList("s2", "s2"), ConcurrentCyclicSequenceTest.toList(seq.remove((Object)"s1").remove((Object)"s1")));
        Assert.assertEquals(Arrays.asList("s1", "s2"), ConcurrentCyclicSequenceTest.toList(seq.remove((Object)"s1").remove((Object)"s2")));
        Assert.assertEquals(Collections.emptyList(), ConcurrentCyclicSequenceTest.toList(seq.remove((Object)"s1").remove((Object)"s2").remove((Object)"s1").remove((Object)"s2")));
        Assert.assertEquals(Arrays.asList("s1", "s2", "s1", "s2"), ConcurrentCyclicSequenceTest.toList(seq));
    }

    @Test
    public void testNullElement() {
        ConcurrentCyclicSequence seq = new ConcurrentCyclicSequence((Object[])new String[]{"s1", null, "s2", null});
        Assert.assertEquals(Arrays.asList("s1", null, "s2", null), ConcurrentCyclicSequenceTest.toList(seq));
        Assert.assertEquals(Arrays.asList("s1", "s2", null), ConcurrentCyclicSequenceTest.toList(seq.remove(null)));
    }

    @Test
    public void testRoundRobin() throws Exception {
        int iter = 1000000;
        int range = 10;
        ConcurrentCyclicSequence tmp = new ConcurrentCyclicSequence();
        for (int i = 0; i < range; ++i) {
            tmp = tmp.add((Object)new AtomicInteger());
        }
        ConcurrentCyclicSequence handlers = tmp;
        AtomicBoolean failed = new AtomicBoolean();
        int numThreads = 10;
        Thread[] threads = new Thread[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(() -> {
                try {
                    for (int j = 0; j < iter; ++j) {
                        ((AtomicInteger)handlers.next()).incrementAndGet();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    failed.set(true);
                }
            });
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        for (AtomicInteger i : handlers) {
            Assert.assertEquals((long)iter, (long)i.get());
        }
        Assert.assertFalse((boolean)failed.get());
        int pos = handlers.index();
        Assert.assertTrue((String)("Incorrect pos value " + pos), (pos <= range ? 1 : 0) != 0);
    }

    private static <T> List<T> toList(ConcurrentCyclicSequence<T> seq) {
        ArrayList ret = new ArrayList();
        for (Object elt : seq) {
            ret.add(elt);
        }
        return ret;
    }

    @Test
    public void testIteratorOfEmpty() {
        ConcurrentCyclicSequence empty = new ConcurrentCyclicSequence();
        this.advance((ConcurrentCyclicSequence<String>)empty, 3);
        Iterator it1 = empty.iterator(false);
        Assertions.assertThat(ConcurrentCyclicSequenceTest.toList(it1)).isEmpty();
        Assert.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)it1.next();
        });
        Iterator it2 = empty.iterator(true);
        Assertions.assertThat(ConcurrentCyclicSequenceTest.toList(it2)).isEmpty();
        Assert.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)it2.next();
        });
    }

    @Test
    public void testIteratorOfSingleton() {
        ConcurrentCyclicSequence singleton = new ConcurrentCyclicSequence((Object[])new String[]{"precious"});
        this.advance((ConcurrentCyclicSequence<String>)singleton, 4);
        Iterator it1 = singleton.iterator(false);
        Assertions.assertThat(ConcurrentCyclicSequenceTest.toList(it1)).containsExactly((Object[])new String[]{"precious"});
        Assert.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)it1.next();
        });
        Iterator it2 = singleton.iterator(true);
        Assertions.assertThat(ConcurrentCyclicSequenceTest.toList(it2)).containsExactly((Object[])new String[]{"precious"});
        Assert.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)it2.next();
        });
    }

    @Test
    public void testIterator() {
        ConcurrentCyclicSequence seq = new ConcurrentCyclicSequence((Object[])new String[]{"foo", "bar", "baz", "qux"});
        this.advance((ConcurrentCyclicSequence<String>)seq, 2 * seq.size() + 3);
        Iterator it1 = seq.iterator(false);
        Assertions.assertThat(ConcurrentCyclicSequenceTest.toList(it1)).containsExactly((Object[])new String[]{"qux", "foo", "bar", "baz"});
        Assert.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)it1.next();
        });
        Iterator it2 = seq.iterator(true);
        Assertions.assertThat(ConcurrentCyclicSequenceTest.toList(it2)).containsExactly((Object[])new String[]{"foo", "bar", "baz", "qux"});
        Assert.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)it2.next();
        });
    }

    private void advance(ConcurrentCyclicSequence<String> seq, int n) {
        for (int i = 0; i < n; ++i) {
            seq.next();
        }
    }

    private static <T> List<T> toList(Iterator<T> it) {
        ArrayList ret = new ArrayList();
        it.forEachRemaining(ret::add);
        return ret;
    }
}

