/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.pkcs1;

import io.vertx.core.Vertx;
import io.vertx.core.net.impl.pkcs1.PrivateKeyParser;
import io.vertx.test.core.TestUtils;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECPrivateKeySpec;
import java.util.Base64;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assume;
import org.junit.Test;

public class PrivateKeyParserTest {
    @Test
    public void testGetPKCS8EncodedKeySpecSupportsRSA() {
        byte[] pkcs8 = new byte[]{48, 18, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0};
        this.assertKeySpecType(pkcs8, "RSA");
    }

    @Test
    public void testGetPKCS8EncodedKeySpecSupportsEC() {
        byte[] pkcs8 = new byte[]{48, 24, 2, 1, 0, 48, 19, 6, 7, 42, -122, 72, -50, 61, 2, 1, 6, 8, 42, -122, 72, -50, 61, 3, 1, 7};
        this.assertKeySpecType(pkcs8, "EC");
    }

    private void assertKeySpecType(byte[] encodedKey, String expectedAlgorithm) {
        String keyAlgorithm = PrivateKeyParser.getPKCS8EncodedKeyAlgorithm((byte[])encodedKey);
        MatcherAssert.assertThat((Object)keyAlgorithm, (Matcher)CoreMatchers.is((Object)expectedAlgorithm));
    }

    @Test
    public void testGetECKeySpecSucceedsForDEREncodedECPrivateKey() throws GeneralSecurityException {
        Assume.assumeTrue((String)"ECC is not supported by VM's security providers", (boolean)TestUtils.isECCSupportedByVM());
        Vertx vertx = Vertx.vertx();
        String b = vertx.fileSystem().readFileBlocking("tls/server-key-ec-pkcs1.pem").toString(StandardCharsets.US_ASCII).replaceAll("-----BEGIN EC PRIVATE KEY-----", "").replaceAll("-----END EC PRIVATE KEY-----", "").replaceAll("\\s", "");
        byte[] derEncoding = Base64.getDecoder().decode(b);
        ECPrivateKeySpec spec = PrivateKeyParser.getECKeySpec((byte[])derEncoding);
        KeyFactory factory = KeyFactory.getInstance("EC");
        ECPrivateKey key = (ECPrivateKey)factory.generatePrivate(spec);
        MatcherAssert.assertThat((Object)key, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)key.getAlgorithm(), (Matcher)CoreMatchers.is((Object)"EC"));
    }
}

