/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.SharedCounterTest;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.fakecluster.FakeClusterManager;
import org.junit.Test;

public class ClusteredSharedCounterTest
extends SharedCounterTest {
    protected final int numNodes = 2;
    int pos;

    @Override
    protected ClusterManager getClusterManager() {
        return new FakeClusterManager();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.startNodes(2);
    }

    @Test
    public void testGetLocalCounter() {
        Vertx node1 = this.getVertx();
        Vertx node2 = this.getVertx();
        this.assertNotSame(node1, node2);
        CompositeFuture.all((Future)node1.sharedData().getLocalCounter("counter"), (Future)node2.sharedData().getLocalCounter("counter")).compose(compFuture -> {
            Counter counterNode1 = (Counter)((CompositeFuture)compFuture.result()).resultAt(0);
            Counter counterNode2 = (Counter)((CompositeFuture)compFuture.result()).resultAt(1);
            return CompositeFuture.all((Future)counterNode1.addAndGet(1L), (Future)counterNode2.addAndGet(2L));
        }).onComplete(this.onSuccess(asyncCompFuture -> {
            long valueCounterNode1 = (Long)((CompositeFuture)asyncCompFuture.result()).resultAt(0);
            long valueCounterNode2 = (Long)((CompositeFuture)asyncCompFuture.result()).resultAt(1);
            this.assertEquals(valueCounterNode1, 1L);
            this.assertEquals(valueCounterNode2, 2L);
            this.testComplete();
        }));
        this.await();
    }

    @Override
    protected Vertx getVertx() {
        Vertx vertx = this.vertices[this.pos];
        if (++this.pos == 2) {
            this.pos = 0;
        }
        return vertx;
    }
}

