/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Counter;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class SharedCounterTest
extends VertxTestBase {
    protected Vertx getVertx() {
        return this.vertx;
    }

    @Test
    public void testIllegalArguments() throws Exception {
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getCounter(null, ar -> {}));
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getCounter("foo", null));
        this.getVertx().sharedData().getCounter("foo", ar -> {
            Counter counter = (Counter)ar.result();
            TestUtils.assertNullPointerException(() -> counter.get(null));
            TestUtils.assertNullPointerException(() -> counter.incrementAndGet(null));
            TestUtils.assertNullPointerException(() -> counter.getAndIncrement(null));
            TestUtils.assertNullPointerException(() -> counter.decrementAndGet(null));
            TestUtils.assertNullPointerException(() -> counter.addAndGet(1L, null));
            TestUtils.assertNullPointerException(() -> counter.getAndAdd(1L, null));
            TestUtils.assertNullPointerException(() -> counter.compareAndSet(1L, 1L, null));
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testGet() {
        this.getVertx().sharedData().getCounter("foo", ar -> {
            this.assertTrue(ar.succeeded());
            Counter counter = (Counter)ar.result();
            counter.get(ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(0L, (Long)ar2.result());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testIncrementAndGet() {
        this.getVertx().sharedData().getCounter("foo", ar -> {
            this.assertTrue(ar.succeeded());
            Counter counter = (Counter)ar.result();
            counter.incrementAndGet(ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(1L, (Long)ar2.result());
                this.getVertx().sharedData().getCounter("foo", ar3 -> {
                    this.assertTrue(ar3.succeeded());
                    Counter counter2 = (Counter)ar3.result();
                    counter2.incrementAndGet(ar4 -> {
                        this.assertTrue(ar4.succeeded());
                        this.assertEquals(2L, (Long)ar4.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testGetAndIncrement() {
        this.getVertx().sharedData().getCounter("foo", ar -> {
            this.assertTrue(ar.succeeded());
            Counter counter = (Counter)ar.result();
            counter.getAndIncrement(ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(0L, (Long)ar2.result());
                this.getVertx().sharedData().getCounter("foo", ar3 -> {
                    this.assertTrue(ar3.succeeded());
                    Counter counter2 = (Counter)ar3.result();
                    counter2.getAndIncrement(ar4 -> {
                        this.assertTrue(ar4.succeeded());
                        this.assertEquals(1L, (Long)ar4.result());
                        counter2.get(ar5 -> {
                            this.assertTrue(ar5.succeeded());
                            this.assertEquals(2L, (Long)ar5.result());
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testDecrementAndGet() {
        this.getVertx().sharedData().getCounter("foo", ar -> {
            this.assertTrue(ar.succeeded());
            Counter counter = (Counter)ar.result();
            counter.decrementAndGet(ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(-1L, (Long)ar2.result());
                this.getVertx().sharedData().getCounter("foo", ar3 -> {
                    this.assertTrue(ar3.succeeded());
                    Counter counter2 = (Counter)ar3.result();
                    counter2.decrementAndGet(ar4 -> {
                        this.assertTrue(ar4.succeeded());
                        this.assertEquals(-2L, (Long)ar4.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testAddAndGet() {
        this.getVertx().sharedData().getCounter("foo", ar -> {
            this.assertTrue(ar.succeeded());
            Counter counter = (Counter)ar.result();
            counter.addAndGet(2L, ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(2L, (Long)ar2.result());
                this.getVertx().sharedData().getCounter("foo", ar3 -> {
                    this.assertTrue(ar3.succeeded());
                    Counter counter2 = (Counter)ar3.result();
                    counter2.addAndGet(2L, ar4 -> {
                        this.assertTrue(ar4.succeeded());
                        this.assertEquals(4L, (Long)ar4.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void getAndAdd() {
        this.getVertx().sharedData().getCounter("foo", ar -> {
            this.assertTrue(ar.succeeded());
            Counter counter = (Counter)ar.result();
            counter.getAndAdd(2L, ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(0L, (Long)ar2.result());
                this.getVertx().sharedData().getCounter("foo", ar3 -> {
                    this.assertTrue(ar3.succeeded());
                    Counter counter2 = (Counter)ar3.result();
                    counter2.getAndAdd(2L, ar4 -> {
                        this.assertTrue(ar4.succeeded());
                        this.assertEquals(2L, (Long)ar4.result());
                        counter2.get(ar5 -> {
                            this.assertTrue(ar5.succeeded());
                            this.assertEquals(4L, (Long)ar5.result());
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testCompareAndSet() {
        this.getVertx().sharedData().getCounter("foo", ar -> {
            this.assertTrue(ar.succeeded());
            Counter counter = (Counter)ar.result();
            counter.compareAndSet(0L, 2L, this.onSuccess(result -> this.getVertx().sharedData().getCounter("foo", ar3 -> {
                this.assertTrue(ar3.succeeded());
                Counter counter2 = (Counter)ar3.result();
                counter2.compareAndSet(2L, 4L, ar4 -> {
                    this.assertTrue(ar4.succeeded());
                    this.assertTrue((Boolean)ar4.result());
                    counter2.compareAndSet(3L, 5L, ar5 -> {
                        this.assertTrue(ar5.succeeded());
                        this.assertFalse((Boolean)ar5.result());
                        this.testComplete();
                    });
                });
            })));
        });
        this.await();
    }

    @Test
    public void testDifferentCounters() {
        this.getVertx().sharedData().getCounter("foo", ar -> {
            this.assertTrue(ar.succeeded());
            Counter counter = (Counter)ar.result();
            counter.incrementAndGet(this.onSuccess(res -> {
                this.assertEquals(1L, (long)res);
                this.getVertx().sharedData().getCounter("bar", ar3 -> {
                    this.assertTrue(ar3.succeeded());
                    Counter counter2 = (Counter)ar3.result();
                    counter2.incrementAndGet(ar4 -> {
                        this.assertEquals(1L, (Long)ar4.result());
                        counter.incrementAndGet(ar5 -> {
                            this.assertEquals(2L, (Long)ar5.result());
                            this.testComplete();
                        });
                    });
                });
            }));
        });
        this.await();
    }
}

