/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.streams;

import io.vertx.core.Context;
import io.vertx.core.streams.impl.InboundBuffer;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.Test;

public class InboundBufferTest
extends VertxTestBase {
    private volatile Runnable contextChecker;
    private Context context;
    private InboundBuffer<Integer> buffer;
    private AtomicInteger sequence;

    private boolean emit() {
        return this.buffer.write((Object)this.sequence.getAndIncrement());
    }

    private boolean emit(int count) {
        ArrayList<Integer> list = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            list.add(this.sequence.getAndIncrement());
        }
        return this.buffer.write(list);
    }

    private void fill() {
        while (this.emit()) {
        }
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.context = this.vertx.getOrCreateContext();
        this.sequence = new AtomicInteger();
        this.context.runOnContext(v -> {
            Thread contextThread = Thread.currentThread();
            this.contextChecker = () -> this.assertSame(contextThread, Thread.currentThread());
        });
        InboundBufferTest.waitUntil(() -> this.contextChecker != null);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    private void checkContext() {
        this.contextChecker.run();
    }

    @Test
    public void testFlowing() {
        this.context.runOnContext(v -> {
            this.buffer = new InboundBuffer(this.context);
            AtomicInteger events = new AtomicInteger();
            this.buffer.handler(elt -> {
                this.checkContext();
                this.assertEquals(0L, elt.intValue());
                this.assertEquals(0L, events.getAndIncrement());
                this.testComplete();
            });
            this.assertTrue(this.emit());
        });
        this.await();
    }

    @Test
    public void testTake() {
        this.context.runOnContext(v -> {
            this.buffer = new InboundBuffer(this.context);
            AtomicInteger events = new AtomicInteger();
            this.buffer.handler(elt -> {
                this.checkContext();
                this.assertEquals(0L, elt.intValue());
                this.assertEquals(0L, events.getAndIncrement());
                this.testComplete();
            });
            this.buffer.pause();
            this.buffer.fetch(1L);
            this.assertTrue(this.emit());
        });
        this.await();
    }

    @Test
    public void testFlowingAdd() {
        this.context.runOnContext(v -> {
            this.buffer = new InboundBuffer(this.context);
            AtomicInteger events = new AtomicInteger();
            this.buffer.handler(elt -> {
                this.checkContext();
                events.getAndIncrement();
            });
            this.assertTrue(this.emit());
            this.assertEquals(1L, events.get());
            this.assertTrue(this.emit());
            this.assertEquals(2L, events.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testFlowingRefill() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 5L);
            AtomicInteger events = new AtomicInteger();
            this.buffer.handler(s -> {
                this.checkContext();
                events.getAndIncrement();
            });
            this.buffer.drainHandler(v2 -> {
                this.checkContext();
                this.assertEquals(8L, events.get());
                this.testComplete();
            });
            this.buffer.pause();
            for (int i = 0; i < 8; ++i) {
                this.assertEquals("Expected " + i + " to be bilto", i < 4, this.emit());
            }
            this.buffer.resume();
        });
        this.await();
    }

    @Test
    public void testPauseWhenFull() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 5L);
            AtomicInteger events = new AtomicInteger();
            AtomicInteger reads = new AtomicInteger();
            this.buffer.drainHandler(v2 -> {
                this.checkContext();
                this.assertEquals(0L, reads.getAndIncrement());
            });
            this.buffer.handler(s -> {
                this.checkContext();
                this.assertEquals(0L, reads.get());
                this.assertEquals(0L, events.getAndIncrement());
                this.testComplete();
            });
            this.buffer.pause();
            for (int i = 0; i < 5; ++i) {
                this.assertEquals(i < 4, this.emit());
            }
            this.buffer.fetch(1L);
        });
        this.await();
    }

    @Test
    public void testPausedResume() {
        this.context.runOnContext(v -> {
            this.buffer = new InboundBuffer(this.context, 5L);
            AtomicInteger events = new AtomicInteger();
            this.buffer.handler(s -> {
                this.checkContext();
                events.getAndIncrement();
            });
            AtomicInteger reads = new AtomicInteger();
            this.buffer.drainHandler(v2 -> {
                this.checkContext();
                this.assertEquals(0L, reads.getAndIncrement());
                this.assertEquals(5L, events.get());
                this.testComplete();
            });
            this.buffer.pause();
            this.fill();
            this.buffer.resume();
        });
        this.await();
    }

    @Test
    public void testPausedDrain() {
        this.waitFor(2);
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 5L);
            AtomicInteger drained = new AtomicInteger();
            AtomicInteger emitted = new AtomicInteger();
            this.buffer.drainHandler(v2 -> {
                this.checkContext();
                this.assertEquals(0L, drained.getAndIncrement());
                this.assertEquals(5L, emitted.get());
                this.complete();
            });
            this.buffer.handler(s -> {
                this.checkContext();
                this.assertEquals(0L, drained.get());
                emitted.getAndIncrement();
            });
            this.buffer.pause();
            this.fill();
            this.assertEquals(0L, drained.get());
            this.assertEquals(0L, emitted.get());
            this.buffer.resume();
            this.complete();
        });
        this.await();
    }

    @Test
    public void testPausedRequestLimited() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 3L);
            AtomicInteger events = new AtomicInteger();
            this.buffer.handler(s -> {
                this.checkContext();
                events.getAndIncrement();
            });
            AtomicInteger reads = new AtomicInteger();
            this.buffer.drainHandler(v2 -> {
                this.checkContext();
                this.assertEquals(0L, reads.getAndIncrement());
            });
            this.buffer.pause();
            this.buffer.fetch(1L);
            this.assertEquals(0L, reads.get());
            this.assertEquals(0L, events.get());
            this.assertTrue(this.emit());
            this.assertEquals(0L, reads.get());
            InboundBufferTest.waitUntilEquals(1, events::get);
            this.assertTrue(this.emit());
            this.assertEquals(0L, reads.get());
            this.assertEquals(1L, events.get());
            this.assertTrue(this.emit());
            this.assertEquals(0L, reads.get());
            this.assertEquals(1L, events.get());
            this.assertFalse(this.emit());
            this.assertEquals(0L, reads.get());
            this.assertEquals(1L, events.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testPushReturnsTrueUntilHighWatermark() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 2L);
            this.buffer.pause();
            this.buffer.fetch(1L);
            this.assertTrue(this.emit());
            this.assertTrue(this.emit());
            this.assertFalse(this.emit());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testHighWaterMark() {
        this.context.runOnContext(v -> {
            this.buffer = new InboundBuffer(this.context, 5L);
            this.buffer.pause();
            this.fill();
            this.assertEquals(5L, this.sequence.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testEmptyHandler() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 4L);
            AtomicInteger emptyCount = new AtomicInteger();
            AtomicInteger itemCount = new AtomicInteger();
            this.buffer.handler(item -> itemCount.incrementAndGet());
            this.buffer.emptyHandler(v2 -> {
                this.assertEquals(0L, emptyCount.getAndIncrement());
                this.testComplete();
            });
            this.assertTrue(this.emit());
            this.assertEquals(1L, itemCount.get());
            this.buffer.pause();
            this.assertTrue(this.emit());
            this.assertTrue(this.emit());
            this.assertTrue(this.emit());
            this.assertEquals(1L, itemCount.get());
            this.assertFalse(this.buffer.isEmpty());
            for (int i = 0; i < 3; ++i) {
                this.assertEquals(0L, emptyCount.get());
                this.buffer.fetch(1L);
            }
        });
        this.await();
    }

    @Test
    public void testEmitWhenHandlingLastItem() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 4L);
            this.buffer.pause();
            this.fill();
            int next = this.sequence.get();
            AtomicInteger received = new AtomicInteger(next);
            this.buffer.handler(s -> {
                if (received.decrementAndGet() == 0) {
                    this.buffer.write((Object)next);
                }
            });
            AtomicInteger writable = new AtomicInteger();
            this.buffer.drainHandler(v -> writable.incrementAndGet());
            this.buffer.fetch((long)this.sequence.get());
            this.assertEquals(0L, writable.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testEmitInElementHandler() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 5L);
            AtomicInteger events = new AtomicInteger();
            AtomicBoolean receiving = new AtomicBoolean();
            this.buffer.handler(s -> {
                this.checkContext();
                this.assertFalse(receiving.getAndSet(true));
                events.incrementAndGet();
                if (s == 0) {
                    this.fill();
                }
                receiving.set(false);
            });
            this.buffer.pause();
            this.buffer.fetch(1L);
            this.assertFalse(this.emit());
            this.assertEquals(5L, this.buffer.size());
            this.assertEquals(1L, events.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testEmitInElementHandler1() {
        this.testEmitInElementHandler(n -> this.assertFalse(this.emit((int)n)));
    }

    @Test
    public void testEmitInElementHandler2() {
        this.testEmitInElementHandler(n -> {
            for (int i = 0; i < n - 1; ++i) {
                this.assertTrue(this.emit());
            }
            this.assertFalse(this.emit());
        });
    }

    private void testEmitInElementHandler(Consumer<Integer> emit) {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 5L);
            AtomicInteger events = new AtomicInteger();
            AtomicInteger drained = new AtomicInteger();
            AtomicBoolean draining = new AtomicBoolean();
            this.buffer.drainHandler(v -> {
                this.assertFalse(draining.get());
                draining.set(true);
                this.assertEquals(0L, drained.getAndIncrement());
                this.assertFalse(this.emit());
                draining.set(false);
            });
            this.buffer.handler(s -> {
                this.checkContext();
                switch (s) {
                    case 5: {
                        emit.accept(9);
                        break;
                    }
                    case 9: {
                        this.vertx.runOnContext(v -> {
                            this.assertEquals(1L, drained.get());
                            this.assertEquals(10L, events.get());
                            this.assertEquals(5L, this.buffer.size());
                            this.testComplete();
                        });
                    }
                }
                events.incrementAndGet();
            });
            this.buffer.pause();
            this.fill();
            this.buffer.fetch(10L);
        });
        this.await();
    }

    @Test
    public void testEmitInDrainHandler1() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 4L);
            AtomicInteger drained = new AtomicInteger();
            AtomicInteger expectedDrained = new AtomicInteger();
            this.buffer.drainHandler(v2 -> {
                switch (drained.getAndIncrement()) {
                    case 0: {
                        expectedDrained.set(1);
                        this.fill();
                        this.context.runOnContext(v -> {
                            this.assertEquals(1L, drained.get());
                            this.testComplete();
                        });
                    }
                }
            });
            this.buffer.handler(val -> {
                if (val == 0) {
                    this.fill();
                }
                this.assertEquals(expectedDrained.get(), drained.get());
            });
            this.buffer.pause();
            this.buffer.fetch(1L);
            this.emit();
            this.buffer.fetch(4L);
        });
        this.await();
    }

    @Test
    public void testEmitInDrainHandler2() {
        this.waitFor(2);
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 5L);
            AtomicInteger drained = new AtomicInteger();
            AtomicBoolean draining = new AtomicBoolean();
            AtomicInteger emitted = new AtomicInteger();
            this.buffer.drainHandler(v2 -> {
                this.assertFalse(draining.get());
                draining.set(true);
                switch (drained.getAndIncrement()) {
                    case 0: {
                        this.fill();
                        this.buffer.fetch(5L);
                        break;
                    }
                    case 1: {
                        this.assertEquals(10L, emitted.get());
                        this.complete();
                    }
                }
                draining.set(false);
            });
            this.buffer.handler(val -> {
                emitted.incrementAndGet();
                if (val == 0) {
                    this.assertEquals(0L, drained.get());
                } else if (val == 6) {
                    this.assertEquals(1L, drained.get());
                }
            });
            this.buffer.pause();
            this.fill();
            this.buffer.fetch(5L);
            this.complete();
        });
        this.await();
    }

    @Test
    public void testDrainAfter() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 5L);
            AtomicInteger events = new AtomicInteger();
            AtomicBoolean receiving = new AtomicBoolean();
            this.buffer.handler(s -> {
                this.checkContext();
                this.assertFalse(receiving.getAndSet(true));
                events.incrementAndGet();
                if (s == 0) {
                    this.emit(5);
                }
                receiving.set(false);
            });
            this.assertTrue(this.emit());
            this.assertEquals(6L, this.sequence.get());
            this.assertEquals(6L, events.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testPauseInElementHandler() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 5L);
            AtomicInteger events = new AtomicInteger();
            this.buffer.handler(s -> {
                events.incrementAndGet();
                if (s == 0) {
                    this.buffer.pause();
                    this.fill();
                }
            });
            this.assertFalse(this.emit());
            this.assertEquals(1L, events.get());
            this.assertEquals(5L, this.buffer.size());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testAddAllEmitInHandler() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 4L);
            ArrayList emitted = new ArrayList();
            this.buffer.handler(elt -> {
                switch (elt) {
                    case 0: {
                        this.emit();
                    }
                }
                emitted.add(elt);
            });
            this.assertTrue(this.emit(3));
            this.assertEquals(Arrays.asList(0, 1, 2, 3), emitted);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testAddAllWhenPaused() {
        this.waitFor(3);
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 4L);
            AtomicInteger emitted = new AtomicInteger();
            AtomicInteger emptied = new AtomicInteger();
            AtomicInteger drained = new AtomicInteger();
            this.buffer.handler(item -> {
                emitted.incrementAndGet();
                this.assertEquals(0L, drained.get());
                this.assertEquals(0L, emptied.get());
                this.buffer.fetch(1L);
            });
            this.buffer.emptyHandler(v -> {
                this.assertEquals(5L, emitted.get());
                emptied.incrementAndGet();
                this.complete();
            });
            this.buffer.drainHandler(v -> {
                this.assertEquals(5L, emitted.get());
                drained.incrementAndGet();
                this.complete();
            });
            this.buffer.pause();
            this.assertFalse(this.emit(5));
            this.buffer.fetch(1L);
            this.complete();
        });
        this.await();
    }

    @Test
    public void testAddAllWhenFlowing() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 4L);
            AtomicInteger emitted = new AtomicInteger();
            AtomicInteger emptied = new AtomicInteger();
            AtomicInteger drained = new AtomicInteger();
            this.buffer.handler(item -> emitted.incrementAndGet());
            this.buffer.emptyHandler(v2 -> emptied.incrementAndGet());
            this.buffer.drainHandler(v2 -> drained.incrementAndGet());
            this.assertTrue(this.emit(4));
            this.context.runOnContext(v -> {
                InboundBufferTest.waitUntilEquals(0, drained::get);
                InboundBufferTest.waitUntilEquals(0, emptied::get);
                InboundBufferTest.waitUntilEquals(4, emitted::get);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testAddAllWhenDelivering() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 4L);
            ArrayList emitted = new ArrayList();
            this.buffer.handler(elt -> {
                emitted.add(elt);
                if (elt == 2) {
                    this.buffer.write(Arrays.asList(4, 5));
                    this.assertEquals(Arrays.asList(0, 1, 2), emitted);
                }
            });
            this.emit(4);
            this.assertEquals(Arrays.asList(0, 1, 2, 3, 4, 5), emitted);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testPollDuringEmission() {
        this.waitFor(2);
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 4L);
            ArrayList polled = new ArrayList();
            ArrayList emitted = new ArrayList();
            AtomicInteger drained = new AtomicInteger();
            this.buffer.drainHandler(v -> {
                this.assertEquals(Arrays.asList(0, 1, 2, 3), emitted);
                this.assertEquals(Arrays.asList(4, 5), polled);
                this.complete();
            });
            this.buffer.handler(elt -> {
                emitted.add(elt);
                if (elt == 3) {
                    Integer p;
                    while ((p = (Integer)this.buffer.read()) != null) {
                        polled.add(p);
                    }
                    this.assertEquals(Arrays.asList(4, 5), polled);
                    this.assertEquals(0L, drained.get());
                    this.complete();
                } else {
                    this.assertTrue(elt < 3);
                }
            });
            this.buffer.pause();
            this.assertFalse(this.emit(6));
            this.buffer.resume();
        });
        this.await();
    }

    @Test
    public void testCheckThatPauseAfterResumeWontDoAnyEmission() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 4L);
            AtomicInteger emitted = new AtomicInteger();
            this.buffer.handler(elt -> emitted.incrementAndGet());
            this.buffer.pause();
            this.fill();
            this.buffer.resume();
            this.buffer.pause();
            this.vertx.setTimer(20L, id -> {
                this.assertEquals(0L, emitted.get());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testBufferSignalingFullImmediately() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 0L);
            ArrayList emitted = new ArrayList();
            this.buffer.drainHandler(v -> {
                this.assertEquals(Arrays.asList(0, 1), emitted);
                this.testComplete();
            });
            this.buffer.handler(emitted::add);
            this.assertTrue(this.emit());
            this.assertEquals(Collections.singletonList(0), emitted);
            this.buffer.pause();
            this.assertFalse(this.emit());
            this.buffer.resume();
        });
        this.await();
    }

    @Test
    public void testPauseInHandlerSignalsFullImmediately() {
        this.context.runOnContext(v -> {
            this.buffer = new InboundBuffer(this.context, 0L);
            this.buffer.handler(elt -> {
                this.checkContext();
                this.buffer.pause();
            });
            this.assertFalse(this.emit());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testFetchWhenNotEmittingWithNoPendingElements() {
        this.context.runOnContext(v1 -> {
            this.buffer = new InboundBuffer(this.context, 0L);
            AtomicInteger drained = new AtomicInteger();
            this.buffer.drainHandler(v2 -> this.context.runOnContext(v -> {
                this.assertEquals(0L, drained.getAndIncrement());
                this.testComplete();
            }));
            this.buffer.emptyHandler(v -> this.fail());
            this.buffer.handler(elt -> {
                this.checkContext();
                switch (elt) {
                    case 0: {
                        this.buffer.pause();
                    }
                }
            });
            this.assertFalse(this.emit());
            this.buffer.fetch(1L);
        });
        this.await();
    }

    @Test
    public void testRejectWrongThread() {
        this.buffer = new InboundBuffer(this.context);
        try {
            this.buffer.write((Object)0);
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.buffer.write(Arrays.asList(0, 1, 2));
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

