/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.logging.LogDelegate;
import io.vertx.it.Recording;
import java.io.IOException;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JULLogDelegateTest {
    private static io.vertx.core.logging.Logger logger;
    private static Recording recording;

    @BeforeClass
    public static void initialize() throws IOException {
        logger = LoggerFactory.getLogger((String)"my-jul-logger");
        recording = new Recording();
    }

    @Test
    public void testDelegateUnwrap() {
        LogDelegate delegate = logger.getDelegate();
        Assert.assertNotNull((String)"Delegate is null", (Object)delegate);
        try {
            Logger unwrapped = (Logger)delegate.unwrap();
            Assert.assertNotNull((String)"Unwrapped is null", (Object)unwrapped);
        }
        catch (ClassCastException e) {
            Assert.fail((String)("Unexpected unwrapped type: " + e.getMessage()));
        }
    }

    @Test
    public void testInfo() {
        String result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"hello");
        });
        Assert.assertTrue((boolean)result.contains("hello"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"exception", (Throwable)new NullPointerException());
        });
        Assert.assertTrue((boolean)result.contains("exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"hello {0} and {1}", new Object[]{"Paulo", "Julien"});
        });
        Assert.assertTrue((boolean)result.contains("hello Paulo and Julien"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"hello {0}", new Object[]{"vert.x"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"hello {0} - {1}", new Object[]{"vert.x"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x - {1}"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"hello {0}", new Object[]{"vert.x", "foo"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"{0}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"});
        });
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.info((Object)"{0}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()});
        });
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }

    @Test
    public void testError() {
        String result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"hello");
        });
        Assert.assertTrue((boolean)result.contains("hello"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"exception", (Throwable)new NullPointerException());
        });
        Assert.assertTrue((boolean)result.contains("exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"hello {0} and {1}", new Object[]{"Paulo", "Julien"});
        });
        Assert.assertTrue((boolean)result.contains("hello Paulo and Julien"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"hello {0}", new Object[]{"vert.x"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"hello {0} - {1}", new Object[]{"vert.x"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x - {1}"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"hello {0}", new Object[]{"vert.x", "foo"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"{0}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"});
        });
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.error((Object)"{0}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()});
        });
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }

    @Test
    public void testWarning() {
        String result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"hello");
        });
        Assert.assertTrue((boolean)result.contains("hello"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"exception", (Throwable)new NullPointerException());
        });
        Assert.assertTrue((boolean)result.contains("exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"hello {0} and {1}", new Object[]{"Paulo", "Julien"});
        });
        Assert.assertTrue((boolean)result.contains("hello Paulo and Julien"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"hello {0}", new Object[]{"vert.x"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"hello {0} - {1}", new Object[]{"vert.x"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x - {1}"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"hello {0}", new Object[]{"vert.x", "foo"});
        });
        Assert.assertTrue((boolean)result.contains("hello vert.x"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"{0}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"});
        });
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = recording.execute(() -> {
            io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-jul-logger");
            logger.warn((Object)"{0}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()});
        });
        Assert.assertTrue((boolean)result.contains("Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }
}

