/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakecluster;

import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.shareddata.impl.AsynchronousCounter;
import io.vertx.core.shareddata.impl.LocalAsyncLocks;
import io.vertx.core.shareddata.impl.LocalAsyncMapImpl;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeInfo;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.core.spi.cluster.RegistrationUpdateEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class FakeClusterManager
implements ClusterManager {
    private static final Map<String, FakeClusterManager> nodes = Collections.synchronizedMap(new LinkedHashMap());
    private static final ConcurrentMap<String, List<RegistrationInfo>> registrations = new ConcurrentHashMap<String, List<RegistrationInfo>>();
    private static final ConcurrentMap<String, NodeInfo> nodeInfos = new ConcurrentHashMap<String, NodeInfo>();
    private static final ConcurrentMap<String, LocalAsyncMapImpl> asyncMaps = new ConcurrentHashMap<String, LocalAsyncMapImpl>();
    private static final ConcurrentMap<String, Map> syncMaps = new ConcurrentHashMap<String, Map>();
    private static LocalAsyncLocks localAsyncLocks = new LocalAsyncLocks();
    private static final ConcurrentMap<String, AtomicLong> counters = new ConcurrentHashMap<String, AtomicLong>();
    private volatile String nodeID;
    private NodeListener nodeListener;
    private VertxInternal vertx;
    private NodeSelector nodeSelector;

    public void init(Vertx vertx, NodeSelector nodeSelector) {
        this.vertx = (VertxInternal)vertx;
        this.nodeSelector = nodeSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doJoin(String nodeID, FakeClusterManager node) {
        if (nodes.containsKey(nodeID)) {
            throw new IllegalStateException("Node has already joined!");
        }
        nodes.put(nodeID, node);
        Map<String, FakeClusterManager> map = nodes;
        synchronized (map) {
            for (Map.Entry<String, FakeClusterManager> entry : nodes.entrySet()) {
                if (entry.getKey().equals(nodeID)) continue;
                new Thread(() -> ((FakeClusterManager)entry.getValue()).memberAdded(nodeID)).start();
            }
        }
    }

    private synchronized void memberAdded(String nodeID) {
        if (this.isActive()) {
            try {
                if (this.nodeListener != null) {
                    this.nodeListener.nodeAdded(nodeID);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doLeave(String nodeID) {
        nodes.remove(nodeID);
        Map<String, FakeClusterManager> map = nodes;
        synchronized (map) {
            for (Map.Entry<String, FakeClusterManager> entry : nodes.entrySet()) {
                if (entry.getKey().equals(nodeID)) continue;
                new Thread(() -> ((FakeClusterManager)entry.getValue()).memberRemoved(nodeID)).start();
            }
        }
    }

    private synchronized void memberRemoved(String nodeID) {
        if (this.isActive()) {
            try {
                if (this.nodeListener != null) {
                    this.nodeListener.nodeLeft(nodeID);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public <K, V> void getAsyncMap(String name, Promise<AsyncMap<K, V>> promise) {
        promise.complete((Object)asyncMaps.computeIfAbsent(name, n -> new LocalAsyncMapImpl(this.vertx)));
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        Map prevMap;
        Map map = (ConcurrentHashMap)syncMaps.get(name);
        if (map == null && (prevMap = (Map)syncMaps.putIfAbsent(name, map = new ConcurrentHashMap())) != null) {
            map = prevMap;
        }
        ConcurrentHashMap theMap = map;
        return theMap;
    }

    public void getLockWithTimeout(String name, long timeout, Promise<Lock> promise) {
        localAsyncLocks.acquire(this.vertx.getOrCreateContext(), name, timeout).onComplete(promise);
    }

    public void getCounter(String name, Promise<Counter> promise) {
        promise.complete((Object)new AsynchronousCounter(this.vertx, counters.computeIfAbsent(name, k -> new AtomicLong())));
    }

    public String getNodeId() {
        return this.nodeID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getNodes() {
        ArrayList<String> res;
        Map<String, FakeClusterManager> map = nodes;
        synchronized (map) {
            res = new ArrayList<String>(nodes.keySet());
        }
        return res;
    }

    public void nodeListener(NodeListener listener) {
        this.nodeListener = listener;
    }

    public void setNodeInfo(NodeInfo nodeInfo, Promise<Void> promise) {
        nodeInfos.put(this.nodeID, nodeInfo);
        promise.complete();
    }

    public NodeInfo getNodeInfo() {
        return (NodeInfo)nodeInfos.get(this.nodeID);
    }

    public void getNodeInfo(String nodeId, Promise<NodeInfo> promise) {
        NodeInfo result = (NodeInfo)nodeInfos.get(nodeId);
        if (result != null) {
            promise.complete((Object)result);
        } else {
            promise.fail("Not a member of the cluster");
        }
    }

    public void join(Promise<Void> promise) {
        this.vertx.executeBlocking(fut -> {
            FakeClusterManager fakeClusterManager = this;
            synchronized (fakeClusterManager) {
                this.nodeID = UUID.randomUUID().toString();
                FakeClusterManager.doJoin(this.nodeID, this);
            }
            fut.complete();
        }, promise);
    }

    public void leave(Promise<Void> promise) {
        ArrayList<RegistrationUpdateEvent> events = new ArrayList<RegistrationUpdateEvent>();
        registrations.keySet().forEach(address -> {
            List current = registrations.compute((String)address, (addr, infos) -> {
                if (infos == null) {
                    return null;
                }
                return infos.stream().filter(info -> !info.nodeId().equals(this.nodeID)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> list.isEmpty() ? null : list));
            });
            events.add(new RegistrationUpdateEvent(address, current));
        });
        this.fireRegistrationUpdateEvents(events, true);
        this.vertx.executeBlocking(fut -> {
            FakeClusterManager fakeClusterManager = this;
            synchronized (fakeClusterManager) {
                if (this.nodeID != null) {
                    nodeInfos.remove(this.nodeID);
                    if (this.nodeListener != null) {
                        this.nodeListener = null;
                    }
                    FakeClusterManager.doLeave(this.nodeID);
                    this.nodeID = null;
                }
            }
            fut.complete();
        }, promise);
    }

    private synchronized void fireRegistrationUpdateEvents(List<RegistrationUpdateEvent> events, boolean skipThisNode) {
        for (String nid : this.getNodes()) {
            if (skipThisNode && Objects.equals(this.nodeID, nid)) continue;
            for (RegistrationUpdateEvent event : events) {
                FakeClusterManager clusterManager = nodes.get(nid);
                if (clusterManager == null || !clusterManager.isActive()) continue;
                clusterManager.nodeSelector.registrationsUpdated(event);
            }
        }
    }

    public boolean isActive() {
        return this.nodeID != null;
    }

    public void addRegistration(String address, RegistrationInfo registrationInfo, Promise<Void> promise) {
        List current = registrations.compute(address, (addrr, infos) -> {
            ArrayList<RegistrationInfo> res = infos == null ? new ArrayList<RegistrationInfo>() : infos;
            res.add(registrationInfo);
            return res;
        });
        promise.complete();
        RegistrationUpdateEvent event = new RegistrationUpdateEvent(address, current);
        this.fireRegistrationUpdateEvents(Collections.singletonList(event), false);
    }

    public void removeRegistration(String address, RegistrationInfo registrationInfo, Promise<Void> promise) {
        List current = registrations.compute(address, (addrr, infos) -> {
            List res = infos == null ? null : infos.stream().filter(Predicate.isEqual(registrationInfo).negate()).collect(Collectors.collectingAndThen(Collectors.toList(), list -> list.isEmpty() ? null : list));
            return res;
        });
        promise.complete();
        RegistrationUpdateEvent event = new RegistrationUpdateEvent(address, current);
        this.fireRegistrationUpdateEvents(Collections.singletonList(event), false);
    }

    public void getRegistrations(String address, Promise<List<RegistrationInfo>> promise) {
        promise.complete(registrations.get(address));
    }

    public static void reset() {
        registrations.clear();
        nodes.clear();
        asyncMaps.clear();
        localAsyncLocks = new LocalAsyncLocks();
        counters.clear();
        syncMaps.clear();
    }
}

