/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonObject;
import io.vertx.db2client.DB2ConnectOptionsConverter;
import io.vertx.db2client.DB2Exception;
import io.vertx.db2client.impl.DB2ConnectionUriParser;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@DataObject(generateConverter=true)
public class DB2ConnectOptions
extends SqlConnectOptions {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 50000;
    public static final String DEFAULT_CHARSET = "utf8";
    public static final boolean DEFAULT_USE_AFFECTED_ROWS = false;
    public static final int DEFAULT_PIPELINING_LIMIT = 1;
    public static final Map<String, String> DEFAULT_CONNECTION_ATTRIBUTES;
    private int pipeliningLimit = 1;

    public static DB2ConnectOptions fromUri(String connectionUri) throws IllegalArgumentException {
        JsonObject parsedConfiguration = DB2ConnectionUriParser.parse(connectionUri);
        return new DB2ConnectOptions(parsedConfiguration);
    }

    public DB2ConnectOptions() {
    }

    public DB2ConnectOptions(String uri) {
        throw new UnsupportedOperationException("TODO @AGG need to implement uri parsing");
    }

    public DB2ConnectOptions(JsonObject json) {
        super(json);
        DB2ConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public DB2ConnectOptions(SqlConnectOptions other) {
        super(other);
        if (other instanceof DB2ConnectOptions) {
            DB2ConnectOptions opts = (DB2ConnectOptions)other;
            this.pipeliningLimit = opts.pipeliningLimit;
        }
    }

    public DB2ConnectOptions(DB2ConnectOptions other) {
        super((SqlConnectOptions)other);
        this.pipeliningLimit = other.pipeliningLimit;
    }

    public DB2ConnectOptions setHost(String host) {
        return (DB2ConnectOptions)super.setHost(host);
    }

    public DB2ConnectOptions setPort(int port) {
        return (DB2ConnectOptions)super.setPort(port);
    }

    public DB2ConnectOptions setUser(String user) {
        if (user == null || user.length() < 1) {
            throw new DB2Exception("The user cannot be blank or null", -4461, "08001.C.7");
        }
        return (DB2ConnectOptions)super.setUser(user);
    }

    public DB2ConnectOptions setPassword(String password) {
        if (password == null || password.length() < 1) {
            throw new DB2Exception("The password cannot be blank or null", -4461, "08001.C.8");
        }
        return (DB2ConnectOptions)super.setPassword(password);
    }

    public DB2ConnectOptions setDatabase(String database) {
        if (database == null || database.length() < 1) {
            throw new DB2Exception("The database name cannot be blank or null", -1001, "XJ004.C");
        }
        return (DB2ConnectOptions)super.setDatabase(database);
    }

    public DB2ConnectOptions setCachePreparedStatements(boolean cachePreparedStatements) {
        return (DB2ConnectOptions)super.setCachePreparedStatements(cachePreparedStatements);
    }

    public DB2ConnectOptions setPreparedStatementCacheMaxSize(int preparedStatementCacheMaxSize) {
        return (DB2ConnectOptions)super.setPreparedStatementCacheMaxSize(preparedStatementCacheMaxSize);
    }

    public DB2ConnectOptions setPreparedStatementCacheSqlLimit(int preparedStatementCacheSqlLimit) {
        return (DB2ConnectOptions)super.setPreparedStatementCacheSqlLimit(preparedStatementCacheSqlLimit);
    }

    public int getPipeliningLimit() {
        return this.pipeliningLimit;
    }

    @GenIgnore
    @Deprecated
    public DB2ConnectOptions setPipeliningLimit(int pipeliningLimit) {
        if (pipeliningLimit < 1) {
            throw new IllegalArgumentException();
        }
        this.pipeliningLimit = pipeliningLimit;
        return this;
    }

    public DB2ConnectOptions setProperties(Map<String, String> properties) {
        return (DB2ConnectOptions)super.setProperties(properties);
    }

    @GenIgnore
    public DB2ConnectOptions addProperty(String key, String value) {
        return (DB2ConnectOptions)super.addProperty(key, value);
    }

    protected void init() {
        this.setHost(DEFAULT_HOST);
        this.setPort(50000);
        this.setProperties(new HashMap<String, String>(DEFAULT_CONNECTION_ATTRIBUTES));
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        return json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DB2ConnectOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DB2ConnectOptions that = (DB2ConnectOptions)((Object)o);
        return this.pipeliningLimit == that.pipeliningLimit;
    }

    public int hashCode() {
        return Objects.hash(this.pipeliningLimit);
    }

    static {
        HashMap<String, String> defaultAttributes = new HashMap<String, String>();
        defaultAttributes.put("_client_name", "vertx-db2-client");
        DEFAULT_CONNECTION_ATTRIBUTES = Collections.unmodifiableMap(defaultAttributes);
    }
}

