/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Connection;
import io.vertx.db2client.impl.DB2ConnectionFactory;
import io.vertx.db2client.impl.command.PingCommand;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionImpl;

public class DB2ConnectionImpl
extends SqlConnectionImpl<DB2ConnectionImpl>
implements DB2Connection {
    private final DB2ConnectionFactory factory;

    public static void connect(Vertx vertx, DB2ConnectOptions options, Handler<AsyncResult<DB2Connection>> handler) {
        Context ctx = Vertx.currentContext();
        if (ctx != null) {
            DB2ConnectionFactory client;
            try {
                client = new DB2ConnectionFactory(ctx, false, options);
            }
            catch (Exception e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
                return;
            }
            client.connect((Handler<AsyncResult<Connection>>)((Handler)ar -> {
                if (ar.succeeded()) {
                    Connection conn = (Connection)ar.result();
                    DB2ConnectionImpl p = new DB2ConnectionImpl(client, ctx, conn);
                    conn.init((Connection.Holder)p);
                    handler.handle((Object)Future.succeededFuture((Object)p));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }));
        } else {
            vertx.runOnContext(v -> DB2ConnectionImpl.connect(vertx, options, handler));
        }
    }

    public DB2ConnectionImpl(DB2ConnectionFactory factory, Context context, Connection conn) {
        super(context, conn);
        this.factory = factory;
    }

    public void handleNotification(int processId, String channel, String payload) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DB2Connection ping(Handler<AsyncResult<Void>> handler) {
        PingCommand cmd = new PingCommand();
        cmd.handler = handler;
        this.schedule(cmd);
        return this;
    }

    @Override
    public DB2Connection debug(Handler<AsyncResult<Void>> handler) {
        throw new UnsupportedOperationException("Debug command not implemented");
    }
}

