/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.db2client.impl.DB2SocketConnection;
import io.vertx.db2client.impl.codec.CloseConnectionCommandCodec;
import io.vertx.db2client.impl.codec.CloseCursorCommandCodec;
import io.vertx.db2client.impl.codec.CloseStatementCommandCodec;
import io.vertx.db2client.impl.codec.CommandCodec;
import io.vertx.db2client.impl.codec.ExtendedBatchQueryCommandCodec;
import io.vertx.db2client.impl.codec.ExtendedQueryCommandCodec;
import io.vertx.db2client.impl.codec.InitialHandshakeCommandCodec;
import io.vertx.db2client.impl.codec.PingCommandCodec;
import io.vertx.db2client.impl.codec.PrepareStatementCodec;
import io.vertx.db2client.impl.codec.SimpleQueryCommandCodec;
import io.vertx.db2client.impl.command.InitialHandshakeCommand;
import io.vertx.db2client.impl.command.PingCommand;
import io.vertx.db2client.impl.drda.ConnectionMetaData;
import io.vertx.sqlclient.impl.command.CloseConnectionCommand;
import io.vertx.sqlclient.impl.command.CloseCursorCommand;
import io.vertx.sqlclient.impl.command.CloseStatementCommand;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.ExtendedBatchQueryCommand;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import java.util.ArrayDeque;

class DB2Encoder
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DB2Encoder.class);
    public final ConnectionMetaData connMetadata = new ConnectionMetaData();
    private final ArrayDeque<CommandCodec<?, ?>> inflight;
    ChannelHandlerContext chctx;
    DB2SocketConnection socketConnection;

    DB2Encoder(ArrayDeque<CommandCodec<?, ?>> inflight, DB2SocketConnection db2SocketConnection) {
        this.inflight = inflight;
        this.socketConnection = db2SocketConnection;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.chctx = ctx;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof CommandBase) {
            CommandBase cmd = (CommandBase)msg;
            this.write(cmd);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    void write(CommandBase<?> cmd) {
        CommandCodec<?, ?> codec = this.wrap(cmd);
        codec.completionHandler = resp -> {
            CommandCodec<?, ?> c = this.inflight.poll();
            resp.cmd = c.cmd;
            this.chctx.fireChannelRead(resp);
        };
        this.inflight.add(codec);
        try {
            codec.encode(this);
        }
        catch (Throwable e) {
            LOG.error((Object)("FATAL: Unable to encode command: " + cmd), e);
            codec.completionHandler.handle((Object)CommandResponse.failure((Throwable)e));
        }
    }

    private CommandCodec<?, ?> wrap(CommandBase<?> cmd) {
        CommandCodec codec = null;
        if (cmd instanceof InitialHandshakeCommand) {
            codec = new InitialHandshakeCommandCodec((InitialHandshakeCommand)cmd);
        } else if (cmd instanceof SimpleQueryCommand) {
            codec = new SimpleQueryCommandCodec((SimpleQueryCommand)cmd);
        } else if (cmd instanceof ExtendedQueryCommand) {
            codec = new ExtendedQueryCommandCodec((ExtendedQueryCommand)cmd);
        } else if (cmd instanceof ExtendedBatchQueryCommand) {
            codec = new ExtendedBatchQueryCommandCodec((ExtendedBatchQueryCommand)cmd);
        } else if (cmd instanceof CloseConnectionCommand) {
            codec = new CloseConnectionCommandCodec((CloseConnectionCommand)cmd);
        } else if (cmd instanceof PrepareStatementCommand) {
            codec = new PrepareStatementCodec((PrepareStatementCommand)cmd);
        } else if (cmd instanceof CloseStatementCommand) {
            codec = new CloseStatementCommandCodec((CloseStatementCommand)cmd);
        } else if (cmd instanceof CloseCursorCommand) {
            codec = new CloseCursorCommandCodec((CloseCursorCommand)cmd);
        } else if (cmd instanceof PingCommand) {
            codec = new PingCommandCodec((PingCommand)cmd);
        } else {
            UnsupportedOperationException uoe = new UnsupportedOperationException("Unsupported command type: " + cmd);
            LOG.error((Object)uoe);
            throw uoe;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>> ENCODE " + codec));
        }
        return codec;
    }
}

