/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.db2client.impl.codec.DB2PreparedStatement;
import io.vertx.db2client.impl.codec.ExtendedQueryCommandBaseCodec;
import io.vertx.db2client.impl.codec.RowResultDecoder;
import io.vertx.db2client.impl.drda.DRDAQueryRequest;
import io.vertx.db2client.impl.drda.DRDAQueryResponse;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;

class ExtendedQueryCommandCodec<R>
extends ExtendedQueryCommandBaseCodec<R, ExtendedQueryCommand<R>> {
    final DB2PreparedStatement.QueryInstance queryInstance;

    ExtendedQueryCommandCodec(ExtendedQueryCommand<R> cmd) {
        super(cmd);
        this.queryInstance = this.statement.getQueryInstance(cmd.cursorId());
    }

    @Override
    void encodeQuery(DRDAQueryRequest req) {
        this.encodePreparedQuery(req, this.queryInstance, ((ExtendedQueryCommand)this.cmd).params());
    }

    @Override
    void encodeUpdate(DRDAQueryRequest req) {
        this.encodePreparedUpdate(req, ((ExtendedQueryCommand)this.cmd).params());
        if (((ExtendedQueryCommand)this.cmd).autoCommit()) {
            req.buildRDBCMM();
        }
    }

    @Override
    void decodeQuery(ByteBuf payload) {
        DRDAQueryResponse resp = new DRDAQueryResponse(payload, this.encoder.connMetadata);
        RowResultDecoder decoder = this.decodePreparedQuery(payload, resp, this.queryInstance);
        boolean hasMoreResults = !decoder.isQueryComplete();
        this.handleQueryResult(decoder);
        this.completionHandler.handle((Object)CommandResponse.success((Object)hasMoreResults));
    }

    @Override
    void decodeUpdate(ByteBuf payload) {
        DRDAQueryResponse updateResponse = new DRDAQueryResponse(payload, this.encoder.connMetadata);
        this.handleUpdateResult(updateResponse);
        if (((ExtendedQueryCommand)this.cmd).autoCommit()) {
            updateResponse.readLocalCommit();
        }
        this.completionHandler.handle((Object)CommandResponse.success((Object)true));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(", params=");
        sb.append(((ExtendedQueryCommand)this.cmd).params().deepToString());
        return sb.toString();
    }
}

