/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.db2client.impl.codec.CommandCodec;
import io.vertx.db2client.impl.codec.DB2Encoder;
import io.vertx.db2client.impl.codec.DB2RowDesc;
import io.vertx.db2client.impl.codec.RowResultDecoder;
import io.vertx.db2client.impl.drda.ColumnMetaData;
import io.vertx.db2client.impl.drda.DRDAQueryRequest;
import io.vertx.sqlclient.impl.RowDesc;
import io.vertx.sqlclient.impl.command.QueryCommandBase;

abstract class QueryCommandBaseCodec<T, C extends QueryCommandBase<T>>
extends CommandCodec<Boolean, C> {
    protected ColumnMetaData columnDefinitions;
    protected final boolean isQuery;

    QueryCommandBaseCodec(C cmd) {
        super(cmd);
        this.isQuery = DRDAQueryRequest.isQuery(cmd.sql());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("@");
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append(" sql=" + ((QueryCommandBase)this.cmd).sql());
        if (!this.isQuery) {
            sb.append(", autoCommit=" + ((QueryCommandBase)this.cmd).autoCommit());
        }
        return sb.toString();
    }

    @Override
    void encode(DB2Encoder encoder) {
        super.encode(encoder);
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        DRDAQueryRequest req = new DRDAQueryRequest(packet, encoder.connMetadata);
        if (this.isQuery) {
            this.encodeQuery(req);
        } else {
            this.encodeUpdate(req);
        }
        req.completeCommand();
        this.sendPacket(packet, packet.writerIndex() - packetStartIdx);
    }

    abstract void encodeQuery(DRDAQueryRequest var1);

    abstract void encodeUpdate(DRDAQueryRequest var1);

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        if (this.isQuery) {
            this.decodeQuery(payload);
        } else {
            this.decodeUpdate(payload);
        }
    }

    abstract void decodeQuery(ByteBuf var1);

    abstract void decodeUpdate(ByteBuf var1);

    void handleQueryResult(RowResultDecoder<?, T> decoder) {
        Throwable failure = decoder.complete();
        Object result = decoder.result();
        DB2RowDesc rowDesc = decoder.rowDesc;
        int size = decoder.size();
        int updatedCount = decoder.size();
        decoder.reset();
        ((QueryCommandBase)this.cmd).resultHandler().handleResult(updatedCount, size, (RowDesc)rowDesc, result, failure);
    }
}

