/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.netty.buffer.ByteBuf;
import io.vertx.db2client.impl.drda.ConnectionMetaData;
import io.vertx.db2client.impl.drda.DRDARequest;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class DRDAConnectRequest
extends DRDARequest {
    public DRDAConnectRequest(ByteBuf buffer, ConnectionMetaData metadata) {
        super(buffer, metadata);
    }

    public void buildACCRDB(String rdbnam, boolean readOnly, byte[] crrtkn, String typdef) {
        this.createCommand();
        this.markLengthBytes(8193);
        this.buildRDBNAM(rdbnam, true);
        this.buildRDBACCCL();
        this.buildPRDID();
        this.buildPRDDTA();
        this.buildTYPDEFNAM(typdef);
        if (!this.metadata.isZos()) {
            Objects.requireNonNull(crrtkn);
            this.buildCRRTKN(crrtkn);
        }
        this.buildTYPDEFOVR(true, 1208, true, 1208, true, 1208);
        this.buildRDBALWUPD(readOnly);
        this.updateLengthBytes();
    }

    private byte[] getProductData() {
        ByteBuffer prddta_ = ByteBuffer.allocate(255);
        for (int i = 0; i < 55; ++i) {
            prddta_.put(i, this.metadata.getCCSID().encode(" ").get());
        }
        prddta_.position(1);
        prddta_.put(this.metadata.getCCSID().encode("JNT00001"));
        prddta_.put(this.metadata.getCCSID().encode("JVM               "));
        int prddtaLen = prddta_.position();
        String extnamTruncated = "db2jnt_application  JNT00001300".substring(0, Math.min("db2jnt_application  JNT00001300".length(), 20));
        prddta_.put(this.metadata.getCCSID().encode(extnamTruncated));
        prddtaLen += 20;
        prddtaLen += 8;
        prddta_.put(55, (byte)0);
        prddta_.put(0, (byte)(++prddtaLen - 1));
        return prddta_.array();
    }

    public byte[] getCorrelationToken(int port) {
        byte[] localAddressBytes;
        byte[] crrtkn_ = new byte[19];
        try {
            localAddressBytes = Inet4Address.getLocalHost().getAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        int i = 0;
        int j = 0;
        while (i < 4) {
            int num = localAddressBytes[i] < 0 ? localAddressBytes[i] + 256 : localAddressBytes[i];
            int halfByte = num >> 4 & 0xF;
            crrtkn_[j] = i == 0 ? this.metadata.getCCSID().encode("" + (char)(halfByte + 71)).get() : this.metadata.getCCSID().encode("" + halfByte).get();
            halfByte = num & 0xF;
            crrtkn_[j + 1] = this.metadata.getCCSID().encode("" + halfByte).get();
            ++i;
            j += 2;
        }
        crrtkn_[8] = this.metadata.getCCSID().encode(".").get();
        int num = port;
        int halfByte = num >> 12 & 0xF;
        crrtkn_[9] = this.metadata.getCCSID().encode("" + halfByte).get();
        halfByte = num >> 8 & 0xF;
        crrtkn_[10] = this.metadata.getCCSID().encode("" + halfByte).get();
        halfByte = num >> 4 & 0xF;
        crrtkn_[11] = this.metadata.getCCSID().encode("" + halfByte).get();
        halfByte = num & 0xF;
        crrtkn_[12] = this.metadata.getCCSID().encode("" + halfByte).get();
        long time = System.currentTimeMillis();
        for (int i2 = 0; i2 < 6; ++i2) {
            crrtkn_[i2 + 13] = (byte)(time >>> 40 - i2 * 8);
        }
        return crrtkn_;
    }

    public void buildSECCHK(int secmec, String rdbnam, String user, String password, byte[] sectkn, byte[] sectkn2) {
        this.createCommand();
        this.markLengthBytes(4206);
        this.buildSECMEC(secmec);
        this.buildRDBNAM(rdbnam, false);
        if (user != null) {
            this.buildUSRID(user);
        }
        if (password != null) {
            this.buildPASSWORD(password);
        }
        if (sectkn != null) {
            this.buildSECTKN(sectkn);
        }
        if (sectkn2 != null) {
            this.buildSECTKN(sectkn2);
        }
        this.updateLengthBytes();
    }

    public void buildACCSEC(int secmec, String rdbnam, byte[] sectkn) {
        this.createCommand();
        this.markLengthBytes(4205);
        this.buildSECMEC(secmec);
        this.buildRDBNAM(rdbnam, true);
        if (sectkn != null) {
            this.buildSECTKN(sectkn);
        }
        this.updateLengthBytes();
    }

    public void buildRDBCMM() {
        this.createCommand();
        this.writeLengthCodePoint(4, 8206);
    }

    private void buildRDBALWUPD(boolean readOnly) {
        if (readOnly) {
            this.writeScalar1Byte(8474, -16);
        }
    }

    private void buildTYPDEFOVR(boolean sendCcsidSbc, int ccsidSbc, boolean sendCcsidDbc, int ccsidDbc, boolean sendCcsidMbc, int ccsidMbc) {
        this.markLengthBytes(53);
        if (sendCcsidSbc) {
            this.writeScalar2Bytes(4508, ccsidSbc);
        }
        if (sendCcsidDbc) {
            this.writeScalar2Bytes(4509, ccsidDbc);
        }
        if (sendCcsidMbc) {
            this.writeScalar2Bytes(4510, ccsidMbc);
        }
        if (this.metadata.isZos()) {
            this.writeScalar2Bytes(6419, ccsidMbc);
        }
        this.updateLengthBytes();
    }

    private void buildCRRTKN(byte[] crrtkn) {
        this.writeScalarBytes(8501, crrtkn);
    }

    private void buildTYPDEFNAM(String typdefnam) {
        this.writeScalarString(47, typdefnam);
    }

    private void buildPRDDTA() {
        byte[] prddta = this.getProductData();
        int prddtaLength = (prddta[0] & 0xFF) + 1;
        this.writeScalarBytes(8452, prddta, 0, prddtaLength);
    }

    private void buildPRDID() {
        this.writeScalarString(4398, "JNT00001");
    }

    private void buildRDBACCCL() {
        this.writeScalar2Bytes(8463, 9223);
    }

    private void buildUSRID(String usrid) {
        this.writeScalarString(4512, usrid, 0, 255, "08001.C.11");
    }

    private void buildPASSWORD(String password) {
        int passwordLength = password.length();
        if (passwordLength == 0) {
            throw new IllegalArgumentException("Password size must be > 0");
        }
        this.writeScalarString(4513, password, 0, 255, "08001.C.12");
    }

    private void buildSECTKN(byte[] sectkn) {
        if (sectkn.length > 32763) {
            throw new IllegalArgumentException("SQLState.NET_SECTKN_TOO_LONG");
        }
        this.writeScalarBytes(4572, sectkn);
    }

    private void buildRDBNAM(String rdbnam, boolean dontSendOnConversionError) {
        int maxRDBlength = 1024;
        this.writeScalarString(8464, rdbnam, 18, maxRDBlength, "08001.C.9");
    }

    private void buildSECMEC(int secmec) {
        this.ensureLength(6);
        this.buffer.writeByte(0);
        this.buffer.writeByte(6);
        this.buffer.writeShort(4514);
        this.buffer.writeShort(secmec);
    }

    public void buildEXCSAT(String externalName, int targetAgent, int targetSqlam, int targetRdb, int targetSecmgr, int targetCmntcpip, int targetCmnappc, int targetXamgr, int targetSyncptmgr, int targetRsyncmgr, int targetUnicodemgr) {
        this.createCommand();
        this.markLengthBytes(4161);
        this.buildEXTNAM(externalName);
        this.buildSRVNAM(this.getHostname());
        this.buildSRVRLSLV();
        this.buildMGRLVLLS(targetAgent, targetSqlam, targetRdb, targetSecmgr, targetXamgr, targetSyncptmgr, targetRsyncmgr, targetUnicodemgr);
        this.buildSRVCLSNM();
        this.updateLengthBytes();
    }

    private void buildSRVCLSNM() {
        this.writeScalarString(4423, "QDB2/JVM");
    }

    private void buildMGRLVLLS(int agent, int sqlam, int rdb, int secmgr, int xamgr, int syncptmgr, int rsyncmgr, int unicodemgr) {
        this.markLengthBytes(5124);
        this.buffer.writeShort(5123);
        this.buffer.writeShort(agent);
        this.buffer.writeShort(9223);
        this.buffer.writeShort(sqlam);
        this.buffer.writeShort(7176);
        this.buffer.writeShort(unicodemgr);
        this.buffer.writeShort(9231);
        this.buffer.writeShort(rdb);
        this.buffer.writeShort(5184);
        this.buffer.writeShort(secmgr);
        this.buffer.writeShort(5236);
        this.buffer.writeShort(8);
        this.updateLengthBytes();
    }

    private void buildEXTNAM(String extnam) {
        int MAX_SIZE = 255;
        int extnamTruncateLength = Math.min(extnam.length(), 255);
        this.writeScalarString(4446, extnam.substring(0, extnamTruncateLength), 141, 255, "NET_EXTNAM_TOO_LONG");
    }

    private void buildSRVNAM(String srvnam) {
        int MAX_SIZE = 255;
        int srvnamTruncateLength = Math.min(srvnam.length(), 255);
        this.writeScalarString(4461, srvnam.substring(0, srvnamTruncateLength), 0, 255, "SQLState.NET_SRVNAM_TOO_LONG");
    }

    private void buildSRVRLSLV() {
        this.writeScalarString(4442, "JNT00001");
    }
}

