/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.netty.buffer.ByteBuf;
import io.vertx.db2client.DB2Exception;
import io.vertx.db2client.impl.drda.CCSIDConstants;
import io.vertx.db2client.impl.drda.CodePoint;
import io.vertx.db2client.impl.drda.ConnectionMetaData;
import io.vertx.db2client.impl.drda.DRDAResponse;
import io.vertx.db2client.impl.drda.NetSqlca;
import java.util.ArrayList;
import java.util.List;

public class DRDAConnectResponse
extends DRDAResponse {
    public DRDAConnectResponse(ByteBuf buffer, ConnectionMetaData metadata) {
        super(buffer, metadata);
    }

    public void readAccessSecurity(int securityMechanism) {
        this.startSameIdChainParse();
        this.parseACCSECreply(securityMechanism);
        this.endOfSameIdChainData();
    }

    public void readExchangeServerAttributes() {
        this.startSameIdChainParse();
        this.parseEXCSATreply();
        this.endOfSameIdChainData();
    }

    public void readSecurityCheck() {
        this.startSameIdChainParse();
        this.parseSECCHKreply();
        this.endOfSameIdChainData();
    }

    public RDBAccessData readAccessDatabase() {
        this.startSameIdChainParse();
        RDBAccessData accessData = this.parseACCRDBreply();
        this.endOfSameIdChainData();
        return accessData;
    }

    public void readLocalCommit() {
        this.startSameIdChainParse();
        this.parseRDBCMMreply();
        this.endOfSameIdChainData();
    }

    private void parseRDBCMMreply() {
        this.parseTypdefsOrMgrlvlovrs();
        this.parseENDUOWRM();
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        if (peekCP == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
        } else {
            this.parseCommitError();
        }
    }

    private void parseCommitError() {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                throw new IllegalStateException("Abnormal ending to UOW");
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                DRDAConnectResponse.throwUnknownCodepoint(peekCP);
            }
        }
    }

    void parseCommonError(int peekCP) {
        switch (peekCP) {
            case 4688: {
                this.parseCMDNSPRM();
                break;
            }
            case 4677: {
                this.parsePRCCNVRM();
                break;
            }
            case 4684: {
                this.parseSYNTAXRM();
                break;
            }
            case 4690: {
                this.parseVALNSPRM();
                break;
            }
            default: {
                DRDAConnectResponse.throwUnknownCodepoint(peekCP);
            }
        }
    }

    private void parseVALNSPRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean codpntReceived = false;
        int codpnt = 0;
        this.parseLengthAndMatchCodePoint(4690);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 12) {
                foundInPass = true;
                codpntReceived = this.checkAndGetReceivedFlag(codpntReceived);
                codpnt = this.parseCODPNT();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAConnectResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!codpntReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("CODPNT", 12);
        }
        this.doValnsprmSemantics(codpnt, "\"\"");
    }

    private void parseSYNTAXRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean synerrcdReceived = false;
        int synerrcd = 0;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean codpntReceived = false;
        int codpnt = 0;
        this.parseLengthAndMatchCodePoint(4684);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4426) {
                foundInPass = true;
                synerrcdReceived = this.checkAndGetReceivedFlag(synerrcdReceived);
                synerrcd = this.parseSYNERRCD();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4435) {
                foundInPass = true;
                String serverDiagnostics = this.parseSRVDGN();
                System.out.println("Server diagnostics: " + serverDiagnostics);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 12) {
                foundInPass = true;
                codpntReceived = this.checkAndGetReceivedFlag(codpntReceived);
                codpnt = this.parseCODPNT();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAConnectResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!synerrcdReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("SYNERRCD", 4426);
        }
        this.doSyntaxrmSemantics(synerrcd);
    }

    String parseSRVDGN() {
        this.parseLengthAndMatchCodePoint(4435);
        if (this.metadata.isZos()) {
            return this.readString(CCSIDConstants.EBCDIC);
        }
        return this.readString();
    }

    private int parseSYNERRCD() {
        this.parseLengthAndMatchCodePoint(4426);
        int synerrcd = this.readUnsignedByte();
        if (synerrcd < 1 || synerrcd > 29) {
            this.doValnsprmSemantics(4426, synerrcd);
        }
        return synerrcd;
    }

    private void parsePRCCNVRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean prccnvcdReceived = false;
        int prccnvcd = 0;
        this.parseLengthAndMatchCodePoint(4677);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_SESDMG);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4415) {
                foundInPass = true;
                prccnvcdReceived = this.checkAndGetReceivedFlag(prccnvcdReceived);
                prccnvcd = this.parsePRCCNVCD();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAConnectResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!prccnvcdReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("PRCCNVCD", 4415);
        }
        this.doPrccnvrmSemantics(4677);
    }

    private void doPrccnvrmSemantics(int conversationProtocolErrorCode) {
        throw new IllegalStateException("DRDA_CONNECTION_TERMINATED CONN_DRDA_PRCCNVRM " + Integer.toHexString(conversationProtocolErrorCode));
    }

    private int parsePRCCNVCD() {
        this.parseLengthAndMatchCodePoint(4415);
        int prccnvcd = this.readUnsignedByte();
        if (prccnvcd != 1 && prccnvcd != 2 && prccnvcd != 3 && prccnvcd != 4 && prccnvcd != 5 && prccnvcd != 6 && prccnvcd != 16 && prccnvcd != 17 && prccnvcd != 18 && prccnvcd != 19 && prccnvcd != 21) {
            this.doValnsprmSemantics(4415, prccnvcd);
        }
        return prccnvcd;
    }

    void parseRDBNACRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8708);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAConnectResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!rdbnamReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("RDBNAM", 8464);
        }
        throw new IllegalStateException("SQLState.DRDA_CONNECTION_TERMINATED");
    }

    void parseCMDCHKRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(4692);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_SESDMG);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4444) {
                foundInPass = true;
                this.parseLengthAndMatchCodePoint(4444);
                this.skipBytes();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAConnectResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        NetSqlca netSqlca = this.parseSQLCARD(null);
        throw new IllegalStateException("SQLState.DRDA_CONNECTION_TERMINATED");
    }

    private RDBAccessData parseACCRDBreply() {
        int peekCP = this.peekCodePoint();
        if (peekCP != 8705) {
            throw new IllegalStateException("Expected state ACCRDBRM but got " + Integer.toHexString(peekCP));
        }
        RDBAccessData accessData = this.parseACCRDBRM();
        this.parseInitialPBSD();
        peekCP = this.peekCodePoint();
        if (peekCP == -2) {
            return accessData;
        }
        this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        NetSqlca.complete(netSqlca, new int[0]);
        return accessData;
    }

    private void parseInitialPBSD() {
        if (this.peekCodePoint() != 49152) {
            return;
        }
        this.parseLengthAndMatchCodePoint(49152);
        int peekCP = this.peekCodePoint();
        while (peekCP != -2) {
            this.parseLengthAndMatchCodePoint(peekCP);
            switch (peekCP) {
                case 49153: {
                    int isolationLevel = this.readUnsignedByte();
                    if (isolationLevel == 2) break;
                    throw new IllegalStateException("Database using unsupported transaction isolation level: " + isolationLevel);
                }
                case 49154: {
                    String pbSchema = this.readString(this.getDdmLength(), CCSIDConstants.UTF8);
                    break;
                }
                default: {
                    throw new IllegalStateException("Found unknown codepoint: " + Integer.toHexString(peekCP));
                }
            }
            peekCP = this.peekCodePoint();
        }
    }

    private RDBAccessData parseACCRDBRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean prdidReceived = false;
        String prdid = null;
        boolean typdefnamReceived = false;
        boolean typdefovrReceived = false;
        boolean rdbinttknReceived = false;
        boolean crrtknReceived = false;
        byte[] crrtkn = null;
        boolean usridReceived = false;
        String usrid = null;
        this.parseLengthAndMatchCodePoint(8705);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_WARNING);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4398) {
                foundInPass = true;
                prdidReceived = this.checkAndGetReceivedFlag(prdidReceived);
                prdid = this.parsePRDID(false);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 47) {
                foundInPass = true;
                typdefnamReceived = this.checkAndGetReceivedFlag(typdefnamReceived);
                this.parseTYPDEFNAM();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 53) {
                foundInPass = true;
                typdefovrReceived = this.checkAndGetReceivedFlag(typdefovrReceived);
                this.parseTYPDEFOVR();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8451) {
                foundInPass = true;
                rdbinttknReceived = this.checkAndGetReceivedFlag(rdbinttknReceived);
                this.parseRDBINTTKN(false);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4512) {
                foundInPass = true;
                usridReceived = this.checkAndGetReceivedFlag(usridReceived);
                usrid = this.parseUSRID(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8501) {
                foundInPass = true;
                crrtknReceived = this.checkAndGetReceivedFlag(crrtknReceived);
                crrtkn = this.parseCRRTKN(false);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 9294) {
                foundInPass = true;
                this.parseSRVLST();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4584) {
                foundInPass = true;
                this.parseIPADDR();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAConnectResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            throw new IllegalStateException("Did not find codepoint SVRCOD in reply data");
        }
        if (!prdidReceived) {
            throw new IllegalStateException("Did not find codepoint PRDID in reply data");
        }
        if (!typdefnamReceived) {
            throw new IllegalStateException("Did not find codepoint TYPDEFNAM in reply data");
        }
        if (!typdefovrReceived) {
            throw new IllegalStateException("Did not find codepoint TYPDEFOVR in reply data");
        }
        return new RDBAccessData(svrcod, prdid, crrtknReceived, crrtkn);
    }

    private byte[] parseRDBINTTKN(boolean skip) {
        this.parseLengthAndMatchCodePoint(8451);
        if (skip) {
            this.skipBytes();
            return null;
        }
        return this.readBytes();
    }

    private byte[] parseCRRTKN(boolean skip) {
        this.parseLengthAndMatchCodePoint(8501);
        if (skip) {
            this.skipBytes();
            return null;
        }
        return this.readBytes();
    }

    private void parseSRVLST() {
        this.parseLengthAndMatchCodePoint(9294);
        this.pushLengthOnCollectionStack();
        boolean foundInPass = false;
        boolean foundServerListCount = false;
        boolean foundServerList = false;
        int serverListCount = 0;
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            if (peekCP == 9292) {
                foundInPass = true;
                foundServerListCount = true;
                serverListCount = this.parseSRVLSTCNT();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 9293) {
                foundInPass = true;
                foundServerList = true;
                this.parseSRVLSRV(serverListCount);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAConnectResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!foundServerListCount) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("SRVLSTCNT", 9292);
        }
        if (!foundServerList) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("SRVLSRV", 9293);
        }
    }

    private int parseSRVLSTCNT() {
        this.parseLengthAndMatchCodePoint(9292);
        return this.readUnsignedShort();
    }

    private List<String> parseSRVLSRV(int serverListCount) {
        this.parseLengthAndMatchCodePoint(9293);
        ArrayList<String> serverList = new ArrayList<String>(serverListCount);
        for (int i = 0; i < serverListCount; ++i) {
            int priority = 0;
            boolean foundServerPriority = false;
            int peekCP = this.peekCodePoint();
            if (peekCP == 9295) {
                foundServerPriority = true;
                priority = this.parseSRVPRTY();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 6418) {
                this.parseTCPPORTHOST(false);
            } else if (peekCP == 4584) {
                this.parseIPADDR();
            } else {
                DRDAConnectResponse.throwUnknownCodepoint(peekCP);
            }
            if (foundServerPriority) continue;
            DRDAConnectResponse.throwMissingRequiredCodepoint("SRVPRTY", 9295);
        }
        return serverList;
    }

    private byte[] parseIPADDR() {
        this.parseLengthAndMatchCodePoint(4584);
        return this.readBytes();
    }

    private Object[] parseTCPPORTHOST(boolean skip) {
        this.parseLengthAndMatchCodePoint(6418);
        if (skip) {
            this.skipBytes();
            return null;
        }
        Object[] hostPort = new Object[]{this.readUnsignedShort(), this.readString()};
        return hostPort;
    }

    private int parseSRVPRTY() {
        this.parseLengthAndMatchCodePoint(9295);
        return this.readUnsignedShort();
    }

    private String parseUSRID(boolean skip) {
        this.parseLengthAndMatchCodePoint(4512);
        if (skip) {
            this.skipBytes();
            return null;
        }
        return this.readString();
    }

    private String parsePRDID(boolean skip) {
        this.parseLengthAndMatchCodePoint(4398);
        if (skip) {
            this.skipBytes();
            return null;
        }
        return this.readString();
    }

    private void parseSECCHKreply() {
        int peekCP = this.peekCodePoint();
        if (peekCP != 4633) {
            this.parseCommonError(peekCP);
        }
        this.parseSECCHKRM();
        if (this.peekCodePoint() == 4572) {
            this.parseSECTKN(false);
        }
    }

    private void parseSECCHKRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean secchkcdReceived = false;
        int secchkcd = 0;
        boolean sectknReceived = false;
        byte[] sectkn = null;
        this.parseLengthAndMatchCodePoint(4633);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_SEVERE);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4516) {
                foundInPass = true;
                secchkcdReceived = this.checkAndGetReceivedFlag(secchkcdReceived);
                secchkcd = this.parseSECCHKCD();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4572) {
                foundInPass = true;
                sectknReceived = this.checkAndGetReceivedFlag(sectknReceived);
                sectkn = this.parseSECTKN(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            throw new IllegalStateException("Found unexpected codepoint: " + peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            throw new IllegalStateException("Did not receive SVRCOD codepoint");
        }
        if (!secchkcdReceived) {
            throw new IllegalStateException("Did not receive SECCHKCD codepoint");
        }
        switch (secchkcd) {
            case 0: {
                break;
            }
            case 18: {
                throw new DB2Exception("Missing userid, verify a user value was supplied", -4461, "08001.C.7");
            }
            case 16: {
                throw new DB2Exception("Missing password, verify a password value was supplied", -4461, "08001.C.8");
            }
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: {
                throw new DB2Exception("Invalid credentials, verify the user and password values supplied are correct", -4214, "08004.C.1");
            }
            default: {
                throw new IllegalArgumentException("Authentication failed");
            }
        }
    }

    private void parseACCSECreply(int securityMechanism) {
        int peekCP = this.peekCodePoint();
        if (peekCP != 5292) {
            this.parseAccessSecurityError();
        }
        this.parseACCSECRD(securityMechanism);
    }

    private void parseAccessSecurityError() {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8721: {
                this.parseRDBNFNRM();
                break;
            }
            case 8730: {
                this.parseRdbAccessFailed();
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    private void parseRDBNFNRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8721);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4435) {
                foundInPass = true;
                String serverDiagnostics = this.parseSRVDGN();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAConnectResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!rdbnamReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("RDBNAM", 8464);
        }
        throw new DB2Exception("The requested database was not found: " + this.metadata.databaseName, -30061, "08004.C.2");
    }

    private void parseRdbAccessFailed() {
        this.parseRDBAFLRM();
        if (this.peekCodePoint() == 47) {
            this.parseTYPDEFNAM();
            this.parseTYPDEFOVR();
        } else {
            this.parseTYPDEFOVR();
            this.parseTYPDEFNAM();
        }
        NetSqlca netSqlca = this.parseSQLCARD(null);
        if (netSqlca.getSqlErrmc() != null) {
            NetSqlca.complete(netSqlca, new int[0]);
        }
    }

    private void parseRDBAFLRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        boolean srvdgnReceived = false;
        String rdbnam = null;
        String serverDiagnostics = null;
        this.parseLengthAndMatchCodePoint(8730);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4435) {
                foundInPass = true;
                srvdgnReceived = this.checkAndGetReceivedFlag(srvdgnReceived);
                serverDiagnostics = this.parseSRVDGN();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAConnectResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!rdbnamReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("RDBNAM", 8464);
        }
    }

    private void parseACCSECRD(int securityMechanism) {
        boolean secmecReceived = false;
        int[] secmecList = null;
        boolean sectknReceived = false;
        byte[] sectkn = null;
        boolean secchkcdReceived = false;
        int secchkcd = 0;
        this.parseLengthAndMatchCodePoint(5292);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4514) {
                foundInPass = true;
                secmecReceived = this.checkAndGetReceivedFlag(secmecReceived);
                secmecList = this.parseSECMEC();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4572) {
                foundInPass = true;
                sectknReceived = this.checkAndGetReceivedFlag(sectknReceived);
                sectkn = this.parseSECTKN(false);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4516) {
                foundInPass = true;
                secchkcdReceived = this.checkAndGetReceivedFlag(secchkcdReceived);
                secchkcd = this.parseSECCHKCD();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            throw new IllegalStateException("Found invalid codepoint: " + Integer.toHexString(peekCP));
        }
        this.popCollectionStack();
        if (!secmecReceived) {
            throw new IllegalStateException("Did not receive SECMEC flag in response");
        }
        this.setAccessSecurityData(secchkcd, securityMechanism, secmecList, sectknReceived, sectkn);
    }

    void setAccessSecurityData(int secchkcd, int desiredSecmec, int[] secmecList, boolean sectknReceived, byte[] sectkn) {
        if (secchkcd != 0) {
            throw new IllegalStateException("Got nonzero SECCHKCD codepoint: " + secchkcd);
        }
        if (secmecList.length == 1 && secmecList[0] == desiredSecmec) {
            if (desiredSecmec == 7 || desiredSecmec == 9 || desiredSecmec == 8 || desiredSecmec == 12 || desiredSecmec == 13) {
                if (!sectknReceived) {
                    throw new IllegalStateException("SQLState.NET_SECTKN_NOT_RETURNED");
                }
                throw new UnsupportedOperationException();
            }
        } else {
            throw new IllegalStateException("SQLState.NET_SECKTKN_NOT_RETURNED");
        }
    }

    private int parseSECCHKCD() {
        this.parseLengthAndMatchCodePoint(4516);
        int secchkcd = this.readUnsignedByte();
        if (secchkcd < 0 || secchkcd > 21) {
            this.doValnsprmSemantics(4516, secchkcd);
        }
        return secchkcd;
    }

    private byte[] parseSECTKN(boolean skip) {
        this.parseLengthAndMatchCodePoint(4572);
        if (skip) {
            this.skipBytes();
            return null;
        }
        return this.readBytes();
    }

    private int[] parseSECMEC() {
        this.parseLengthAndMatchCodePoint(4514);
        return this.readUnsignedShortList();
    }

    private void parseEXCSATreply() {
        if (this.peekCodePoint() != 5187) {
            this.parseExchangeServerAttributesError();
            return;
        }
        this.parseEXCSATRD();
    }

    private void parseExchangeServerAttributesError() {
        int peekCP = this.peekCodePoint();
        throw new IllegalStateException(String.format("Invalid codepoint: %02x", peekCP));
    }

    void parseCMDNSPRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean codpntReceived = false;
        int codpnt = 0;
        this.parseLengthAndMatchCodePoint(4688);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 12) {
                foundInPass = true;
                codpntReceived = this.checkAndGetReceivedFlag(codpntReceived);
                codpnt = this.parseCODPNT();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAConnectResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!codpntReceived) {
            DRDAConnectResponse.throwMissingRequiredCodepoint("CODPNT", 12);
        }
        throw new IllegalStateException("DRDA_DDM_COMMAND_NOT_SUPPORTED: " + Integer.toHexString(codpnt));
    }

    private int parseCODPNT() {
        this.parseLengthAndMatchCodePoint(12);
        return this.parseCODPNTDR();
    }

    private int parseCODPNTDR() {
        return this.readUnsignedShort();
    }

    private void parseEXCSATRD() {
        boolean extnamReceived = false;
        boolean mgrlvllsReceived = false;
        boolean srvclsnmReceived = false;
        String srvclsnm = null;
        boolean srvnamReceived = false;
        boolean srvrlslvReceived = false;
        String srvrlslv = null;
        this.parseLengthAndMatchCodePoint(5187);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4446) {
                foundInPass = true;
                extnamReceived = this.checkAndGetReceivedFlag(extnamReceived);
                this.parseLengthAndMatchCodePoint(4446);
                String extnam = this.readString();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 5124) {
                foundInPass = true;
                mgrlvllsReceived = this.checkAndGetReceivedFlag(mgrlvllsReceived);
                this.parseMGRLVLLS();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4423) {
                foundInPass = true;
                srvclsnmReceived = this.checkAndGetReceivedFlag(srvclsnmReceived);
                this.parseLengthAndMatchCodePoint(4423);
                srvclsnm = this.readString();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4461) {
                foundInPass = true;
                srvnamReceived = this.checkAndGetReceivedFlag(srvnamReceived);
                this.parseLengthAndMatchCodePoint(4461);
                this.readString();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4442) {
                foundInPass = true;
                srvrlslvReceived = this.checkAndGetReceivedFlag(srvrlslvReceived);
                this.parseLengthAndMatchCodePoint(4442);
                srvrlslv = this.readString();
                if (srvrlslv != null && srvrlslv.startsWith("SQL")) {
                    this.metadata.setZos(false);
                } else if (srvrlslv != null && srvrlslv.startsWith("DSN")) {
                    this.metadata.setZos(true);
                } else {
                    throw new IllegalStateException("Received unknown server product release level: " + srvrlslv);
                }
                peekCP = this.peekCodePoint();
            }
            if (!foundInPass) {
                DRDAConnectResponse.throwUnknownCodepoint(peekCP);
            }
            if (srvrlslvReceived) continue;
            DRDAConnectResponse.throwMissingRequiredCodepoint("SRVRLSLV", 4442);
        }
        this.ddmCollectionLenStack.pop();
    }

    private void parseMGRLVLLS() {
        this.parseLengthAndMatchCodePoint(5124);
        int managerListLength = this.getDdmLength();
        if (managerListLength == 0 || managerListLength % 4 != 0) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_OBJ_LEN_NOT_ALLOWED);
        }
        int managerCount = managerListLength / 4;
        block3: for (int i = 0; i < managerCount; ++i) {
            int managerCodePoint = this.readUnsignedShort();
            int managerLevel = this.readUnsignedShort();
            switch (managerCodePoint) {
                case 5123: 
                case 5184: 
                case 5236: 
                case 7176: 
                case 9223: 
                case 9231: {
                    continue block3;
                }
                default: {
                    System.out.println("  WARN: Unknown manager codepoint: 0x" + Integer.toHexString(managerCodePoint));
                }
            }
        }
    }

    public static class RDBAccessData {
        public final int svrcod;
        public final String prdid;
        public final byte[] correlationToken;

        public RDBAccessData(int svrcod, String prdid, boolean crrtknReceived, byte[] crrtkn) {
            this.svrcod = svrcod;
            this.prdid = prdid;
            this.correlationToken = (byte[])(crrtknReceived ? crrtkn : null);
        }
    }
}

