/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.netty.buffer.ByteBuf;
import io.vertx.db2client.impl.drda.ClientTypes;
import io.vertx.db2client.impl.drda.CodePoint;
import io.vertx.db2client.impl.drda.ColumnMetaData;
import io.vertx.db2client.impl.drda.ConnectionMetaData;
import io.vertx.db2client.impl.drda.Cursor;
import io.vertx.db2client.impl.drda.DRDAConnectResponse;
import io.vertx.db2client.impl.drda.FdocaConstants;
import io.vertx.db2client.impl.drda.NetSqlca;
import io.vertx.db2client.impl.drda.Section;
import io.vertx.db2client.impl.drda.Typdef;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DRDAQueryResponse
extends DRDAConnectResponse {
    private ColumnMetaData outputColumnMetaData = null;
    private ColumnMetaData inputColumnMetaData = null;
    private Cursor cursor;
    private NetSqlca sqlca;
    private long queryInstanceId = 0L;

    public DRDAQueryResponse(ByteBuf buffer, ConnectionMetaData metadata) {
        super(buffer, metadata);
    }

    public void readPrepareDescribeOutput() {
        this.startSameIdChainParse();
        this.parsePRPSQLSTTreply();
        this.endOfSameIdChainData();
    }

    public void readPrepareDescribeInputOutput() {
        this.readPrepareDescribeOutput();
        this.readDescribeInput();
        this.completePrepareDescribe();
    }

    private void completePrepareDescribe() {
        if (this.outputColumnMetaData == null) {
            return;
        }
    }

    public void readDescribeInput() {
        this.startSameIdChainParse();
        this.parseDSCSQLSTTreply(false);
        this.endOfSameIdChainData();
    }

    private void parseDSCSQLSTTreply(boolean isOutput) {
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        ColumnMetaData columnMetaData = new ColumnMetaData();
        if (isOutput) {
            this.outputColumnMetaData = columnMetaData;
        } else {
            this.inputColumnMetaData = columnMetaData;
        }
        if (peekCP == 9233) {
            NetSqlca netSqlca = this.parseSQLDARD(columnMetaData, false);
            NetSqlca.complete(netSqlca, new int[0]);
        } else if (peekCP == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            NetSqlca.complete(netSqlca, new int[0]);
        } else {
            throw new IllegalStateException("Parse describe error");
        }
    }

    @Deprecated
    public void readOpenQuery() {
        this.startSameIdChainParse();
        this.parseOPNQRYreply();
        this.endOfSameIdChainData();
    }

    public void readBeginOpenQuery() {
        this.startSameIdChainParse();
        int peekCP = this.peekCodePoint();
        if (peekCP == 8709) {
            this.parseBeginOpenQuery();
        } else if (peekCP == 8728) {
            this.parseRDBUPDRM();
            this.parseBeginOpenQuery();
        } else if (peekCP == 8722) {
            this.parseOpenQueryFailure();
        } else {
            this.parseOpenQueryError();
        }
    }

    private void parseBeginOpenQuery() {
        int peekCP = this.peekCodePoint();
        if (peekCP == 8709) {
            this.parseOPNQRYRM(true);
            peekCP = this.peekCodePoint();
            if (peekCP != 9242) {
                peekCP = this.parseTypdefsOrMgrlvlovrs();
                if (peekCP == 9233) {
                    this.outputColumnMetaData = new ColumnMetaData();
                    NetSqlca netSqlca = this.parseSQLDARD(this.outputColumnMetaData, false);
                    if (netSqlca != null) {
                        NetSqlca.complete(netSqlca, new int[0]);
                    }
                    peekCP = this.parseTypdefsOrMgrlvlovrs();
                }
                if (peekCP == 9224) {
                    this.sqlca = this.parseSQLCARD(null);
                    peekCP = this.parseTypdefsOrMgrlvlovrs();
                }
            }
            this.parseQRYDSC();
        }
    }

    public void readFetch(Cursor c) {
        this.startSameIdChainParse();
        this.cursor = c;
        this.cursor.resetDataBuffer();
        this.parseCNTQRYreply(true);
        this.endOfSameIdChainData();
    }

    public void readCursorClose() {
        this.startSameIdChainParse();
        this.parseCLSQRYreply();
        this.endOfSameIdChainData();
    }

    public long readExecuteImmediate() {
        this.startSameIdChainParse();
        long updateCount = this.parseEXCSQLIMMreply();
        this.endOfSameIdChainData();
        return updateCount;
    }

    public long readExecute() {
        this.startSameIdChainParse();
        long updateCount = this.parseEXCSQLSTTreply();
        this.endOfSameIdChainData();
        return updateCount;
    }

    private void parseCNTQRYreply(boolean doCopyQrydta) {
        boolean found = false;
        int peekCP = this.peekCodePoint();
        if (peekCP == 8728) {
            found = true;
            this.parseRDBUPDRM();
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 9243) {
            found = true;
            if (!doCopyQrydta) {
                throw new UnsupportedOperationException("Not implemented");
            }
            do {
                this.parseQRYDTA();
            } while ((peekCP = this.peekCodePoint()) == 9243);
        }
        if (peekCP == 5228) {
            found = true;
            throw new UnsupportedOperationException("Not implemented");
        }
        if (peekCP == 9224) {
            found = true;
            throw new UnsupportedOperationException("Read SQLCARD on fetch");
        }
        if (peekCP == 8715) {
            found = true;
            this.parseEndQuery();
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 8728) {
            found = true;
            this.parseRDBUPDRM();
            peekCP = this.peekCodePoint();
        }
        if (!found) {
            this.parseFetchError();
        }
        if (peekCP == 49152) {
            this.parsePBSD();
        }
    }

    private void parseFetchError() {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                throw new IllegalStateException("Abnormal UOW end");
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4688: {
                this.parseCMDNSPRM();
                break;
            }
            case 8706: {
                this.parseQRYNOPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    private void parseQRYNOPRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean pkgnamcsnReceived = false;
        Section pkgnamcsn = null;
        this.parseLengthAndMatchCodePoint(8706);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8467) {
                foundInPass = true;
                pkgnamcsnReceived = this.checkAndGetReceivedFlag(pkgnamcsnReceived);
                pkgnamcsn = this.parsePKGNAMCSN(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!rdbnamReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("RDBNAM", 8464);
        }
        if (!pkgnamcsnReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("PKGNAMCSN", 8467);
        }
        if (svrcod == CodePoint.SVRCOD_WARNING) {
            throw new IllegalStateException("DRDA_CURSOR_NOT_OPEN");
        }
        throw new IllegalStateException("DRDA_CURSOR_NOT_OPEN");
    }

    private long parseEXCSQLSTTreply() {
        int peekCP = this.peekCodePoint();
        if (peekCP == 8728) {
            this.parseRDBUPDRM();
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 8716) {
            this.parseENDUOWRM();
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 8729) {
            this.parseResultSetProcedure();
            peekCP = this.peekCodePoint();
            if (peekCP == 8728) {
                this.parseRDBUPDRM();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 49152) {
                this.parsePBSD();
            }
            return 0L;
        }
        peekCP = this.parseTypdefsOrMgrlvlovrs();
        long updateCount = 0L;
        if (peekCP == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            NetSqlca.complete(netSqlca, new int[0]);
            updateCount = netSqlca.getUpdateCount();
            peekCP = this.peekCodePoint();
        } else {
            if (peekCP == 9235) {
                throw new UnsupportedOperationException("stored procedure");
            }
            this.parseExecuteError();
        }
        if (peekCP == 49152) {
            this.parsePBSD();
            peekCP = this.peekCodePoint();
        }
        return updateCount;
    }

    private void parseResultSetProcedure() {
        List<Section> sectionAL = this.parseRSLSETRM();
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = null;
        if (peekCP == 9224) {
            netSqlca = this.parseSQLCARD(null);
        } else {
            this.cursor = new Cursor(this.metadata);
            netSqlca = this.parseSQLDTARD();
        }
        peekCP = this.parseTypdefsOrMgrlvlovrs();
        int numberOfResultSets = this.parseSQLRSLRD(sectionAL);
        throw new UnsupportedOperationException("Results for stored procedures not implemented");
    }

    public void completeExecute(NetSqlca sqlca) {
        if (sqlca == null) {
            return;
        }
        int sqlcode = sqlca.getSqlCode();
        if (sqlcode < 0) {
            throw new IllegalStateException("" + sqlcode);
        }
        long updateCount_ = sqlca.getUpdateCount();
        if (sqlcode > 0 && sqlcode != 466 && sqlcode != 100) {
            System.out.println("WARN: sqlcode: " + sqlcode);
        }
    }

    void copyEXTDTA() {
        this.parseLengthAndMatchCodePoint(5228);
        byte[] data = null;
        data = this.getData().array();
        this.cursor.extdtaData_.add(data);
    }

    private int parseSQLRSLRD(List<Section> sections) {
        this.parseLengthAndMatchCodePoint(9230);
        return this.parseSQLRSLRDarray(sections);
    }

    private int parseSQLRSLRDarray(List<Section> sections) {
        int numOfResultSets = this.parseSQLNUMROW();
        for (int i = 0; i < numOfResultSets; ++i) {
            this.parseSQLRSROW(sections.get(i));
        }
        return numOfResultSets;
    }

    private void parseSQLRSROW(Section section) {
        this.parseSQLRSGRP(section);
    }

    private void parseSQLRSGRP(Section section) {
        int rsLocator = this.buffer.readInt();
        String rsName = this.parseVCMorVCS();
        int rsNumRows = this.buffer.readInt();
    }

    private String parseVCMorVCS() {
        String stringToBeSet = null;
        int vcm_length = this.readUnsignedShort();
        if (vcm_length > 0) {
            stringToBeSet = this.readString(vcm_length, Typdef.targetTypdef.getCcsidMbcEncoding());
        }
        int vcs_length = this.readUnsignedShort();
        if (vcm_length > 0 && vcs_length > 0) {
            throw new IllegalStateException("NET_VCM_VCS_LENGTHS_INVALID");
        }
        if (vcs_length > 0) {
            stringToBeSet = this.readString(vcs_length, Typdef.targetTypdef.getCcsidSbcEncoding());
        }
        return stringToBeSet;
    }

    private NetSqlca parseSQLDTARD() {
        boolean fdodscReceived = false;
        boolean fdodtaReceived = false;
        this.parseLengthAndMatchCodePoint(9235);
        this.pushLengthOnCollectionStack();
        NetSqlca netSqlca = null;
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 16) {
                foundInPass = true;
                fdodscReceived = this.checkAndGetReceivedFlag(fdodscReceived);
                this.parseFDODSC();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 5242) {
                foundInPass = true;
                fdodtaReceived = this.checkAndGetReceivedFlag(fdodtaReceived);
                netSqlca = this.parseFDODTA();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!fdodscReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("FDODSC", 16);
        }
        if (!fdodtaReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("FDODTA", 5242);
        }
        this.cursor.calculateColumnOffsetsForRow();
        return netSqlca;
    }

    private void parseFDODSC() {
        this.parseLengthAndMatchCodePoint(16);
        this.parseSQLDTARDarray(false);
    }

    private NetSqlca parseFDODTA() {
        this.parseLengthAndMatchCodePoint(5242);
        int ddmLength = this.getDdmLength();
        this.ensureBLayerDataInBuffer(ddmLength);
        int start = this.buffer.readerIndex();
        NetSqlca netSqlca = this.parseSQLCARDrow(null);
        int length = this.buffer.readerIndex() - start;
        this.adjustLengths(length);
        this.parseFastSQLDTARDdata();
        return netSqlca;
    }

    private void parseFastSQLDTARDdata() {
        this.parseSQLDTARDdata();
    }

    private List<Section> parseRSLSETRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean pkgsnlstReceived = false;
        List<Section> pkgsnlst = null;
        this.parseLengthAndMatchCodePoint(8729);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_INFO);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8505) {
                foundInPass = true;
                pkgsnlstReceived = this.checkAndGetReceivedFlag(pkgsnlstReceived);
                pkgsnlst = this.parsePKGSNLST();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!pkgsnlstReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("PKGSNLST", 8505);
        }
        return pkgsnlst;
    }

    private List<Section> parsePKGSNLST() {
        ArrayList<Section> pkgsnlst = new ArrayList<Section>();
        this.parseLengthAndMatchCodePoint(8505);
        this.pushLengthOnCollectionStack();
        while (this.peekCodePoint() != -1) {
            pkgsnlst.add(this.parsePKGNAMCSN(false));
        }
        this.popCollectionStack();
        return pkgsnlst;
    }

    Section parsePKGNAMCSN(boolean skip) {
        this.parseLengthAndMatchCodePoint(8467);
        if (skip) {
            this.skipBytes();
            return null;
        }
        String rdbnam = null;
        String rdbcolid = null;
        String pkgid = null;
        byte[] pkgcnstkn = null;
        int pkgsn = 0;
        byte[] pkgnamcsnBytes = null;
        int pkgnamcsnLength = 0;
        int ddmLength = this.getDdmLength();
        int offset = 0;
        this.ensureBLayerDataInBuffer(ddmLength);
        int maxDDMlength = 1550;
        if (ddmLength == 64) {
            pkgnamcsnLength = ddmLength - 2;
            pkgnamcsnBytes = new byte[pkgnamcsnLength];
            offset = this.peekFastBytes(pkgnamcsnBytes, offset, pkgnamcsnLength);
            rdbnam = this.readFastString(18);
            rdbcolid = this.readFastString(18);
            pkgid = this.readFastString(18);
            pkgcnstkn = this.readFastBytes(8);
        } else if (ddmLength >= 71 && ddmLength <= maxDDMlength) {
            pkgnamcsnBytes = new byte[ddmLength - 2];
            int scldtaLen = this.peekFastLength();
            int maxRDBlength = 1024;
            if (scldtaLen < 18 || scldtaLen > maxRDBlength) {
                throw new IllegalStateException("NET_SQLCDTA_INVALID_FOR_RDBNAM " + scldtaLen);
            }
            offset = this.peekFastBytes(pkgnamcsnBytes, offset, 2 + scldtaLen);
            this.skipFastBytes(2);
            rdbnam = this.readFastString(scldtaLen);
            scldtaLen = this.peekFastLength();
            if (scldtaLen < 18 || scldtaLen > 255) {
                throw new IllegalStateException("NET_SQLCDTA_INVALID_FOR_RDBCOLID " + scldtaLen);
            }
            offset = this.peekFastBytes(pkgnamcsnBytes, offset, 2 + scldtaLen);
            this.skipFastBytes(2);
            rdbcolid = this.readFastString(scldtaLen);
            scldtaLen = this.peekFastLength();
            if (scldtaLen < 18 || scldtaLen > 255) {
                throw new IllegalStateException("NET_SQLCDTA_INVALID_FOR_PKGID " + scldtaLen);
            }
            offset = this.peekFastBytes(pkgnamcsnBytes, offset, 2 + scldtaLen);
            this.skipFastBytes(2);
            pkgid = this.readFastString(scldtaLen);
            offset = this.peekFastBytes(pkgnamcsnBytes, offset, 8);
            pkgcnstkn = this.readFastBytes(8);
        } else {
            throw new IllegalStateException("NET_PGNAMCSN_INVALID_AT_SQLAM " + ddmLength);
        }
        pkgsn = this.readFastUnsignedShort();
        this.adjustLengths(ddmLength);
        throw new UnsupportedOperationException("Server generated sections not implemented");
    }

    private void parseExecuteError() {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                throw new IllegalStateException("Abnormal end UOW");
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca sqlca = this.parseSqlErrorCondition();
                NetSqlca.complete(sqlca, new int[0]);
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    private void parseCLSQRYreply() {
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        if (peekCP == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            if (netSqlca != null) {
                int sqlcode = netSqlca.getSqlCode();
                if (sqlcode == 100 || sqlcode == 20237) {
                    this.cursor.setAllRowsReceivedFromServer(true);
                } else {
                    NetSqlca.complete(netSqlca, new int[0]);
                }
            }
        } else {
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
    }

    public boolean readOpenQueryData() {
        int peekCP = this.peekCodePoint();
        if (peekCP == 9243) {
            this.parseQRYDTA();
            return true;
        }
        return false;
    }

    public boolean isQueryComplete() {
        boolean isQueryComplete;
        if (this.cursor.allRowsReceivedFromServer()) {
            return true;
        }
        int peekCP = this.peekCodePoint();
        boolean bl = isQueryComplete = peekCP == 9224 || peekCP == 8715;
        if (isQueryComplete) {
            this.cursor.setAllRowsReceivedFromServer(true);
        }
        return isQueryComplete;
    }

    public void readEndOpenQuery() {
        int peekCP = this.peekCodePoint();
        if (peekCP == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            NetSqlca.complete(netSqlca, new int[0]);
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 8715) {
            this.parseEndQuery();
        }
        this.completeOpenQuery(this.sqlca);
        this.endOfSameIdChainData();
    }

    private long parseEXCSQLIMMreply() {
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        if (peekCP == 8728) {
            this.parseRDBUPDRM();
            peekCP = this.parseTypdefsOrMgrlvlovrs();
        }
        long updateCount = 0L;
        switch (peekCP) {
            case 8716: {
                this.parseENDUOWRM();
                this.parseTypdefsOrMgrlvlovrs();
            }
            case 9224: {
                NetSqlca netSqlca = this.parseSQLCARD(null);
                if (netSqlca == null) break;
                NetSqlca.complete(netSqlca, 100);
                if (netSqlca.getSqlCode() < 0) break;
                updateCount = netSqlca.getUpdateCount();
                break;
            }
            default: {
                this.parseExecuteImmediateError();
            }
        }
        if ((peekCP = this.peekCodePoint()) == 49152) {
            this.parsePBSD();
        }
        return updateCount;
    }

    private void parseExecuteImmediateError() {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                throw new IllegalStateException("Abnormal ending to UOW");
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca sqlca = this.parseSqlErrorCondition();
                NetSqlca.complete(sqlca, new int[0]);
                break;
            }
            default: {
                DRDAQueryResponse.throwUnknownCodepoint(peekCP);
            }
        }
    }

    private void parseOPNQRYreply() {
        int peekCP = this.peekCodePoint();
        if (peekCP == 8709) {
            this.parseOpenQuery();
            peekCP = this.peekCodePoint();
            if (peekCP == 8728) {
                this.parseRDBUPDRM();
                peekCP = this.peekCodePoint();
            }
        } else if (peekCP == 8728) {
            this.parseRDBUPDRM();
            this.parseOpenQuery();
            peekCP = this.peekCodePoint();
        } else if (peekCP == 8722) {
            this.parseOpenQueryFailure();
        } else {
            this.parseOpenQueryError();
        }
        if (peekCP == 49152) {
            this.parsePBSD();
        }
    }

    private void parseOpenQueryError() {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                NetSqlca sqlca = this.parseAbnormalEndUow();
                NetSqlca.complete(sqlca, new int[0]);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8719: {
                this.parseQRYPOPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    private NetSqlca parseAbnormalEndUow() {
        this.parseABNUOWRM();
        if (this.peekCodePoint() != 9224) {
            this.parseTypdefsOrMgrlvlovrs();
        }
        NetSqlca netSqlca = this.parseSQLCARD(null);
        return netSqlca;
    }

    private void parseQRYPOPRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean pkgnamcsnReceived = false;
        Section pkgnamcsn = null;
        this.parseLengthAndMatchCodePoint(8719);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8467) {
                foundInPass = true;
                pkgnamcsnReceived = this.checkAndGetReceivedFlag(pkgnamcsnReceived);
                pkgnamcsn = this.parsePKGNAMCSN(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!rdbnamReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("RDBNAM", 8464);
        }
        if (!pkgnamcsnReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("PKGNAMCSN", 8467);
        }
        throw new IllegalStateException("DRDA_CONNECTION_TERMINATED CONN_DRDA_QRYOPEN");
    }

    void parsePBSD() {
        this.parseLengthAndMatchCodePoint(49152);
        int peekCP = this.peekCodePoint();
        while (peekCP != -2) {
            this.parseLengthAndMatchCodePoint(peekCP);
            switch (peekCP) {
                case 49153: {
                    throw new UnsupportedOperationException("PBSD_ISO not implemented");
                }
                case 49154: {
                    throw new UnsupportedOperationException("PBSD_ISO not implemented");
                }
            }
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
            peekCP = this.peekCodePoint();
        }
    }

    protected void parseRDBUPDRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        this.parseLengthAndMatchCodePoint(8728);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_INFO);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!rdbnamReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("RDBNAM", 8464);
        }
    }

    @Deprecated
    private void parseOpenQuery() {
        NetSqlca netSqlca;
        this.parseOPNQRYRM(true);
        NetSqlca sqlca = null;
        int peekCP = this.peekCodePoint();
        if (peekCP != 9242) {
            peekCP = this.parseTypdefsOrMgrlvlovrs();
            if (peekCP == 9233) {
                this.outputColumnMetaData = new ColumnMetaData();
                netSqlca = this.parseSQLDARD(this.outputColumnMetaData, false);
                NetSqlca.complete(netSqlca, new int[0]);
                peekCP = this.parseTypdefsOrMgrlvlovrs();
            }
            if (peekCP == 9224) {
                sqlca = this.parseSQLCARD(null);
                peekCP = this.parseTypdefsOrMgrlvlovrs();
            }
        }
        this.parseQRYDSC();
        peekCP = this.peekCodePoint();
        while (peekCP == 9243) {
            this.parseQRYDTA();
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 9224) {
            netSqlca = this.parseSQLCARD(null);
            NetSqlca.complete(netSqlca, new int[0]);
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 8715) {
            this.parseEndQuery();
        }
        this.completeOpenQuery(sqlca);
    }

    private void parseOpenQueryFailure() {
        this.parseOPNQFLRM();
        this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        NetSqlca.complete(netSqlca, new int[0]);
    }

    private void parseOPNQFLRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8722);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!rdbnamReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("RDBNAM", 8464);
        }
    }

    public void completeOpenQuery(NetSqlca sqlca) {
        NetSqlca.complete(sqlca, new int[0]);
        if (sqlca != null && sqlca.getSqlCode() < 0) {
            return;
        }
    }

    void parseEndQuery() {
        this.parseENDQRYRM();
        this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        this.cursor.setAllRowsReceivedFromServer(true);
        int peekCP = this.peekCodePoint();
        if (peekCP == 8728) {
            this.parseRDBUPDRM();
        }
    }

    private void parseENDQRYRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8715);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
    }

    void parseQRYDTA() {
        this.parseLengthAndMatchCodePoint(9243);
        int ddmLength = this.getDdmLength();
        this.ensureBLayerDataInBuffer(ddmLength);
        this.parseSQLDTARDdata();
        this.adjustLengths(this.getDdmLength());
    }

    public Cursor getCursor() {
        if (this.cursor == null) {
            throw new IllegalStateException("Cursor has not been created yet");
        }
        return this.cursor;
    }

    public long getQueryInstanceId() {
        return this.queryInstanceId;
    }

    public ColumnMetaData getOutputColumnMetaData() {
        if (this.outputColumnMetaData == null) {
            throw new IllegalStateException("ColumnMetaData has not been created yet");
        }
        return this.outputColumnMetaData;
    }

    public void setOutputColumnMetaData(ColumnMetaData md) {
        Objects.requireNonNull(md);
        this.outputColumnMetaData = md;
    }

    public ColumnMetaData getInputColumnMetaData() {
        if (this.inputColumnMetaData == null) {
            throw new IllegalStateException("ColumnMetaData has not been created yet");
        }
        return this.inputColumnMetaData;
    }

    private void parseSQLDTARDdata() {
        if (this.cursor == null) {
            this.cursor = new Cursor(this.metadata);
        }
        this.cursor.dataBuffer_ = this.getData();
        this.cursor.lastValidBytePosition_ = this.cursor.dataBuffer_.capacity();
    }

    final ByteBuf getData() {
        boolean readHeader;
        ByteBuf baos = null;
        int copySize = this.dssLength_;
        do {
            readHeader = this.dssIsContinued_;
            this.ensureALayerDataInBuffer(copySize);
            this.adjustLengths(copySize);
            baos = this.buffer.readRetainedSlice(copySize).asReadOnly();
            if (readHeader) {
                this.readDSSContinuationHeader();
            }
            copySize = this.dssLength_;
        } while (readHeader);
        return baos;
    }

    private void parseQRYDSC() {
        this.parseLengthAndMatchCodePoint(9242);
        this.parseSQLDTARDarray(false);
    }

    private void parseSQLDTARDarray(boolean skipBytes) {
        int tripletLength;
        int ddmLength;
        if (skipBytes) {
            this.skipBytes();
        }
        int previousTripletType = 0;
        int previousTripletId = 0;
        int mddProtocolType = 0;
        int columnCount = 0;
        Typdef.targetTypdef.clearMddOverrides();
        this.ensureBLayerDataInBuffer(ddmLength);
        block11: for (ddmLength = this.getDdmLength(); ddmLength > 0; ddmLength -= tripletLength) {
            tripletLength = this.readFastUnsignedByte();
            int tripletType = this.readFastUnsignedByte();
            int tripletId = this.readFastUnsignedByte();
            switch (tripletType) {
                case 120: {
                    if (tripletLength != 7 || tripletId != 0) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(previousTripletType, 2, previousTripletId, 3);
                    previousTripletType = 2;
                    previousTripletId = 3;
                    int mddClass = this.readFastUnsignedByte();
                    int mddType = this.readFastUnsignedByte();
                    int mddRefType = this.readFastUnsignedByte();
                    mddProtocolType = this.readFastUnsignedByte();
                    continue block11;
                }
                case 118: {
                    if (tripletId != 208) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(previousTripletType, 5, previousTripletId, 4);
                    previousTripletType = 5;
                    previousTripletId = 3;
                    int columns = this.peekTotalColumnCount(tripletLength);
                    this.outputColumnMetaData.setColumnCount(columns);
                    this.cursor.initializeColumnInfoArrays(Typdef.targetTypdef, columns);
                    columnCount += this.parseSQLDTAGRPdataLabelsAndUpdateColumn(columnCount, tripletLength);
                    continue block11;
                }
                case 113: {
                    switch (tripletId) {
                        case 224: {
                            if (tripletLength != 9) {
                                this.descriptorErrorDetected();
                            }
                            this.checkPreviousSQLDTARDtriplet(previousTripletType, 4, previousTripletId, 5);
                            previousTripletType = 4;
                            previousTripletId = 5;
                            this.checkFastRLO(FdocaConstants.RLO_SQLCADTA);
                            continue block11;
                        }
                        case 240: {
                            if (tripletLength != 6) {
                                this.descriptorErrorDetected();
                            }
                            this.checkPreviousSQLDTARDtriplet(previousTripletType, 4, previousTripletId, 6);
                            previousTripletType = 4;
                            previousTripletId = 6;
                            this.checkFastRLO(FdocaConstants.RLO_SQLDTARD);
                            continue block11;
                        }
                    }
                    this.descriptorErrorDetected();
                    continue block11;
                }
                case 127: {
                    if (tripletId != 0) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(previousTripletType, 6, previousTripletId, 3);
                    previousTripletType = 6;
                    previousTripletId = 3;
                    columnCount += this.parseSQLDTAGRPdataLabelsAndUpdateColumn(columnCount, tripletLength);
                    continue block11;
                }
                case 112: {
                    if (tripletLength != 12) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(previousTripletType, 3, previousTripletId, 2);
                    previousTripletType = 3;
                    previousTripletId = 2;
                    Typdef.targetTypdef.setMddOverride(mddProtocolType, tripletId, this.readFastUnsignedByte(), this.readFastInt(), this.readFastUnsignedByte(), this.readFastUnsignedByte(), this.readFastShort());
                    continue block11;
                }
                default: {
                    this.descriptorErrorDetected();
                }
            }
        }
        this.adjustLengths(this.getDdmLength());
        this.checkPreviousSQLDTARDtriplet(previousTripletType, 1, previousTripletId, 1);
    }

    private void checkFastRLO(int[][] rlo) {
        for (int i = 0; i < rlo.length; ++i) {
            int repFactor;
            int elementTaken;
            int lid = this.readFastUnsignedByte();
            if (lid != rlo[i][0]) {
                this.descriptorErrorDetected();
            }
            if ((elementTaken = this.readFastUnsignedByte()) != rlo[i][1]) {
                this.descriptorErrorDetected();
            }
            if ((repFactor = this.readFastUnsignedByte()) == rlo[i][2]) continue;
            this.descriptorErrorDetected();
        }
    }

    private int parseSQLDTAGRPdataLabelsAndUpdateColumn(int columnIndex, int tripletLength) {
        int numColumns = (tripletLength - 3) / 3;
        for (int i = columnIndex; i < columnIndex + numColumns; ++i) {
            this.cursor.qrydscTypdef_.updateColumn(this.cursor, this.metadata, i, this.readFastUnsignedByte(), this.readFastUnsignedShort());
        }
        return numColumns;
    }

    protected final int peekTotalColumnCount(int tripletLength) {
        int columnCount = 0;
        int tripletType = 127;
        while (tripletType == 127) {
            columnCount += (tripletLength - 3) / 3;
            this.ensureBLayerDataInBuffer(tripletLength - 3);
            this.buffer.markReaderIndex();
            this.buffer.skipBytes(tripletLength - 3);
            tripletLength = this.buffer.readByte();
            tripletType = this.buffer.readByte();
            this.buffer.resetReaderIndex();
        }
        return columnCount;
    }

    private void checkPreviousSQLDTARDtriplet(int previousTripletType, int tripletType, int previousTripletId, int tripletId) {
        if (!FdocaConstants.SQLDTARD_TRIPLET_TYPES[previousTripletType][tripletType]) {
            this.descriptorErrorDetected();
        }
        if (!FdocaConstants.SQLDTARD_TRIPLET_IDS[previousTripletId][tripletId]) {
            this.descriptorErrorDetected();
        }
    }

    private void descriptorErrorDetected() {
        throw new IllegalStateException("MessageId.CONN_DRDA_INVALIDFDOCA");
    }

    private void parseOPNQRYRM(boolean isOPNQRYreply) {
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean svrcodReceived = false;
        int qryprctyp = 0;
        boolean qryprctypReceived = false;
        int sqlcsrhld = 240;
        boolean sqlcsrhldReceived = false;
        int qryattscr = 240;
        boolean qryattscrReceived = false;
        int qryattsns = 0;
        boolean qryattsnsReceived = false;
        int qryattupd = 0;
        boolean qryattupdReceived = false;
        long qryinsid = 0L;
        boolean qryinsidReceived = false;
        int qryattset = 240;
        boolean qryattsetReceived = false;
        this.parseLengthAndMatchCodePoint(8709);
        int ddmLength = this.getDdmLength();
        this.ensureBLayerDataInBuffer(ddmLength);
        int peekCP = this.peekCodePoint();
        int length = 0;
        while (ddmLength > 0) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                length = this.peekedLength_;
                svrcod = this.parseFastSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_SESDMG);
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8450) {
                foundInPass = true;
                qryprctypReceived = this.checkAndGetReceivedFlag(qryprctypReceived);
                length = this.peekedLength_;
                qryprctyp = this.parseFastQRYPRCTYP();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8479) {
                foundInPass = true;
                sqlcsrhldReceived = this.checkAndGetReceivedFlag(sqlcsrhldReceived);
                length = this.peekedLength_;
                sqlcsrhld = this.parseFastSQLCSRHLD();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8521) {
                foundInPass = true;
                qryattscrReceived = this.checkAndGetReceivedFlag(qryattscrReceived);
                length = this.peekedLength_;
                qryattscr = this.parseFastQRYATTSCR();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8535) {
                foundInPass = true;
                qryattsnsReceived = this.checkAndGetReceivedFlag(qryattsnsReceived);
                length = this.peekedLength_;
                qryattsns = this.parseFastQRYATTSNS();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8528) {
                foundInPass = true;
                qryattupdReceived = this.checkAndGetReceivedFlag(qryattupdReceived);
                length = this.peekedLength_;
                qryattupd = this.parseFastQRYATTUPD();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8539) {
                foundInPass = true;
                qryinsidReceived = this.checkAndGetReceivedFlag(qryinsidReceived);
                length = this.peekedLength_;
                this.queryInstanceId = qryinsid = this.parseFastQRYINSID();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8522) {
                foundInPass = true;
                qryattsetReceived = this.checkAndGetReceivedFlag(qryattsetReceived);
                length = this.peekedLength_;
                qryattset = this.parseFastQRYATTSET();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 9312) {
                foundInPass = true;
                length = this.peekedLength_;
                this.parseFastQRYATTISOL();
                ddmLength = this.adjustDdmLength(ddmLength, length);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
        if (!svrcodReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!qryprctypReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("QRYPRCTYP", 8450);
        }
        if (!qryinsidReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("QRYINSID", 8539);
        }
        this.cursor = new Cursor(this.metadata);
    }

    private int parseFastSQLCSRHLD() {
        this.matchCodePoint(8479);
        int sqlcsrhld = this.readFastUnsignedByte();
        if (sqlcsrhld != 240 && sqlcsrhld != 241) {
            this.doValnsprmSemantics(8479, sqlcsrhld);
        }
        return sqlcsrhld;
    }

    private int parseFastQRYATTSCR() {
        this.matchCodePoint(8521);
        int qryattscr = this.readFastUnsignedByte();
        if (qryattscr != 240 && qryattscr != 241) {
            this.doValnsprmSemantics(8521, qryattscr);
        }
        return qryattscr;
    }

    private int parseFastQRYATTSET() {
        this.matchCodePoint(8522);
        int qryattset = this.readFastUnsignedByte();
        if (qryattset != 240 && qryattset != 241) {
            this.doValnsprmSemantics(8522, qryattset);
        }
        return qryattset;
    }

    private int parseFastQRYATTISOL() {
        this.matchCodePoint(9312);
        return this.readUnsignedShort();
    }

    private int parseFastQRYATTSNS() {
        this.matchCodePoint(8535);
        int qryattsns = this.readFastUnsignedByte();
        switch (qryattsns) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                this.doValnsprmSemantics(8535, qryattsns);
            }
        }
        return qryattsns;
    }

    private int parseFastQRYATTUPD() {
        this.matchCodePoint(8528);
        int qryattupd = this.readFastUnsignedByte();
        switch (qryattupd) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                this.doValnsprmSemantics(8528, qryattupd);
            }
        }
        return qryattupd;
    }

    private long parseFastQRYINSID() {
        this.matchCodePoint(8539);
        return this.readFastLong();
    }

    private int parseFastQRYPRCTYP() {
        this.matchCodePoint(8450);
        int qryprctyp = this.readFastUnsignedShort();
        if (qryprctyp != 9240 && qryprctyp != 9239) {
            this.doValnsprmSemantics(8450, qryprctyp);
        }
        return qryprctyp;
    }

    int parseFastSVRCOD(int minSvrcod, int maxSvrcod) {
        this.matchCodePoint(4425);
        int svrcod = this.readFastUnsignedShort();
        if (svrcod != CodePoint.SVRCOD_INFO && svrcod != CodePoint.SVRCOD_WARNING && svrcod != CodePoint.SVRCOD_ERROR && svrcod != CodePoint.SVRCOD_SEVERE && svrcod != CodePoint.SVRCOD_ACCDMG && svrcod != CodePoint.SVRCOD_PRMDMG && svrcod != CodePoint.SVRCOD_SESDMG) {
            this.doValnsprmSemantics(4425, svrcod);
        }
        if (svrcod < minSvrcod || svrcod > maxSvrcod) {
            this.doValnsprmSemantics(4425, svrcod);
        }
        return svrcod;
    }

    protected final void matchCodePoint(int expectedCodePoint) {
        int actualCodePoint = 0;
        actualCodePoint = this.peekedCodePoint_;
        this.buffer.skipBytes(4);
        if (actualCodePoint != expectedCodePoint) {
            throw new IllegalStateException("SQLState.NET_NOT_EXPECTED_CODEPOINT");
        }
    }

    private void parsePRPSQLSTTreply() {
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        this.outputColumnMetaData = new ColumnMetaData();
        if (peekCP == 9233) {
            NetSqlca netSqlca = null;
            boolean nullSqlca = this.peekForNullSqlcagrp();
            netSqlca = nullSqlca && this.peekNumOfColumns() == 0 ? this.parseSQLDARD(this.outputColumnMetaData, true) : this.parseSQLDARD(this.outputColumnMetaData, false);
            NetSqlca.complete(netSqlca, new int[0]);
        } else if (peekCP == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            NetSqlca.complete(netSqlca, new int[0]);
        } else {
            this.parsePrepareError();
        }
    }

    private void parsePrepareError() {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                throw new UnsupportedOperationException("Abnormal end UOW handling not implemented");
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca sqlca = this.parseSqlErrorCondition();
                NetSqlca.complete(sqlca, new int[0]);
                break;
            }
            default: {
                DRDAQueryResponse.throwUnknownCodepoint(peekCP);
            }
        }
    }

    NetSqlca parseSqlErrorCondition() {
        this.parseSQLERRRM();
        this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        return netSqlca;
    }

    private void parseSQLERRRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        String serverDiagnostics = null;
        this.parseLengthAndMatchCodePoint(8723);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4435) {
                foundInPass = true;
                serverDiagnostics = this.parseSRVDGN();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
    }

    @Override
    void parseRDBNACRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8708);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!rdbnamReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("RDBNAM", 8464);
        }
        throw new IllegalStateException("SQLState.DRDA_CONNECTION_TERMINATED");
    }

    void parseOBJNSPRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean codpntReceived = false;
        int codpnt = 0;
        this.parseLengthAndMatchCodePoint(4691);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_SEVERE);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 12) {
                foundInPass = true;
                codpntReceived = this.checkAndGetReceivedFlag(codpntReceived);
                codpnt = this.parseCODPNT();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!codpntReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("CODPNT", 12);
        }
        throw new IllegalStateException("SQLState.DRDA_DDM_OBJECT_NOT_SUPPORTED");
    }

    private int parseCODPNT() {
        this.parseLengthAndMatchCodePoint(12);
        return this.readUnsignedShort();
    }

    void parseDTAMCHRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean srvdgnReceived = false;
        String serverDiagnostics = null;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8718);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4435) {
                foundInPass = true;
                srvdgnReceived = this.checkAndGetReceivedFlag(srvdgnReceived);
                serverDiagnostics = this.parseSRVDGN();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!rdbnamReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("RDBNAM", 8464);
        }
        throw new IllegalStateException("SQLState.DRDA_CONNECTION_TERMINATED");
    }

    @Override
    void parseCMDCHKRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(4692);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_SESDMG);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4444) {
                foundInPass = true;
                this.parseLengthAndMatchCodePoint(4444);
                this.skipBytes();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        NetSqlca netSqlca = this.parseSQLCARD(null);
        NetSqlca.complete(netSqlca, new int[0]);
        throw new IllegalStateException("SQLState.DRDA_CONNECTION_TERMINATED");
    }

    private void parseABNUOWRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        this.parseLengthAndMatchCodePoint(8717);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                String rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAQueryResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!rdbnamReceived) {
            DRDAQueryResponse.throwMissingRequiredCodepoint("RDBNAM", 8464);
        }
    }

    @Override
    String parseRDBNAM(boolean skip) {
        this.parseLengthAndMatchCodePoint(8464);
        if (skip) {
            this.skipBytes();
            return null;
        }
        return this.readString();
    }

    private NetSqlca parseSQLDARD(ColumnMetaData columnMetaData, boolean skipBytes) {
        this.parseLengthAndMatchCodePoint(9233);
        return this.parseSQLDARDarray(columnMetaData, skipBytes);
    }

    private NetSqlca parseSQLDARDarray(ColumnMetaData columnMetaData, boolean skipBytes) {
        int ddmLength = 0;
        ddmLength = this.getDdmLength();
        this.ensureBLayerDataInBuffer(ddmLength);
        NetSqlca netSqlca = null;
        if (skipBytes) {
            int startPos = this.buffer.readerIndex();
            netSqlca = this.parseSQLCARDrow(null);
            this.skipFastBytes(ddmLength - (this.buffer.readerIndex() - startPos));
            this.adjustLengths(this.getDdmLength());
            return netSqlca;
        }
        netSqlca = this.parseSQLCARDrow(null);
        this.parseSQLDHROW(columnMetaData);
        int numColumns = this.parseSQLNUMROW();
        columnMetaData.setColumnCount(numColumns);
        for (int i = 0; i < columnMetaData.columns_; ++i) {
            this.parseSQLDAROW(columnMetaData, i);
        }
        this.adjustLengths(this.getDdmLength());
        return netSqlca;
    }

    private void parseSQLDAROW(ColumnMetaData columnMetaData, int columnNumber) {
        this.parseSQLDAGRP(columnMetaData, columnNumber);
    }

    private void parseSQLDAGRP(ColumnMetaData columnMetaData, int columnNumber) {
        long columnLength = 0L;
        short precision = this.readFastShort();
        short scale = this.readFastShort();
        columnLength = this.readFastLong();
        short sqlType = this.readFastShort();
        int ccsid = this.readFastUnsignedShort();
        columnMetaData.sqlPrecision_[columnNumber] = precision;
        columnMetaData.sqlScale_[columnNumber] = scale;
        columnMetaData.sqlLength_[columnNumber] = columnLength;
        columnMetaData.sqlType_[columnNumber] = sqlType;
        columnMetaData.nullable_[columnNumber] = (sqlType | 1) == sqlType;
        columnMetaData.sqlCcsid_[columnNumber] = ccsid;
        columnMetaData.types_[columnNumber] = ClientTypes.mapDB2TypeToDriverType(true, sqlType, columnLength, ccsid);
        this.parseSQLDOPTGRP(columnMetaData, columnNumber);
    }

    private void parseSQLDOPTGRP(ColumnMetaData columnMetaData, int columnNumber) {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        short sqlunnamed = this.readFastShort();
        String name = this.parseFastVCMorVCS();
        String label = this.parseFastVCMorVCS();
        String colComments = this.parseFastVCMorVCS();
        if (columnMetaData.sqlName_ == null) {
            columnMetaData.sqlName_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlLabel_ == null) {
            columnMetaData.sqlLabel_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlUnnamed_ == null) {
            columnMetaData.sqlUnnamed_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlComment_ == null) {
            columnMetaData.sqlComment_ = new String[columnMetaData.columns_];
        }
        columnMetaData.sqlName_[columnNumber] = name;
        columnMetaData.sqlLabel_[columnNumber] = label;
        columnMetaData.sqlUnnamed_[columnNumber] = sqlunnamed;
        columnMetaData.sqlComment_[columnNumber] = colComments;
        this.parseSQLUDTGRP(columnMetaData, columnNumber);
        this.parseSQLDXGRP(columnMetaData, columnNumber);
    }

    private void parseSQLUDTGRP(ColumnMetaData columnMetaData, int columnNumber) {
        int jdbcType = columnMetaData.types_[columnNumber];
        if (jdbcType != 2000) {
            if (this.readFastUnsignedByte() == 255) {
                return;
            }
        } else {
            String typeName = this.parseFastVCMorVCS();
            String className = this.parseFastVCMorVCS();
            columnMetaData.sqlUDTname_[columnNumber] = typeName;
            columnMetaData.sqlUDTclassName_[columnNumber] = className;
        }
    }

    private void parseSQLDXGRP(ColumnMetaData columnMetaData, int column) {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        short sqlxkeymem = this.readFastShort();
        short sqlxupdateable = this.readFastShort();
        short sqlxgenerated = this.readFastShort();
        short sqlxparmmode = this.readFastShort();
        String sqlxrdbnam = this.parseFastVCS();
        String sqlxcorname = this.parseFastVCMorVCS();
        String sqlxbasename = this.parseFastVCMorVCS();
        String sqlxschema = this.parseFastVCMorVCS();
        String sqlxname = this.parseFastVCMorVCS();
        if (columnMetaData.sqlxKeymem_ == null) {
            columnMetaData.sqlxKeymem_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxGenerated_ == null) {
            columnMetaData.sqlxGenerated_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxParmmode_ == null) {
            columnMetaData.sqlxParmmode_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxCorname_ == null) {
            columnMetaData.sqlxCorname_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxName_ == null) {
            columnMetaData.sqlxName_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxBasename_ == null) {
            columnMetaData.sqlxBasename_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxUpdatable_ == null) {
            columnMetaData.sqlxUpdatable_ = new int[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxSchema_ == null) {
            columnMetaData.sqlxSchema_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxRdbnam_ == null) {
            columnMetaData.sqlxRdbnam_ = new String[columnMetaData.columns_];
        }
        columnMetaData.sqlxKeymem_[column] = sqlxkeymem;
        columnMetaData.sqlxGenerated_[column] = sqlxgenerated;
        columnMetaData.sqlxParmmode_[column] = sqlxparmmode;
        columnMetaData.sqlxCorname_[column] = sqlxcorname;
        columnMetaData.sqlxName_[column] = sqlxname;
        columnMetaData.sqlxBasename_[column] = sqlxbasename;
        columnMetaData.sqlxUpdatable_[column] = sqlxupdateable;
        columnMetaData.sqlxSchema_[column] = sqlxschema == null ? columnMetaData.sqldSchema_ : sqlxschema;
        columnMetaData.sqlxRdbnam_[column] = sqlxrdbnam == null ? columnMetaData.sqldRdbnam_ : sqlxrdbnam;
    }

    private void parseSQLDHROW(ColumnMetaData columnMetaData) {
        this.parseSQLDHGRP(columnMetaData);
    }

    private void parseSQLDHGRP(ColumnMetaData columnMetaData) {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        short sqldhold = this.readFastShort();
        short sqldreturn = this.readFastShort();
        short sqldscroll = this.readFastShort();
        short sqldsensitive = this.readFastShort();
        short sqldfcode = this.readFastShort();
        short sqldkeytype = this.readFastShort();
        String sqldrdbnam = this.parseFastVCS();
        String sqldschema = this.parseFastVCMorVCS();
        columnMetaData.sqldHold_ = sqldhold;
        columnMetaData.sqldReturn_ = sqldreturn;
        columnMetaData.sqldScroll_ = sqldscroll;
        columnMetaData.sqldSensitive_ = sqldsensitive;
        columnMetaData.sqldFcode_ = sqldfcode;
        columnMetaData.sqldKeytype_ = sqldkeytype;
        columnMetaData.sqldRdbnam_ = sqldrdbnam;
        columnMetaData.sqldSchema_ = sqldschema;
    }

    protected final boolean peekForNullSqlcagrp() {
        int offset = 4 + this.peekedNumOfExtendedLenBytes_;
        byte nullInd = this.buffer.getByte(this.buffer.readerIndex() + offset);
        return nullInd == 255;
    }

    protected final int peekNumOfColumns() {
        int offset = 4 + this.peekedNumOfExtendedLenBytes_ + 1;
        offset = this.skipSQLDHROW(offset);
        if (this.metadata.isZos()) {
            return this.buffer.getShort(this.buffer.readerIndex() + offset);
        }
        return this.buffer.getShortLE(this.buffer.readerIndex() + offset);
    }

    private int skipSQLDHROW(int offset) {
        this.buffer.markReaderIndex();
        this.buffer.readerIndex(offset);
        byte sqldhrowgrpNullInd = this.buffer.readByte();
        if (sqldhrowgrpNullInd == 255) {
            return offset;
        }
        offset += 12;
        short stringLength = this.buffer.readShort();
        offset += stringLength;
        stringLength = this.buffer.readShort();
        offset += stringLength;
        stringLength = this.buffer.readShort();
        this.buffer.resetReaderIndex();
        return offset += stringLength;
    }
}

