/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

class FloatingPoint {
    public static final int IEEE_754_FLOATING_POINT = 72;
    public static final int myVal = -8388609;

    private FloatingPoint() {
    }

    private static final int convertFromByteToInt(byte[] buffer, int offset) {
        return buffer[offset] << 24 | (buffer[offset + 1] & 0xFF) << 16 | (buffer[offset + 2] & 0xFF) << 8 | buffer[offset + 3] & 0xFF;
    }

    private static final long convertFromByteToLong(byte[] buffer, int offset) {
        return ((long)buffer[offset] & 0xFFL) << 56 | ((long)buffer[offset + 1] & 0xFFL) << 48 | ((long)buffer[offset + 2] & 0xFFL) << 40 | ((long)buffer[offset + 3] & 0xFFL) << 32 | ((long)buffer[offset + 4] & 0xFFL) << 24 | ((long)buffer[offset + 5] & 0xFFL) << 16 | ((long)buffer[offset + 6] & 0xFFL) << 8 | (long)buffer[offset + 7] & 0xFFL;
    }

    static float getFloat_IEEE(byte[] buffer, int offset) {
        return Float.intBitsToFloat(FloatingPoint.convertFromByteToInt(buffer, offset));
    }

    static float getFloat_hex(byte[] buffer, int offset) {
        int intVal = FloatingPoint.convertFromByteToInt(buffer, offset);
        int fraction = intVal & 0xFFFFFF;
        if (fraction == 0) {
            return 0.0f;
        }
        int exp = intVal & 0x7F000000;
        exp = (exp >> 24) - 64;
        exp *= 4;
        if (--exp > -127) {
            while ((fraction & 0x800000) == 0) {
                fraction <<= 1;
                if (--exp != -127) continue;
            }
            if (exp > 127) {
                if ((intVal & Integer.MIN_VALUE) == 0) {
                    return Float.POSITIVE_INFINITY;
                }
                return Float.NEGATIVE_INFINITY;
            }
            if (exp == -127) {
                exp = 0;
                fraction >>= 1;
            } else {
                exp += 127;
                fraction &= 0xFF7FFFFF;
            }
        } else {
            while (exp < -127) {
                ++exp;
                fraction >>= 1;
            }
            exp = 0;
            fraction >>= 1;
        }
        int result = intVal & Integer.MIN_VALUE;
        result |= (exp <<= 23);
        return Float.intBitsToFloat(result |= fraction);
    }

    static double getDouble_IEEE(byte[] buffer, int offset) {
        return Double.longBitsToDouble(FloatingPoint.convertFromByteToLong(buffer, offset));
    }

    static double getDouble_hex(byte[] buffer, int offset) {
        long longVal = FloatingPoint.convertFromByteToLong(buffer, offset);
        long fraction = longVal & 0xFFFFFFFFFFFFFFL;
        if (fraction == 0L) {
            return 0.0;
        }
        long exp = longVal & 0x7F00000000000000L;
        exp = (exp >> 56) - 64L;
        exp *= 4L;
        --exp;
        while ((fraction & 0x80000000000000L) == 0L) {
            fraction <<= 1;
            --exp;
        }
        exp += 1023L;
        fraction &= 0xFF7FFFFFFFFFFFFFL;
        long result = 0L;
        result |= longVal & Long.MIN_VALUE;
        result |= (exp <<= 52);
        return Double.longBitsToDouble(result |= (fraction >>= 3));
    }
}

