/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.vertx.db2client.impl.drda.DB2Package;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Section {
    private static final Logger LOG = Logger.getLogger(Section.class.getName());
    final DB2Package pkg;
    final int number;
    private final AtomicBoolean inUse = new AtomicBoolean(true);

    Section(DB2Package pkg, int sectionNumber) {
        this(pkg, sectionNumber, 1);
    }

    Section(DB2Package pkg, int sectionNumber, int resultSetHoldability) {
        this.pkg = pkg;
        this.number = sectionNumber;
    }

    void use() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Marking section for use: " + this);
        }
        if (this.inUse.getAndSet(true)) {
            throw new IllegalStateException("Attempted to use a section multiple times: " + this);
        }
    }

    public void release() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Releasing section: " + this);
        }
        if (!this.inUse.getAndSet(false)) {
            throw new IllegalStateException("Attempted to release section multiple times: " + this);
        }
        this.pkg.freeSections.add(this);
    }

    public String toString() {
        return super.toString() + "{packageName=" + this.pkg.name + ", sectionNumber=" + this.number + ", cursorName=" + this.pkg.cursorNamePrefix + "}";
    }

    static class ImmediateSection
    extends Section {
        public ImmediateSection(DB2Package pkg) {
            super(pkg, pkg.maxSections + 1);
        }

        @Override
        void use() {
        }

        @Override
        public void release() {
        }
    }
}

