/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.spi;

import io.vertx.core.Vertx;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Pool;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.spi.Driver;

public class DB2Driver
implements Driver {
    public Pool createPool(SqlConnectOptions options, PoolOptions poolOptions) {
        return DB2Pool.pool(DB2Driver.wrap(options), poolOptions);
    }

    public Pool createPool(Vertx vertx, SqlConnectOptions options, PoolOptions poolOptions) {
        return DB2Pool.pool(vertx, DB2Driver.wrap(options), poolOptions);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof DB2ConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    private static DB2ConnectOptions wrap(SqlConnectOptions options) {
        if (options instanceof DB2ConnectOptions) {
            return (DB2ConnectOptions)options;
        }
        return new DB2ConnectOptions(options);
    }
}

