/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.db2client.impl.DB2RowImpl;
import io.vertx.db2client.impl.codec.DB2RowDesc;
import io.vertx.db2client.impl.drda.Cursor;
import io.vertx.db2client.impl.drda.DRDAQueryResponse;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.RowDecoder;
import java.math.BigDecimal;
import java.util.stream.Collector;

class RowResultDecoder<C, R>
extends RowDecoder<C, R> {
    private static final Logger LOG = LoggerFactory.getLogger(RowResultDecoder.class);
    final DB2RowDesc rowDesc;
    final Cursor cursor;
    final DRDAQueryResponse response;

    RowResultDecoder(Collector<Row, C, R> collector, DB2RowDesc rowDesc, Cursor cursor, DRDAQueryResponse resp) {
        super(collector);
        this.rowDesc = rowDesc;
        this.cursor = cursor;
        this.response = resp;
    }

    public boolean isQueryComplete() {
        return this.response.isQueryComplete();
    }

    public boolean next() {
        this.response.readOpenQueryData();
        return this.cursor.next();
    }

    protected Row decodeRow(int len, ByteBuf in) {
        DB2RowImpl row = new DB2RowImpl(this.rowDesc);
        for (int i = 1; i < this.rowDesc.columnDefinitions().columns_ + 1; ++i) {
            int startingIdx = this.cursor.dataBuffer_.readerIndex();
            Object o = this.cursor.getObject(i);
            int endingIdx = this.cursor.dataBuffer_.readerIndex();
            if (startingIdx != endingIdx) {
                System.out.println("WARN: Reader index changed while getting data. Changed from " + startingIdx + " to " + endingIdx + " while obtaining object " + o);
            }
            if (o instanceof BigDecimal) {
                o = Numeric.create((Number)((BigDecimal)o));
            }
            row.addValue(o);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("decoded row values: " + row.deepToString()));
        }
        return row;
    }
}

