/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.db2client.DB2Exception;
import io.vertx.db2client.impl.codec.CommandCodec;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.util.ArrayDeque;
import java.util.List;

class DB2Decoder
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(DB2Decoder.class);
    private final ArrayDeque<CommandCodec<?, ?>> inflight;

    DB2Decoder(ArrayDeque<CommandCodec<?, ?>> inflight) {
        this.inflight = inflight;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int payloadLength = this.computeLength(in);
        if (payloadLength >= 0xFFFFFF) {
            throw new UnsupportedOperationException("split package decoding not implemented");
        }
        if (payloadLength <= 4) {
            throw new IllegalStateException("Illegal payload length: " + payloadLength);
        }
        if (payloadLength > in.readableBytes()) {
            LOG.debug((Object)("Waiting for more bytes to be available. payload=" + payloadLength + " > readable=" + in.readableBytes()));
            return;
        }
        this.decodePayload(in.readRetainedSlice(payloadLength), payloadLength);
    }

    private int computeLength(ByteBuf in) {
        int index;
        int dssLen;
        int ridx = in.readerIndex();
        int readableBytes = in.readableBytes();
        boolean dssContinues = true;
        for (index = 0; dssContinues && index < readableBytes; index += dssLen) {
            dssContinues = readableBytes > index + 3 ? (dssContinues &= (in.getByte(ridx + index + 3) & 0x40) == 64) : false;
            dssLen = 11;
            if (readableBytes < index + 2) continue;
            dssLen = in.getShort(ridx + index);
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodePayload(ByteBuf payload, int payloadLength) {
        CommandCodec<?, ?> ctx = this.inflight.peek();
        int startIndex = payload.readerIndex();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<<< DECODE " + ctx + " (" + payloadLength + " bytes)"));
            }
            ctx.decodePayload(payload, payloadLength);
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                if (!(t instanceof DB2Exception) || t.getMessage() != null && t.getMessage().startsWith("An error occurred with a DB2 operation.")) {
                    int i = payload.readerIndex();
                    payload.readerIndex(startIndex);
                    StringBuilder sb = new StringBuilder("FATAL: Error parsing buffer at index " + i + " / 0x" + Integer.toHexString(i) + "\nFor command " + ctx + "\n");
                    ByteBufUtil.appendPrettyHexDump((StringBuilder)sb, (ByteBuf)payload);
                    LOG.error((Object)sb.toString(), t);
                } else {
                    LOG.error((Object)("Command failed with: " + t.getMessage() + "\nCommand=" + ctx), t);
                }
            }
            ctx.completionHandler.handle((Object)CommandResponse.failure((Throwable)t));
        }
        finally {
            payload.clear();
            payload.release();
        }
    }
}

