/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.netty.buffer.ByteBuf;
import io.vertx.db2client.impl.drda.ClientTypes;
import io.vertx.db2client.impl.drda.ConnectionMetaData;
import io.vertx.db2client.impl.drda.CrossConverters;
import io.vertx.db2client.impl.drda.DB2RowId;
import io.vertx.db2client.impl.drda.DRDAConstants;
import io.vertx.db2client.impl.drda.Decimal;
import io.vertx.db2client.impl.drda.FloatingPoint;
import io.vertx.db2client.impl.drda.NetSqlca;
import io.vertx.db2client.impl.drda.SqlCode;
import io.vertx.db2client.impl.drda.Typdef;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class Cursor {
    public static final int STRING = 0;
    public static final int VARIABLE_STRING = 2;
    public static final int VARIABLE_SHORT_STRING = 1;
    public static final int NULL_TERMINATED_STRING = 3;
    public static final int BYTES = 4;
    public static final int NULL_TERMINATED_BYTES = 7;
    static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public ByteBuf dataBuffer_;
    public int lastValidBytePosition_;
    public boolean hasLobs_;
    protected int currentRowPosition_;
    private int nextRowPosition_;
    protected int[] columnDataPosition_;
    protected int[] columnDataComputedLength_;
    private boolean allRowsReceivedFromServer_;
    long rowsRead_;
    int maxFieldSize_ = 0;
    protected ArrayList<int[]> columnDataPositionCache_ = new ArrayList();
    protected ArrayList<int[]> columnDataLengthCache_ = new ArrayList();
    protected ArrayList<boolean[]> columnDataIsNullCache_ = new ArrayList();
    ArrayList<Boolean> isUpdateDeleteHoleCache_ = new ArrayList();
    boolean isUpdateDeleteHole_;
    private boolean isRowUpdated_;
    static final Boolean ROW_IS_NULL = Boolean.TRUE;
    private static final Boolean ROW_IS_NOT_NULL = Boolean.FALSE;
    public int[] jdbcTypes_;
    public int columns_;
    public boolean[] nullable_;
    public Charset[] charset_;
    public boolean[] isNull_;
    public int[] fdocaLength_;
    public int[] ccsid_;
    private char[] charBuffer_;
    Typdef qrydscTypdef_;
    int maximumRowSize_ = 0;
    boolean blocking_;
    int[] typeToUseForComputingDataLength_;
    boolean[] isGraphic_;
    HashMap<Integer, Integer> extdtaPositions_ = new HashMap();
    ArrayList<byte[]> extdtaData_ = new ArrayList();
    boolean rtnextrow_ = true;
    private boolean qryclsimpEnabled_;
    private final ConnectionMetaData metadata;

    Cursor(ConnectionMetaData metadata) {
        this.metadata = metadata;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.columnDataPosition_ = new int[numberOfColumns];
        this.columnDataComputedLength_ = new int[numberOfColumns];
        this.columns_ = numberOfColumns;
        this.nullable_ = new boolean[numberOfColumns];
        this.charset_ = new Charset[numberOfColumns];
        this.ccsid_ = new int[numberOfColumns];
        this.isNull_ = new boolean[numberOfColumns];
        this.jdbcTypes_ = new int[numberOfColumns];
    }

    protected boolean stepNext(boolean allowServerFetch) {
        this.clearLobData_();
        this.makeNextRowPositionCurrent();
        this.isUpdateDeleteHole_ = false;
        this.isRowUpdated_ = false;
        if (!this.dataBufferHasUnprocessedData()) {
            if (this.allRowsReceivedFromServer_) {
                return false;
            }
            return false;
        }
        boolean rowPositionIsValid = this.calculateColumnOffsetsForRow_(0, allowServerFetch);
        this.markNextRowPosition();
        return rowPositionIsValid;
    }

    public boolean next() {
        return this.stepNext(true);
    }

    public final boolean allRowsReceivedFromServer() {
        return this.allRowsReceivedFromServer_;
    }

    final boolean currentRowPositionIsEqualToNextRowPosition() {
        return this.currentRowPosition_ == this.nextRowPosition_;
    }

    public final void resetDataBuffer() {
        this.dataBuffer_.resetReaderIndex();
        this.lastValidBytePosition_ = 0;
        this.currentRowPosition_ = 0;
        this.nextRowPosition_ = 0;
        this.setAllRowsReceivedFromServer(false);
    }

    final boolean dataBufferHasUnprocessedData() {
        return this.dataBuffer_ != null && this.lastValidBytePosition_ - this.dataBuffer_.readerIndex() > 0;
    }

    public final void setIsUpdataDeleteHole(int row, boolean isRowNull) {
        Boolean nullIndicator;
        this.isUpdateDeleteHole_ = isRowNull;
        Boolean bl = nullIndicator = this.isUpdateDeleteHole_ ? ROW_IS_NULL : ROW_IS_NOT_NULL;
        if (this.isUpdateDeleteHoleCache_.size() == row) {
            this.isUpdateDeleteHoleCache_.add(nullIndicator);
        } else {
            this.isUpdateDeleteHoleCache_.set(row, nullIndicator);
        }
    }

    public final void setIsRowUpdated(boolean isRowUpdated) {
        this.isRowUpdated_ = isRowUpdated;
    }

    public final boolean getIsRowUpdated() {
        return this.isRowUpdated_;
    }

    public final boolean getIsUpdateDeleteHole() {
        return this.isUpdateDeleteHole_;
    }

    protected final void markNextRowPosition() {
        this.nextRowPosition_ = this.dataBuffer_.readerIndex();
    }

    protected final void makeNextRowPositionCurrent() {
        this.currentRowPosition_ = this.nextRowPosition_;
    }

    public final void incrementRowsReadEvent() {
        ++this.rowsRead_;
    }

    private boolean get_BOOLEAN(int column) {
        if (this.metadata.isZos()) {
            return this.dataBuffer_.getShort(this.columnDataPosition_[column - 1]) != 0;
        }
        return this.dataBuffer_.getShortLE(this.columnDataPosition_[column - 1]) != 0;
    }

    private final short get_SMALLINT(int column) {
        if (this.metadata.isZos()) {
            return this.dataBuffer_.getShort(this.columnDataPosition_[column - 1]);
        }
        return this.dataBuffer_.getShortLE(this.columnDataPosition_[column - 1]);
    }

    protected final int get_INTEGER(int column) {
        if (this.metadata.isZos()) {
            return this.dataBuffer_.getInt(this.columnDataPosition_[column - 1]);
        }
        return this.dataBuffer_.getIntLE(this.columnDataPosition_[column - 1]);
    }

    private final long get_BIGINT(int column) {
        if (this.metadata.isZos()) {
            return this.dataBuffer_.getLong(this.columnDataPosition_[column - 1]);
        }
        return this.dataBuffer_.getLongLE(this.columnDataPosition_[column - 1]);
    }

    private final float get_FLOAT(int column) {
        if (this.metadata.isZos()) {
            byte[] bytes = new byte[4];
            this.dataBuffer_.getBytes(this.columnDataPosition_[column - 1], bytes);
            return FloatingPoint.getFloat_hex(bytes, 0);
        }
        return this.dataBuffer_.getFloatLE(this.columnDataPosition_[column - 1]);
    }

    private final double get_DOUBLE(int column) {
        if (this.metadata.isZos()) {
            byte[] bytes = new byte[8];
            this.dataBuffer_.getBytes(this.columnDataPosition_[column - 1], bytes);
            return FloatingPoint.getDouble_hex(bytes, 0);
        }
        return this.dataBuffer_.getDoubleLE(this.columnDataPosition_[column - 1]);
    }

    private final BigDecimal get_DECIMAL(int column) {
        return Decimal.getBigDecimal(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getColumnPrecision(column - 1), this.getColumnScale(column - 1));
    }

    private double getDoubleFromDECIMAL(int column) {
        return Decimal.getDouble(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getColumnPrecision(column - 1), this.getColumnScale(column - 1));
    }

    private long getLongFromDECIMAL(int column, String targetType) {
        try {
            return Decimal.getLong(this.dataBuffer_, this.columnDataPosition_[column - 1], this.getColumnPrecision(column - 1), this.getColumnScale(column - 1));
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new IllegalArgumentException("SQLState.LANG_OUTSIDE_RANGE_FOR_DATATYPE " + targetType, e);
        }
    }

    private String get_VARCHAR(int column) {
        if (this.ccsid_[column - 1] == 1200) {
            return this.getStringWithoutConvert(this.columnDataPosition_[column - 1] + 2, this.columnDataComputedLength_[column - 1] - 2);
        }
        if (this.charset_[column - 1] == null) {
            throw new IllegalStateException("SQLState.CHARACTER_CONVERTER_NOT_AVAILABLE");
        }
        int dataLength = this.columnDataComputedLength_[column - 1] - 2;
        if (this.maxFieldSize_ != 0 && this.maxFieldSize_ < dataLength) {
            dataLength = this.maxFieldSize_;
        }
        return this.dataBuffer_.getCharSequence(this.columnDataPosition_[column - 1] + 2, dataLength, this.charset_[column - 1]).toString();
    }

    private String get_CHAR(int column) {
        if (this.ccsid_[column - 1] == 1200) {
            return this.getStringWithoutConvert(this.columnDataPosition_[column - 1], this.columnDataComputedLength_[column - 1]);
        }
        if (this.charset_[column - 1] == null) {
            throw new IllegalStateException("SQLState.CHARACTER_CONVERTER_NOT_AVAILABLE");
        }
        int dataLength = this.columnDataComputedLength_[column - 1];
        if (this.maxFieldSize_ != 0 && this.maxFieldSize_ < dataLength) {
            dataLength = this.maxFieldSize_;
        }
        return this.dataBuffer_.getCharSequence(this.columnDataPosition_[column - 1], dataLength, this.charset_[column - 1]).toString();
    }

    private LocalDate get_DATE(int column) {
        String dateString = this.dataBuffer_.getCharSequence(this.columnDataPosition_[column - 1], 10, this.charset_[column - 1]).toString();
        return LocalDate.parse(dateString, DRDAConstants.DB2_DATE_FORMAT);
    }

    private LocalTime get_TIME(int column) {
        String timeString = this.dataBuffer_.getCharSequence(this.columnDataPosition_[column - 1], 8, this.charset_[column - 1]).toString();
        return LocalTime.parse(timeString, DRDAConstants.DB2_TIME_FORMAT);
    }

    private final LocalDateTime get_TIMESTAMP(int column) {
        String timeString = this.dataBuffer_.getCharSequence(this.columnDataPosition_[column - 1], 26, this.charset_[column - 1]).toString();
        return LocalDateTime.parse(timeString, DRDAConstants.DB2_TIMESTAMP_FORMAT);
    }

    private byte[] get_CHAR_FOR_BIT_DATA(int column) {
        int columnLength = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[column - 1] : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[column - 1]);
        byte[] bytes = new byte[columnLength];
        this.dataBuffer_.getBytes(this.columnDataPosition_[column - 1], bytes);
        return bytes;
    }

    private byte[] get_VARCHAR_FOR_BIT_DATA(int column) {
        int columnLength = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[column - 1] - 2 : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[column - 1] - 2);
        byte[] bytes = new byte[columnLength];
        this.dataBuffer_.getBytes(this.columnDataPosition_[column - 1] + 2, bytes);
        return bytes;
    }

    private Object get_UDT(int column) {
        int columnLength = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[column - 1] - 2 : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[column - 1] - 2);
        byte[] bytes = new byte[columnLength];
        this.dataBuffer_.getBytes(this.columnDataPosition_[column - 1] + 2, bytes);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException("SQLState.NET_MARSHALLING_UDT_ERROR", e);
        }
    }

    private DB2RowId get_ROWID(int column) {
        int columnLength = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[column - 1] - 2 : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[column - 1] - 2);
        byte[] bytes = new byte[columnLength];
        this.dataBuffer_.getBytes(this.columnDataPosition_[column - 1] + 2, bytes);
        return new DB2RowId(bytes);
    }

    final boolean getBoolean(int column) {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return this.get_BOOLEAN(column);
            }
            case 5: {
                return this.get_SMALLINT(column) != 0;
            }
            case 4: {
                return this.get_INTEGER(column) != 0;
            }
            case -5: {
                return this.get_BIGINT(column) != 0L;
            }
            case 7: {
                return this.get_FLOAT(column) != 0.0f;
            }
            case 8: {
                return this.get_DOUBLE(column) != 0.0;
            }
            case 3: {
                return this.getLongFromDECIMAL(column, "boolean") != 0L;
            }
            case 1: {
                String trimmedChar = this.get_CHAR(column);
                return !trimmedChar.equals("0") && !trimmedChar.equals("false");
            }
            case -1: 
            case 12: {
                String trimmed = this.get_VARCHAR(column);
                return !trimmed.equals("0") && !trimmed.equals("false");
            }
        }
        throw this.coercionError("boolean", column);
    }

    final byte getByte(int column) {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return CrossConverters.getByteFromBoolean(this.get_BOOLEAN(column));
            }
            case 5: {
                short smallInt = this.get_SMALLINT(column);
                if (smallInt > 127 || smallInt < -128) {
                    throw new IllegalArgumentException("Value outside of byte range: " + smallInt);
                }
                return (byte)smallInt;
            }
            case 4: {
                int i = this.get_INTEGER(column);
                if (i > 127 || i < -128) {
                    throw new IllegalArgumentException("Value outside of byte range: " + i);
                }
                return (byte)i;
            }
            case -5: {
                long l = this.get_BIGINT(column);
                if (l > 127L || l < -128L) {
                    throw new IllegalArgumentException("Value outside of byte range: " + l);
                }
                return (byte)l;
            }
            case 7: {
                float f = this.get_FLOAT(column);
                if (f > 127.0f || f < -128.0f) {
                    throw new IllegalArgumentException("Value outside of byte range: " + f);
                }
                return (byte)f;
            }
            case 8: {
                double d = this.get_DOUBLE(column);
                if (d > 127.0 || d < -128.0) {
                    throw new IllegalArgumentException("Value outside of byte range: " + d);
                }
                return (byte)d;
            }
            case 3: {
                long ld = this.getLongFromDECIMAL(column, "byte");
                if (ld > 127L || ld < -128L) {
                    throw new IllegalArgumentException("Value outside of byte range: " + ld);
                }
                return (byte)ld;
            }
            case 1: {
                return CrossConverters.getByteFromString(this.get_CHAR(column));
            }
            case -1: 
            case 12: {
                return CrossConverters.getByteFromString(this.get_VARCHAR(column));
            }
        }
        throw this.coercionError("byte", column);
    }

    public final short getShort(int column) throws SQLException {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return CrossConverters.getShortFromBoolean(this.get_BOOLEAN(column));
            }
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return CrossConverters.getShortFromInt(this.get_INTEGER(column));
            }
            case -5: {
                return CrossConverters.getShortFromLong(this.get_BIGINT(column));
            }
            case 7: {
                return CrossConverters.getShortFromFloat(this.get_FLOAT(column));
            }
            case 8: {
                return CrossConverters.getShortFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return CrossConverters.getShortFromLong(this.getLongFromDECIMAL(column, "short"));
            }
            case 1: {
                return CrossConverters.getShortFromString(this.get_CHAR(column));
            }
            case -1: 
            case 12: {
                return CrossConverters.getShortFromString(this.get_VARCHAR(column));
            }
        }
        throw this.coercionError("short", column);
    }

    public final int getInt(int column) throws SQLException {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return CrossConverters.getIntFromBoolean(this.get_BOOLEAN(column));
            }
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.get_INTEGER(column);
            }
            case -5: {
                return CrossConverters.getIntFromLong(this.get_BIGINT(column));
            }
            case 7: {
                return CrossConverters.getIntFromFloat(this.get_FLOAT(column));
            }
            case 8: {
                return CrossConverters.getIntFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return CrossConverters.getIntFromLong(this.getLongFromDECIMAL(column, "int"));
            }
            case 1: {
                return CrossConverters.getIntFromString(this.get_CHAR(column));
            }
            case -1: 
            case 12: {
                return CrossConverters.getIntFromString(this.get_VARCHAR(column));
            }
        }
        throw this.coercionError("int", column);
    }

    public final long getLong(int column) throws SQLException {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return CrossConverters.getLongFromBoolean(this.get_BOOLEAN(column));
            }
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.get_INTEGER(column);
            }
            case -5: {
                return this.get_BIGINT(column);
            }
            case 7: {
                return CrossConverters.getLongFromFloat(this.get_FLOAT(column));
            }
            case 8: {
                return CrossConverters.getLongFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return this.getLongFromDECIMAL(column, "long");
            }
            case 1: {
                return CrossConverters.getLongFromString(this.get_CHAR(column));
            }
            case -1: 
            case 12: {
                return CrossConverters.getLongFromString(this.get_VARCHAR(column));
            }
        }
        throw this.coercionError("long", column);
    }

    public final float getFloat(int column) throws SQLException {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return CrossConverters.getFloatFromBoolean(this.get_BOOLEAN(column));
            }
            case 7: {
                return this.get_FLOAT(column);
            }
            case 8: {
                return CrossConverters.getFloatFromDouble(this.get_DOUBLE(column));
            }
            case 3: {
                return CrossConverters.getFloatFromDouble(this.getDoubleFromDECIMAL(column));
            }
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.get_INTEGER(column);
            }
            case -5: {
                return this.get_BIGINT(column);
            }
            case 1: {
                return CrossConverters.getFloatFromString(this.get_CHAR(column));
            }
            case -1: 
            case 12: {
                return CrossConverters.getFloatFromString(this.get_VARCHAR(column));
            }
        }
        throw this.coercionError("float", column);
    }

    public final double getDouble(int column) throws SQLException {
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return CrossConverters.getDoubleFromBoolean(this.get_BOOLEAN(column));
            }
            case 7: {
                double d = this.get_FLOAT(column);
                return d;
            }
            case 8: {
                return this.get_DOUBLE(column);
            }
            case 3: {
                return this.getDoubleFromDECIMAL(column);
            }
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.get_INTEGER(column);
            }
            case -5: {
                return this.get_BIGINT(column);
            }
            case 1: {
                return CrossConverters.getDoubleFromString(this.get_CHAR(column));
            }
            case -1: 
            case 12: {
                return CrossConverters.getDoubleFromString(this.get_VARCHAR(column));
            }
        }
        throw this.coercionError("double", column);
    }

    public final BigDecimal getBigDecimal(int column) throws SQLException {
        if (this.isNull(column)) {
            return null;
        }
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return BigDecimal.valueOf(this.getLong(column));
            }
            case 3: {
                return this.get_DECIMAL(column);
            }
            case 7: {
                float f = this.get_FLOAT(column);
                return new BigDecimal(String.valueOf(f));
            }
            case 8: {
                return BigDecimal.valueOf(this.get_DOUBLE(column));
            }
            case 5: {
                return BigDecimal.valueOf(this.get_SMALLINT(column));
            }
            case 4: {
                return BigDecimal.valueOf(this.get_INTEGER(column));
            }
            case -5: {
                return BigDecimal.valueOf(this.get_BIGINT(column));
            }
            case 1: {
                return CrossConverters.getBigDecimalFromString(this.get_CHAR(column));
            }
            case -1: 
            case 12: {
                return CrossConverters.getBigDecimalFromString(this.get_VARCHAR(column));
            }
        }
        throw this.coercionError("java.math.BigDecimal", column);
    }

    public final LocalDate getDate(int column) {
        if (this.isNull(column)) {
            return null;
        }
        switch (this.jdbcTypes_[column - 1]) {
            case 91: {
                return this.get_DATE(column);
            }
            case 93: {
                throw new UnsupportedOperationException();
            }
            case 1: {
                return CrossConverters.getDateFromString(this.get_CHAR(column));
            }
            case -1: 
            case 12: {
                return CrossConverters.getDateFromString(this.get_VARCHAR(column));
            }
        }
        throw this.coercionError("java.time.LocalDate", column);
    }

    public final LocalTime getTime(int column) {
        if (this.isNull(column)) {
            return null;
        }
        switch (this.jdbcTypes_[column - 1]) {
            case 92: {
                return this.get_TIME(column);
            }
            case 93: {
                throw new UnsupportedOperationException();
            }
            case 1: {
                return CrossConverters.getTimeFromString(this.get_CHAR(column));
            }
            case -1: 
            case 12: {
                return CrossConverters.getTimeFromString(this.get_VARCHAR(column));
            }
        }
        throw this.coercionError("java.sql.Time", column);
    }

    public final Timestamp getTimestamp(int column, Calendar cal) {
        if (this.isNull(column)) {
            return null;
        }
        switch (this.jdbcTypes_[column - 1]) {
            case 91: 
            case 92: 
            case 93: {
                throw new UnsupportedOperationException();
            }
            case 1: {
                return CrossConverters.getTimestampFromString(this.get_CHAR(column), cal);
            }
            case -1: 
            case 12: {
                return CrossConverters.getTimestampFromString(this.get_VARCHAR(column), cal);
            }
        }
        throw this.coercionError("java.sql.Timestamp", column);
    }

    public final String getString(int column) {
        if (this.isNull(column)) {
            return null;
        }
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                if (this.get_BOOLEAN(column)) {
                    return Boolean.TRUE.toString();
                }
                return Boolean.FALSE.toString();
            }
            case 1: {
                return this.get_CHAR(column);
            }
            case -1: 
            case 12: {
                return this.get_VARCHAR(column);
            }
            case 5: {
                return String.valueOf(this.get_SMALLINT(column));
            }
            case 4: {
                return String.valueOf(this.get_INTEGER(column));
            }
            case -5: {
                return String.valueOf(this.get_BIGINT(column));
            }
            case 7: {
                return String.valueOf(this.get_FLOAT(column));
            }
            case 8: {
                return String.valueOf(this.get_DOUBLE(column));
            }
            case -4: 
            case -3: 
            case -2: 
            case 3: 
            case 91: 
            case 92: 
            case 93: 
            case 2000: 
            case 2004: 
            case 2005: {
                throw new UnsupportedOperationException();
            }
        }
        throw this.coercionError("String", column);
    }

    public final byte[] getBytes(int column) {
        switch (this.jdbcTypes_[column - 1]) {
            case -2: {
                return this.get_CHAR_FOR_BIT_DATA(column);
            }
            case -4: 
            case -3: {
                return this.get_VARCHAR_FOR_BIT_DATA(column);
            }
            case 2004: {
                throw new UnsupportedOperationException();
            }
        }
        throw this.coercionError("byte[]", column);
    }

    public final DB2RowId getRowID(int column) {
        switch (this.jdbcTypes_[column - 1]) {
            case -8: {
                return this.get_ROWID(column);
            }
        }
        throw this.coercionError("RowId", column);
    }

    final InputStream getBinaryStream(int column) {
        if (this.isNull(column)) {
            return null;
        }
        switch (this.jdbcTypes_[column - 1]) {
            case -2: {
                return new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(column));
            }
            case -4: 
            case -3: {
                return new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(column));
            }
            case 2004: {
                throw new UnsupportedOperationException();
            }
        }
        throw this.coercionError("java.io.InputStream", column);
    }

    final InputStream getAsciiStream(int column) {
        if (this.isNull(column)) {
            return null;
        }
        switch (this.jdbcTypes_[column - 1]) {
            case 2005: {
                throw new UnsupportedOperationException();
            }
            case 1: {
                return new ByteArrayInputStream(this.get_CHAR(column).getBytes(ISO_8859_1));
            }
            case -1: 
            case 12: {
                return new ByteArrayInputStream(this.get_VARCHAR(column).getBytes(ISO_8859_1));
            }
            case -2: {
                return new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(column));
            }
            case -4: 
            case -3: {
                return new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(column));
            }
            case 2004: {
                return this.getBinaryStream(column);
            }
        }
        throw this.coercionError("java.io.InputStream", column);
    }

    final Reader getCharacterStream(int column) throws SQLException {
        switch (this.jdbcTypes_[column - 1]) {
            case 2005: {
                throw new UnsupportedOperationException();
            }
            case 1: {
                return new StringReader(this.get_CHAR(column));
            }
            case -1: 
            case 12: {
                return new StringReader(this.get_VARCHAR(column));
            }
            case -2: {
                return new InputStreamReader((InputStream)new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(column)), UTF_16BE);
            }
            case -4: 
            case -3: {
                return new InputStreamReader((InputStream)new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(column)), UTF_16BE);
            }
            case 2004: {
                return new InputStreamReader(this.getBinaryStream(column), UTF_16BE);
            }
        }
        throw this.coercionError("java.io.Reader", column);
    }

    public final Blob getBlob(int column) {
        if (this.isNull(column)) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public final Clob getClob(int column) {
        if (this.isNull(column)) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    private boolean isNull(int column) {
        return this.nullable_[column - 1] && this.isNull_[column - 1];
    }

    public final Object getObject(int column) {
        if (this.isNull(column)) {
            return null;
        }
        switch (this.jdbcTypes_[column - 1]) {
            case 16: {
                return this.get_BOOLEAN(column);
            }
            case 5: {
                return this.get_SMALLINT(column);
            }
            case 4: {
                return this.get_INTEGER(column);
            }
            case -5: {
                return this.get_BIGINT(column);
            }
            case 7: {
                return Float.valueOf(this.get_FLOAT(column));
            }
            case 8: {
                return this.get_DOUBLE(column);
            }
            case 3: {
                return this.get_DECIMAL(column);
            }
            case 91: {
                return this.get_DATE(column);
            }
            case 92: {
                return this.get_TIME(column);
            }
            case 93: {
                return this.get_TIMESTAMP(column);
            }
            case 1: {
                return this.get_CHAR(column);
            }
            case -1: 
            case 12: {
                return this.get_VARCHAR(column);
            }
            case -2: {
                return this.get_CHAR_FOR_BIT_DATA(column);
            }
            case -4: 
            case -3: {
                return this.get_VARCHAR_FOR_BIT_DATA(column);
            }
            case 2000: {
                return this.get_UDT(column);
            }
            case -8: {
                return this.get_ROWID(column);
            }
        }
        throw this.coercionError("Object type: ", column);
    }

    public final void allocateCharBuffer() {
        int maxCharLength = 0;
        block3: for (int i = 0; i < this.columns_; ++i) {
            switch (this.jdbcTypes_[i]) {
                case -1: 
                case 1: 
                case 12: {
                    if (this.fdocaLength_[i] <= maxCharLength) continue block3;
                    maxCharLength = this.fdocaLength_[i];
                }
            }
        }
        this.charBuffer_ = new char[maxCharLength];
    }

    private String getStringWithoutConvert(int position, int actualLength) {
        int end = position + actualLength;
        int charCount = 0;
        for (int start = position; start < end; start += 2) {
            this.charBuffer_[charCount++] = this.dataBuffer_.getChar(start);
        }
        return new String(this.charBuffer_, 0, charCount);
    }

    private IllegalStateException coercionError(String targetType, int sourceColumn) {
        return new IllegalStateException("Unknown target type for " + targetType + ClientTypes.getTypeString(this.jdbcTypes_[sourceColumn - 1]) + " value=" + this.jdbcTypes_[sourceColumn - 1]);
    }

    private int getColumnPrecision(int column) {
        return this.fdocaLength_[column] >> 8 & 0xFF;
    }

    private int getColumnScale(int column) {
        return this.fdocaLength_[column] & 0xFF;
    }

    protected boolean calculateColumnOffsetsForRow_(int rowIndex, boolean allowServerFetch) {
        int daNullIndicator = 255;
        int colNullIndicator = 255;
        int[] columnDataPosition = null;
        int[] columnDataComputedLength = null;
        boolean[] columnDataIsNull = null;
        boolean receivedDeleteHoleWarning = false;
        boolean receivedRowUpdatedWarning = false;
        if (this.hasLobs_) {
            this.extdtaPositions_.clear();
        }
        NetSqlca[] netSqlca = this.parseSQLCARD(this.qrydscTypdef_);
        daNullIndicator = this.readFdocaOneByte();
        if (netSqlca != null) {
            for (int i = 0; i < netSqlca.length; ++i) {
                String sqlState;
                int sqlcode = netSqlca[i].getSqlCode();
                if (sqlcode < 0) {
                    throw new IllegalStateException(netSqlca[i].toString());
                }
                if (sqlcode == SqlCode.END_OF_DATA.getCode()) {
                    this.setAllRowsReceivedFromServer(true);
                    if (!netSqlca[i].containsSqlcax()) continue;
                    throw new UnsupportedOperationException();
                }
                if (sqlcode <= 0 || !(sqlState = netSqlca[i].getSqlState()).equals("02502") && !sqlState.equals("rwupd")) continue;
                receivedDeleteHoleWarning |= sqlState.equals("02502");
                receivedRowUpdatedWarning |= sqlState.equals("rwupd");
            }
        }
        this.setIsUpdataDeleteHole(rowIndex, receivedDeleteHoleWarning);
        this.setIsRowUpdated(receivedRowUpdatedWarning);
        if (this.allRowsReceivedFromServer() && this.dataBuffer_.readerIndex() == this.lastValidBytePosition_) {
            this.markNextRowPosition();
            this.makeNextRowPositionCurrent();
            return false;
        }
        if (daNullIndicator == 0) {
            this.incrementRowsReadEvent();
            if (this.columnDataPosition_ == null || this.columnDataComputedLength_ == null || this.isNull_ == null) {
                this.allocateColumnOffsetAndLengthArrays();
            }
            columnDataPosition = this.columnDataPosition_;
            columnDataComputedLength = this.columnDataComputedLength_;
            columnDataIsNull = this.isNull_;
            for (int index = 0; index < this.columns_; ++index) {
                if (this.nullable_[index]) {
                    colNullIndicator = this.readFdocaOneByte(index);
                }
                if (!this.nullable_[index] || colNullIndicator >= 0 && colNullIndicator <= 127) {
                    columnDataIsNull[index] = false;
                    switch (this.typeToUseForComputingDataLength_[index]) {
                        case 0: {
                            columnDataPosition[index] = this.dataBuffer_.readerIndex();
                            if (this.isGraphic_[index]) {
                                columnDataComputedLength[index] = this.skipFdocaBytes(this.fdocaLength_[index] * 2, index);
                                break;
                            }
                            columnDataComputedLength[index] = this.skipFdocaBytes(this.fdocaLength_[index], index);
                            break;
                        }
                        case 1: {
                            columnDataPosition[index] = this.dataBuffer_.readerIndex();
                            int length = this.readFdocaTwoByteLength(index);
                            if (this.isGraphic_[index]) {
                                columnDataComputedLength[index] = this.skipFdocaBytes(length * 2, index) + 2;
                                break;
                            }
                            columnDataComputedLength[index] = this.skipFdocaBytes(length, index) + 2;
                            break;
                        }
                        case 3: {
                            columnDataPosition[index] = this.dataBuffer_.readerIndex();
                            columnDataComputedLength[index] = this.skipFdocaBytes(this.getDecimalLength(index), index);
                            break;
                        }
                        case 4: {
                            columnDataPosition[index] = this.dataBuffer_.readerIndex();
                            columnDataComputedLength[index] = this.skipFdocaBytes(this.fdocaLength_[index] & Short.MAX_VALUE, index);
                            break;
                        }
                        case 2: {
                            columnDataPosition[index] = this.dataBuffer_.readerIndex();
                            int length = this.readFdocaOneByte(index);
                            if (this.isGraphic_[index]) {
                                columnDataComputedLength[index] = this.skipFdocaBytes(length * 2, index) + 1;
                                break;
                            }
                            columnDataComputedLength[index] = this.skipFdocaBytes(length, index) + 1;
                            break;
                        }
                        default: {
                            columnDataPosition[index] = this.dataBuffer_.readerIndex();
                            if (this.isGraphic_[index]) {
                                columnDataComputedLength[index] = this.skipFdocaBytes(this.fdocaLength_[index] * 2, index);
                                break;
                            }
                            columnDataComputedLength[index] = this.skipFdocaBytes(this.fdocaLength_[index], index);
                            break;
                        }
                    }
                    continue;
                }
                if ((colNullIndicator & 0x80) != 128) continue;
                columnDataIsNull[index] = true;
            }
            this.columnDataPosition_ = columnDataPosition;
            this.columnDataComputedLength_ = columnDataComputedLength;
            this.isNull_ = columnDataIsNull;
            if (!this.allRowsReceivedFromServer()) {
                this.calculateLobColumnPositionsForRow();
                if (this.blocking_ && this.rtnextrow_ && !this.extdtaPositions_.isEmpty()) {
                    if (allowServerFetch) {
                        throw new UnsupportedOperationException();
                    }
                    return false;
                }
            }
        }
        return this.blocking_ || !this.allRowsReceivedFromServer() || daNullIndicator != 255;
    }

    void scanDataBufferForEndOfData() {
        while (!this.allRowsReceivedFromServer() && this.dataBuffer_.readerIndex() != this.lastValidBytePosition_) {
            this.stepNext(false);
        }
    }

    private int readFdocaInt() {
        this.checkForSplitRowAndComplete(4);
        if (this.metadata.isZos()) {
            return this.dataBuffer_.readInt();
        }
        return this.dataBuffer_.readIntLE();
    }

    private int readFdocaOneByte() {
        this.checkForSplitRowAndComplete(1);
        return this.dataBuffer_.readUnsignedByte();
    }

    private int readFdocaOneByte(int index) {
        this.checkForSplitRowAndComplete(1, index);
        return this.dataBuffer_.readByte();
    }

    private byte[] readFdocaBytes(int length) {
        this.checkForSplitRowAndComplete(length);
        byte[] b = new byte[length];
        this.dataBuffer_.readBytes(b);
        return b;
    }

    private int readFdocaTwoByteLength() {
        this.checkForSplitRowAndComplete(2);
        return this.dataBuffer_.readShort();
    }

    private int readFdocaTwoByteLength(int index) {
        this.checkForSplitRowAndComplete(2, index);
        return this.dataBuffer_.readShort();
    }

    private int skipFdocaBytes(int length) {
        this.checkForSplitRowAndComplete(length);
        this.dataBuffer_.skipBytes(length);
        return length;
    }

    private int skipFdocaBytes(int length, int index) {
        this.checkForSplitRowAndComplete(length, index);
        this.dataBuffer_.skipBytes(length);
        return length;
    }

    private void shiftPartialRowToBeginning() {
        throw new UnsupportedOperationException("Need to step through this method");
    }

    private void adjustColumnOffsetsForColumnsPreviouslyCalculated(int index) {
        int j = 0;
        while (j <= index) {
            int n = j++;
            this.columnDataPosition_[n] = this.columnDataPosition_[n] - this.currentRowPosition_;
        }
    }

    private void resetCurrentRowPosition() {
        this.currentRowPosition_ = 0;
    }

    void calculateLobColumnPositionsForRow() {
        int currentPosition = 0;
        for (int i = 0; i < this.columns_; ++i) {
            if (!this.isNonTrivialDataLob(i) || this.locator(i + 1) != -1) continue;
            this.extdtaPositions_.put(i + 1, currentPosition++);
        }
    }

    private boolean isNonTrivialDataLob(int index) {
        long length = 0L;
        if (this.isNull_[index] || this.jdbcTypes_[index] != 2004 && this.jdbcTypes_[index] != 2005) {
            return false;
        }
        int position = this.columnDataPosition_[index];
        if ((this.dataBuffer_.getByte(this.dataBuffer_.readerIndex()) & 0x80) == 128) {
            length = -1L;
        } else {
            byte[] lengthBytes = new byte[this.columnDataComputedLength_[index]];
            byte[] longBytes = new byte[8];
            this.dataBuffer_.getBytes(position, lengthBytes, 0, this.columnDataComputedLength_[index]);
            int j = 0;
            for (int i = 8 - this.columnDataComputedLength_[index]; i < 8; ++i) {
                longBytes[i] = lengthBytes[j];
                ++j;
            }
            length = Cursor.getLong(longBytes, 0);
        }
        return length != 0L;
    }

    private static final long getLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + (((long)buffer[offset + 7] & 0xFFL) << 0);
    }

    protected void clearLobData_() {
        this.extdtaData_.clear();
        this.extdtaPositions_.clear();
    }

    private NetSqlca[] parseSQLCARD(Typdef typdef) {
        return this.parseSQLCAGRP(typdef);
    }

    private NetSqlca[] parseSQLCAGRP(Typdef typdef) {
        NetSqlca[] ret_val;
        if (this.readFdocaOneByte() == 255) {
            return null;
        }
        int sqlcode = this.readFdocaInt();
        byte[] sqlstate = this.readFdocaBytes(5);
        byte[] sqlerrproc = this.readFdocaBytes(8);
        NetSqlca netSqlca = new NetSqlca(sqlcode, sqlstate, sqlerrproc);
        this.parseSQLCAXGRP(typdef, netSqlca);
        NetSqlca[] sqlCa = this.parseSQLDIAGGRP();
        if (sqlCa != null) {
            ret_val = new NetSqlca[sqlCa.length + 1];
            System.arraycopy(sqlCa, 0, ret_val, 1, sqlCa.length);
        } else {
            ret_val = new NetSqlca[]{netSqlca};
        }
        return ret_val;
    }

    private void parseSQLCAXGRP(Typdef typdef, NetSqlca netSqlca) {
        if (this.readFdocaOneByte() == 255) {
            netSqlca.setContainsSqlcax(false);
            return;
        }
        int[] sqlerrd = new int[6];
        for (int i = 0; i < sqlerrd.length; ++i) {
            sqlerrd[i] = this.readFdocaInt();
        }
        byte[] sqlwarn = this.readFdocaBytes(11);
        this.parseVCS(typdef);
        int varcharLength = this.readFdocaTwoByteLength();
        byte[] sqlerrmc = null;
        int sqlerrmcCcsid = 0;
        if (varcharLength != 0) {
            sqlerrmc = this.readFdocaBytes(varcharLength);
            sqlerrmcCcsid = typdef.getCcsidMbc();
            this.skipFdocaBytes(2);
        } else {
            varcharLength = this.readFdocaTwoByteLength();
            sqlerrmc = this.readFdocaBytes(varcharLength);
            sqlerrmcCcsid = typdef.getCcsidSbc();
        }
        netSqlca.setSqlerrd(sqlerrd);
        netSqlca.setSqlwarnBytes(sqlwarn);
        netSqlca.setSqlerrmcBytes(sqlerrmc);
    }

    private NetSqlca[] parseSQLDIAGGRP() {
        if (this.readFdocaOneByte() == 255) {
            return null;
        }
        this.parseSQLDIAGSTT();
        NetSqlca[] sqlca = this.parseSQLDIAGCI();
        this.parseSQLDIAGCN();
        return sqlca;
    }

    private void parseSQLDIAGSTT() {
        if (this.readFdocaOneByte() == 255) {
            return;
        }
        throw new IllegalStateException("SQLState.DRDA_COMMAND_NOT_IMPLEMENTED parseSQLDIAGSTT");
    }

    private NetSqlca[] parseSQLDIAGCI() {
        int num = this.readFdocaTwoByteLength();
        NetSqlca[] ret_val = null;
        if (num != 0) {
            ret_val = new NetSqlca[num];
        }
        for (int i = 0; i < num; ++i) {
            ret_val[i] = this.parseSQLDCROW();
        }
        return ret_val;
    }

    private void parseSQLDIAGCN() {
        if (this.readFdocaOneByte() == 255) {
            return;
        }
        throw new UnsupportedOperationException("SQLState.DRDA_COMMAND_NOT_IMPLEMENTED parseSQLDIAGCN");
    }

    private NetSqlca parseSQLDCGRP() {
        int sqldcCode = this.readFdocaInt();
        String sqldcState = this.readFdocaString(5, Typdef.targetTypdef.getCcsidSbcEncoding());
        int sqldcReason = this.readFdocaInt();
        this.skipFdocaBytes(12);
        NetSqlca sqlca = new NetSqlca(sqldcCode, sqldcState, (byte[])null);
        this.skipFdocaBytes(49);
        this.parseSQLDCTOKS();
        String sqldcMsg = this.parseVCS(this.qrydscTypdef_);
        if (sqldcMsg != null) {
            sqlca.setSqlerrmcBytes(sqldcMsg.getBytes());
        }
        this.skipFdocaBytes(12);
        this.parseSQLDCXGRP();
        return sqlca;
    }

    private NetSqlca parseSQLDCROW() {
        return this.parseSQLDCGRP();
    }

    private void parseSQLDCTOKS() {
        if (this.readFdocaOneByte() == 255) {
            return;
        }
        throw new UnsupportedOperationException("SQLState.DRDA_COMMAND_NOT_IMPLEMENTED parseSQLDCTOKS");
    }

    private void parseSQLDCXGRP() {
        if (this.readFdocaOneByte() == 255) {
            return;
        }
        throw new UnsupportedOperationException("SQLState.DRDA_COMMAND_NOT_IMPLEMENTED parseSQLDCXGRP");
    }

    private String parseVCS(Typdef typdefInEffect) {
        return this.readFdocaString(this.readFdocaTwoByteLength(), typdefInEffect.getCcsidSbcEncoding());
    }

    private String readFdocaString(int length, Charset encoding) {
        if (length == 0) {
            return null;
        }
        this.checkForSplitRowAndComplete(length);
        return this.dataBuffer_.readCharSequence(length, encoding).toString();
    }

    void allocateColumnOffsetAndLengthArrays() {
        this.columnDataPosition_ = new int[this.columns_];
        this.columnDataComputedLength_ = new int[this.columns_];
        this.isNull_ = new boolean[this.columns_];
    }

    private byte[] findExtdtaData(int column) {
        byte[] data = null;
        Integer extdtaQueuePosition = this.extdtaPositions_.get(column);
        if (extdtaQueuePosition != null) {
            data = this.extdtaData_.get(extdtaQueuePosition);
        }
        return data;
    }

    protected int locator(int column) {
        int locator = this.get_INTEGER(column);
        if (locator == 32768 || locator == 32770 || locator == 32772 || locator == 32774 || locator == 32776 || locator == 0) {
            return -1;
        }
        return locator;
    }

    void initializeColumnInfoArrays(Typdef typdef, int columnCount) {
        this.qrydscTypdef_ = typdef;
        this.setNumberOfColumns(columnCount);
        this.fdocaLength_ = new int[columnCount];
        this.isGraphic_ = new boolean[columnCount];
        this.typeToUseForComputingDataLength_ = new int[columnCount];
    }

    protected void getMoreData_() {
        this.resetDataBuffer();
        throw new UnsupportedOperationException("flowFetch");
    }

    public void nullDataForGC() {
        this.dataBuffer_ = null;
        this.columnDataPosition_ = null;
        this.qrydscTypdef_ = null;
        this.columnDataComputedLength_ = null;
        this.columnDataPositionCache_ = null;
        this.columnDataLengthCache_ = null;
        this.columnDataIsNullCache_ = null;
        this.jdbcTypes_ = null;
        this.nullable_ = null;
        this.charset_ = null;
        this.ccsid_ = null;
        this.isUpdateDeleteHoleCache_ = null;
        this.isNull_ = null;
        this.fdocaLength_ = null;
        this.charBuffer_ = null;
        this.typeToUseForComputingDataLength_ = null;
        this.isGraphic_ = null;
        if (this.extdtaPositions_ != null) {
            this.extdtaPositions_.clear();
        }
        this.extdtaPositions_ = null;
        if (this.extdtaData_ != null) {
            this.extdtaData_.clear();
        }
        this.extdtaData_ = null;
    }

    private void checkForSplitRowAndComplete(int length, int index) {
        while (this.dataBuffer_.readableBytes() > this.lastValidBytePosition_) {
            this.checkAndThrowReceivedEndqryrm();
            int lastValidByteBeforeFetch = this.completeSplitRow(index);
            this.checkAndThrowReceivedEndqryrm(lastValidByteBeforeFetch);
        }
    }

    private void checkForSplitRowAndComplete(int length) {
        this.checkForSplitRowAndComplete(length, -1);
    }

    private void checkAndThrowReceivedEndqryrm() {
        throw new IllegalStateException("SQLState.NET_QUERY_PROCESSING_TERMINATED");
    }

    private void checkAndThrowReceivedEndqryrm(int lastValidBytePositionBeforeFetch) {
        if (this.lastValidBytePosition_ > lastValidBytePositionBeforeFetch) {
            return;
        }
        this.checkAndThrowReceivedEndqryrm();
    }

    private int completeSplitRow(int index) {
        int lastValidBytePositionBeforeFetch = 0;
        this.shiftPartialRowToBeginning();
        this.adjustColumnOffsetsForColumnsPreviouslyCalculated(index);
        this.resetCurrentRowPosition();
        lastValidBytePositionBeforeFetch = this.lastValidBytePosition_;
        throw new UnsupportedOperationException();
    }

    private int[] allocateColumnDataPositionArray(int row) {
        int[] columnDataPosition;
        if (this.columnDataPositionCache_.size() == row) {
            columnDataPosition = new int[this.columns_];
            this.columnDataPositionCache_.add(columnDataPosition);
        } else {
            columnDataPosition = this.columnDataPositionCache_.get(row);
        }
        return columnDataPosition;
    }

    private int[] allocateColumnDataComputedLengthArray(int row) {
        int[] columnDataComputedLength;
        if (this.columnDataLengthCache_.size() == row) {
            columnDataComputedLength = new int[this.columns_];
            this.columnDataLengthCache_.add(columnDataComputedLength);
        } else {
            columnDataComputedLength = this.columnDataLengthCache_.get(row);
        }
        return columnDataComputedLength;
    }

    private boolean[] allocateColumnDataIsNullArray(int row) {
        boolean[] columnDataIsNull;
        if (this.columnDataIsNullCache_.size() <= row) {
            columnDataIsNull = new boolean[this.columns_];
            this.columnDataIsNullCache_.add(columnDataIsNull);
        } else {
            columnDataIsNull = this.columnDataIsNullCache_.get(row);
        }
        return columnDataIsNull;
    }

    protected int getDecimalLength(int index) {
        return ((this.fdocaLength_[index] >> 8 & 0xFF) + 2) / 2;
    }

    public final void setAllRowsReceivedFromServer(boolean b) {
        if (!b || this.qryclsimpEnabled_) {
            // empty if block
        }
        this.allRowsReceivedFromServer_ = b;
    }

    final void setQryclsimpEnabled(boolean flag) {
        this.qryclsimpEnabled_ = flag;
    }

    final boolean getQryclsimpEnabled() {
        return this.qryclsimpEnabled_;
    }

    protected boolean calculateColumnOffsetsForRow() {
        int colNullIndicator = 255;
        this.extdtaPositions_.clear();
        if (this.readFdocaOneByte() == 255) {
            return false;
        }
        this.incrementRowsReadEvent();
        if (this.columnDataPosition_ == null || this.columnDataComputedLength_ == null || this.isNull_ == null) {
            this.allocateColumnOffsetAndLengthArrays();
        }
        for (int index = 0; index < this.columns_; ++index) {
            if (this.nullable_[index]) {
                colNullIndicator = this.readFdocaOneByte();
            }
            if (!this.nullable_[index] || colNullIndicator >= 0 && colNullIndicator <= 127) {
                this.isNull_[index] = false;
                switch (this.typeToUseForComputingDataLength_[index]) {
                    case 1: {
                        this.columnDataPosition_[index] = this.dataBuffer_.readerIndex();
                        int length = this.readFdocaTwoByteLength();
                        if (this.isGraphic_[index]) {
                            this.columnDataComputedLength_[index] = this.skipFdocaBytes(length * 2) + 2;
                            break;
                        }
                        this.columnDataComputedLength_[index] = this.skipFdocaBytes(length) + 2;
                        break;
                    }
                    case 2: {
                        this.columnDataPosition_[index] = this.dataBuffer_.readerIndex();
                        int length = this.readFdocaOneByte();
                        if (this.isGraphic_[index]) {
                            this.columnDataComputedLength_[index] = this.skipFdocaBytes(length * 2) + 1;
                            break;
                        }
                        this.columnDataComputedLength_[index] = this.skipFdocaBytes(length) + 1;
                        break;
                    }
                    case 3: {
                        this.columnDataPosition_[index] = this.dataBuffer_.readerIndex();
                        this.columnDataComputedLength_[index] = this.skipFdocaBytes(this.getDecimalLength(index));
                        break;
                    }
                    case 4: {
                        this.columnDataPosition_[index] = this.dataBuffer_.readerIndex();
                        this.columnDataComputedLength_[index] = this.skipFdocaBytes(this.fdocaLength_[index] & Short.MAX_VALUE);
                        break;
                    }
                    default: {
                        this.columnDataPosition_[index] = this.dataBuffer_.readerIndex();
                        if (this.isGraphic_[index]) {
                            this.columnDataComputedLength_[index] = this.skipFdocaBytes(this.fdocaLength_[index] * 2);
                            break;
                        }
                        this.columnDataComputedLength_[index] = this.skipFdocaBytes(this.fdocaLength_[index]);
                        break;
                    }
                }
                continue;
            }
            if ((colNullIndicator & 0x80) != 128) continue;
            this.isNull_[index] = true;
        }
        if (!this.allRowsReceivedFromServer()) {
            this.calculateLobColumnPositionsForRow();
        }
        return true;
    }
}

