/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.impl.DB2ConnectionImpl;
import io.vertx.db2client.impl.DB2SocketConnection;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactoryBase;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class DB2ConnectionFactory
extends ConnectionFactoryBase {
    public DB2ConnectionFactory(VertxInternal vertx, Supplier<? extends Future<? extends SqlConnectOptions>> options) {
        super(vertx, options);
    }

    protected Future<Connection> doConnectInternal(SqlConnectOptions options, ContextInternal context) {
        DB2ConnectOptions db2Options = DB2ConnectOptions.wrap(options);
        SocketAddress server = options.getSocketAddress();
        boolean cachePreparedStatements = options.getCachePreparedStatements();
        int preparedStatementCacheSize = options.getPreparedStatementCacheMaxSize();
        Predicate preparedStatementCacheSqlFilter = options.getPreparedStatementCacheSqlFilter();
        String username = options.getUser();
        String password = options.getPassword();
        String database = options.getDatabase();
        Map properties = options.getProperties();
        int pipeliningLimit = db2Options.getPipeliningLimit();
        NetClient netClient = this.netClient((NetClientOptions)options);
        return netClient.connect(server).flatMap(so -> {
            VertxMetrics vertxMetrics = this.vertx.metricsSPI();
            ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(db2Options.getSocketAddress(), "sql", db2Options.getMetricsName()) : null;
            DB2SocketConnection conn = new DB2SocketConnection((NetSocketInternal)so, metrics, db2Options, cachePreparedStatements, preparedStatementCacheSize, preparedStatementCacheSqlFilter, pipeliningLimit, context);
            conn.init();
            return Future.future(p -> conn.sendStartupMessage(username, password, database, properties, (Promise<Connection>)p));
        });
    }

    public Future<SqlConnection> connect(Context context, SqlConnectOptions options) {
        ContextInternal contextInternal = (ContextInternal)context;
        PromiseInternal promise = contextInternal.promise();
        this.connect(DB2ConnectionFactory.asEventLoopContext((ContextInternal)contextInternal), options).map(conn -> {
            DB2ConnectionImpl db2Connection = new DB2ConnectionImpl(contextInternal, (ConnectionFactory)this, (Connection)conn);
            conn.init((Connection.Holder)db2Connection);
            return db2Connection;
        }).onComplete((Handler)promise);
        return promise.future();
    }
}

