/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.db2client.impl.codec.DB2RowDesc;
import io.vertx.db2client.impl.codec.QueryCommandBaseCodec;
import io.vertx.db2client.impl.codec.RowResultDecoder;
import io.vertx.db2client.impl.drda.DRDAQueryRequest;
import io.vertx.db2client.impl.drda.DRDAQueryResponse;
import io.vertx.db2client.impl.drda.Section;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import java.util.stream.Collector;

class SimpleQueryCommandCodec<T>
extends QueryCommandBaseCodec<T, SimpleQueryCommand<T>> {
    private Section querySection;

    SimpleQueryCommandCodec(SimpleQueryCommand<T> cmd) {
        super(cmd);
    }

    @Override
    void encodeQuery(DRDAQueryRequest queryCommand) {
        this.querySection = this.encoder.socketConnection.connMetadata.sectionManager.getSection(((SimpleQueryCommand)this.cmd).sql());
        queryCommand.writePrepareDescribeOutput(((SimpleQueryCommand)this.cmd).sql(), this.encoder.socketConnection.connMetadata.databaseName, this.querySection);
        queryCommand.writeOpenQuery(this.querySection, this.encoder.socketConnection.connMetadata.databaseName, 0, 1003);
    }

    @Override
    void encodeUpdate(DRDAQueryRequest updateCommand) {
        this.querySection = this.encoder.socketConnection.connMetadata.sectionManager.getSection(((SimpleQueryCommand)this.cmd).sql());
        updateCommand.writeExecuteImmediate(((SimpleQueryCommand)this.cmd).sql(), this.querySection, this.encoder.socketConnection.connMetadata.databaseName);
        if (((SimpleQueryCommand)this.cmd).autoCommit()) {
            updateCommand.buildRDBCMM();
        }
    }

    @Override
    void decodeUpdate(ByteBuf payload) {
        DRDAQueryResponse updateResponse = new DRDAQueryResponse(payload, this.encoder.socketConnection.connMetadata);
        this.querySection.release();
        int updatedCount = (int)updateResponse.readExecuteImmediate();
        T result = SimpleQueryCommandCodec.emptyResult(((SimpleQueryCommand)this.cmd).collector());
        ((SimpleQueryCommand)this.cmd).resultHandler().handleResult(updatedCount, 0, null, result, null);
        if (((SimpleQueryCommand)this.cmd).autoCommit()) {
            updateResponse.readLocalCommit();
        }
        this.completionHandler.handle((Object)CommandResponse.success((Object)true));
    }

    static <A, T> T emptyResult(Collector<Row, A, T> collector) {
        return collector.finisher().apply(collector.supplier().get());
    }

    @Override
    void decodeQuery(ByteBuf payload) {
        this.querySection.release();
        DRDAQueryResponse resp = new DRDAQueryResponse(payload, this.encoder.socketConnection.connMetadata);
        resp.readPrepareDescribeOutput();
        resp.readBeginOpenQuery();
        this.columnDefinitions = resp.getOutputColumnMetaData();
        RowResultDecoder decoder = new RowResultDecoder(((SimpleQueryCommand)this.cmd).collector(), DB2RowDesc.create(this.columnDefinitions), resp.getCursor(), resp);
        while (decoder.next()) {
            decoder.handleRow(this.columnDefinitions.columns_, payload);
        }
        if (!decoder.isQueryComplete()) {
            throw new UnsupportedOperationException("Need to fetch more data from DB");
        }
        decoder.cursor.setAllRowsReceivedFromServer(true);
        this.handleQueryResult(decoder);
        this.completionHandler.handle((Object)CommandResponse.success((Object)true));
    }

    @Override
    public String toString() {
        return super.toString() + ", section=" + this.querySection;
    }
}

