/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.base64.Base64;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.server.GrpcProtocol;
import io.vertx.grpc.server.impl.GrpcServerRequestImpl;
import io.vertx.grpc.server.impl.GrpcServerResponseImpl;
import java.util.Map;

public class WebGrpcServerResponse<Req, Resp>
extends GrpcServerResponseImpl<Req, Resp> {
    private final GrpcProtocol protocol;
    private final HttpServerResponse httpResponse;

    public WebGrpcServerResponse(ContextInternal context, GrpcServerRequestImpl<Req, Resp> request, GrpcProtocol protocol, HttpServerResponse httpResponse, GrpcMessageEncoder<Resp> encoder) {
        super(context, request, protocol, httpResponse, encoder);
        this.protocol = protocol;
        this.httpResponse = httpResponse;
    }

    @Override
    protected Buffer encodeMessage(Buffer message, boolean compressed, boolean trailer) {
        message = super.encodeMessage(message, compressed, trailer);
        if (this.protocol == GrpcProtocol.WEB_TEXT) {
            message = BufferInternal.buffer((ByteBuf)Base64.encode((ByteBuf)((BufferInternal)message).getByteBuf(), (boolean)false));
        }
        return message;
    }

    @Override
    protected void setHeaders(String contentType, MultiMap grpcHeaders, boolean isEnd) {
        super.setHeaders(contentType, grpcHeaders, isEnd);
        this.httpResponse.setChunked(!this.isTrailersOnly());
    }

    @Override
    protected void setTrailers(MultiMap grpcTrailers) {
        if (this.isTrailersOnly()) {
            this.encodeGrpcTrailers(grpcTrailers, this.httpResponse.headers());
        } else {
            MultiMap httpTrailers = HttpHeaders.headers();
            this.encodeGrpcTrailers(grpcTrailers, httpTrailers);
            Buffer buffer = Buffer.buffer();
            for (Map.Entry trailer : httpTrailers) {
                buffer.appendString((String)trailer.getKey()).appendByte((byte)58).appendString((String)trailer.getValue()).appendString("\r\n");
            }
            this.httpResponse.write((Object)this.encodeMessage(buffer, false, true));
        }
    }
}

