/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.server.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.http.HttpServerRequestInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.spi.context.storage.AccessMode;
import io.vertx.grpc.common.GrpcLocal;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.MessageSizeOverflowException;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.WireFormat;
import io.vertx.grpc.common.impl.GrpcMethodCall;
import io.vertx.grpc.server.GrpcProtocol;
import io.vertx.grpc.server.GrpcServer;
import io.vertx.grpc.server.GrpcServerOptions;
import io.vertx.grpc.server.GrpcServerRequest;
import io.vertx.grpc.server.Service;
import io.vertx.grpc.server.impl.GrpcHttpInvoker;
import io.vertx.grpc.server.impl.GrpcInvocation;
import io.vertx.grpc.server.impl.GrpcServerRequestImpl;
import io.vertx.grpc.server.impl.GrpcServerResponseImpl;
import io.vertx.grpc.server.impl.Http2GrpcServerRequest;
import io.vertx.grpc.server.impl.Http2GrpcServerResponse;
import io.vertx.grpc.server.impl.MountPoint;
import io.vertx.grpc.server.impl.WebGrpcServerRequest;
import io.vertx.grpc.server.impl.WebGrpcServerResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class GrpcServerImpl
implements GrpcServer {
    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("application/grpc(-web(-text)?)?(\\+(json|proto))?");
    private static final Logger log = LoggerFactory.getLogger(GrpcServer.class);
    private final GrpcServerOptions options;
    private Handler<GrpcServerRequest<Buffer, Buffer>> requestHandler;
    private final List<Service> services = new ArrayList<Service>();
    private final Map<String, List<MethodCallHandler<?, ?>>> methodCallHandlers = new HashMap();
    private final List<GrpcHttpInvoker> invokers;

    public GrpcServerImpl(Vertx vertx, GrpcServerOptions options) {
        ServiceLoader<GrpcHttpInvoker> loader = ServiceLoader.load(GrpcHttpInvoker.class);
        this.invokers = loader.stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
        this.options = new GrpcServerOptions(Objects.requireNonNull(options, "options is null"));
    }

    private Details determine(String contentType) {
        if (contentType != null) {
            Matcher matcher = CONTENT_TYPE_PATTERN.matcher(contentType);
            if (matcher.matches()) {
                WireFormat format;
                GrpcProtocol protocol = matcher.group(1) != null ? (matcher.group(2) == null ? GrpcProtocol.WEB : GrpcProtocol.WEB_TEXT) : GrpcProtocol.HTTP_2;
                if (matcher.group(3) != null) {
                    switch (matcher.group(4)) {
                        case "proto": {
                            format = WireFormat.PROTOBUF;
                            break;
                        }
                        case "json": {
                            format = WireFormat.JSON;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Not possible");
                        }
                    }
                } else {
                    format = WireFormat.PROTOBUF;
                }
                return new Details(protocol, format);
            }
            if (GrpcProtocol.TRANSCODING.mediaType().equals(contentType)) {
                GrpcProtocol protocol = GrpcProtocol.TRANSCODING;
                WireFormat format = WireFormat.JSON;
                return new Details(protocol, format);
            }
            return null;
        }
        return null;
    }

    public void handle(HttpServerRequest httpRequest) {
        Details details;
        String contentType = httpRequest.getHeader(HttpHeaders.CONTENT_TYPE);
        if (contentType != null && (details = this.determine(contentType)) != null) {
            int errorCode = this.validate(httpRequest.version(), details.protocol, details.format);
            if (errorCode > 0) {
                httpRequest.response().setStatusCode(errorCode).end();
                return;
            }
        } else {
            httpRequest.response().setStatusCode(415).end();
            return;
        }
        GrpcMethodCall methodCall = new GrpcMethodCall(httpRequest.path());
        String path = httpRequest.path();
        while (true) {
            int idx;
            List<MethodCallHandler<?, ?>> mchList;
            if ((mchList = this.methodCallHandlers.get(path)) != null) {
                for (MethodCallHandler<?, ?> mch : mchList) {
                    if (!this.handle(mch, httpRequest, methodCall, details.protocol, details.format)) continue;
                    return;
                }
            }
            if ((idx = path.lastIndexOf(47)) <= 0) break;
            path = path.substring(0, idx);
        }
        Handler<GrpcServerRequest<Buffer, Buffer>> handler = this.requestHandler;
        if (handler != null) {
            this.handle(new MethodCallHandler<Buffer, Buffer>(null, GrpcMessageDecoder.IDENTITY, GrpcMessageEncoder.IDENTITY, handler), httpRequest, methodCall, details.protocol, details.format);
        } else {
            httpRequest.response().setStatusCode(500).end();
        }
    }

    private int validate(HttpVersion version, GrpcProtocol protocol, WireFormat format) {
        if (!protocol.accepts(version)) {
            log.trace((Object)(protocol.name() + " not supported on " + String.valueOf(version) + ", sending error 415"));
            return 415;
        }
        if (!this.options.isProtocolEnabled(protocol)) {
            log.trace((Object)(String.valueOf((Object)protocol) + " is not supported, sending error 415"));
            return 415;
        }
        return -1;
    }

    private <Req, Resp> void handle(GrpcInvocation<Req, Resp> invocation, Handler<GrpcServerRequest<Req, Resp>> handler) {
        this.handle(invocation.grpcRequest, invocation.grpcResponse, handler);
    }

    private <Req, Resp> boolean handle(MethodCallHandler<Req, Resp> method, HttpServerRequest httpRequest, GrpcMethodCall methodCall, GrpcProtocol protocol, WireFormat format) {
        GrpcServerResponseImpl grpcResponse;
        GrpcServerRequestImpl grpcRequest;
        ContextInternal context = ((HttpServerRequestInternal)httpRequest).context();
        block0 : switch (protocol) {
            case HTTP_2: {
                if (method.method != null && !httpRequest.path().equals("/" + method.method.fullMethodName())) {
                    return false;
                }
                grpcRequest = new Http2GrpcServerRequest(context, protocol, format, httpRequest, method.messageDecoder, methodCall);
                grpcResponse = new Http2GrpcServerResponse(context, grpcRequest, protocol, httpRequest.response(), method.messageEncoder);
                break;
            }
            case WEB: 
            case WEB_TEXT: {
                if (method.method != null && !httpRequest.path().equals("/" + method.method.fullMethodName())) {
                    return false;
                }
                grpcRequest = new WebGrpcServerRequest(context, protocol, format, this.options.getMaxMessageSize(), httpRequest, method.messageDecoder, methodCall);
                grpcResponse = new WebGrpcServerResponse(context, grpcRequest, protocol, httpRequest.response(), method.messageEncoder);
                break;
            }
            case TRANSCODING: {
                grpcRequest = null;
                grpcResponse = null;
                for (GrpcHttpInvoker invoker : this.invokers) {
                    GrpcInvocation invocation = invoker.accept(httpRequest, method.method);
                    if (invocation == null) continue;
                    grpcRequest = invocation.grpcRequest;
                    grpcResponse = invocation.grpcResponse;
                    break block0;
                }
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (grpcRequest == null || grpcResponse == null) {
            return false;
        }
        grpcResponse.format(format);
        this.handle(grpcRequest, grpcResponse, method);
        return true;
    }

    private <Req, Resp> void handle(GrpcServerRequestImpl<Req, Resp> grpcRequest, GrpcServerResponseImpl<Req, Resp> grpcResponse, Handler<GrpcServerRequest<Req, Resp>> handler) {
        if (this.options.getDeadlinePropagation() && grpcRequest.timeout() > 0L) {
            long deadline = System.currentTimeMillis() + grpcRequest.timeout;
            grpcRequest.context().putLocal(GrpcLocal.CONTEXT_LOCAL_KEY, AccessMode.CONCURRENT, (Object)new GrpcLocal(deadline));
        }
        grpcResponse.init();
        grpcRequest.init(grpcResponse, this.options.getScheduleDeadlineAutomatically(), this.options.getMaxMessageSize());
        grpcRequest.invalidMessageHandler(invalidMsg -> {
            if (invalidMsg instanceof MessageSizeOverflowException) {
                ((GrpcServerResponseImpl)grpcRequest.response()).status(GrpcStatus.RESOURCE_EXHAUSTED).end();
            } else {
                grpcResponse.cancel();
            }
        });
        grpcRequest.context().dispatch(grpcRequest, handler);
    }

    @Override
    public GrpcServer callHandler(Handler<GrpcServerRequest<Buffer, Buffer>> handler) {
        this.requestHandler = handler;
        return this;
    }

    private <Req, Resp> void registerMethodCallHandler(String path, MethodCallHandler<Req, Resp> mch) {
        this.methodCallHandlers.computeIfAbsent(path, k -> new ArrayList()).add(mch);
    }

    private <Req, Resp> void unregisterMethodCallHandler(String path, ServiceMethod<Req, Resp> serviceMethod) {
        this.methodCallHandlers.computeIfPresent(path, (p, registrations) -> {
            Iterator it = registrations.iterator();
            while (it.hasNext()) {
                MethodCallHandler mch = (MethodCallHandler)it.next();
                if (!mch.method.equals(serviceMethod)) continue;
                it.remove();
            }
            return registrations.isEmpty() ? null : registrations;
        });
    }

    @Override
    public <Req, Resp> GrpcServer callHandler(ServiceMethod<Req, Resp> serviceMethod, Handler<GrpcServerRequest<Req, Resp>> handler) {
        if (handler != null) {
            MethodCallHandler<Req, Resp> p = new MethodCallHandler<Req, Resp>(serviceMethod, serviceMethod.decoder(), serviceMethod.encoder(), handler);
            if (serviceMethod instanceof MountPoint) {
                MountPoint mountPoint = (MountPoint)serviceMethod;
                List<String> paths = mountPoint.paths();
                for (String path : paths) {
                    this.registerMethodCallHandler(path, p);
                }
            }
            this.registerMethodCallHandler("/" + serviceMethod.fullMethodName(), p);
        } else {
            if (serviceMethod instanceof MountPoint) {
                MountPoint mountPoint = (MountPoint)serviceMethod;
                List<String> paths = mountPoint.paths();
                for (String path : paths) {
                    this.unregisterMethodCallHandler(path, serviceMethod);
                }
            }
            this.unregisterMethodCallHandler("/" + serviceMethod.fullMethodName(), serviceMethod);
        }
        return this;
    }

    @Override
    public GrpcServer addService(Service service) {
        for (Service s : this.services) {
            if (!s.name().equals(service.name())) continue;
            throw new IllegalStateException("Duplicated name: " + service.name().name());
        }
        this.services.add(service);
        service.bind(this);
        return this;
    }

    @Override
    public List<Service> services() {
        return Collections.unmodifiableList(this.services);
    }

    private static class MethodCallHandler<Req, Resp>
    implements Handler<GrpcServerRequest<Req, Resp>> {
        final ServiceMethod<Req, Resp> method;
        final GrpcMessageDecoder<Req> messageDecoder;
        final GrpcMessageEncoder<Resp> messageEncoder;
        final Handler<GrpcServerRequest<Req, Resp>> handler;

        MethodCallHandler(ServiceMethod<Req, Resp> method, GrpcMessageDecoder<Req> messageDecoder, GrpcMessageEncoder<Resp> messageEncoder, Handler<GrpcServerRequest<Req, Resp>> handler) {
            this.method = method;
            this.messageDecoder = messageDecoder;
            this.messageEncoder = messageEncoder;
            this.handler = handler;
        }

        public void handle(GrpcServerRequest<Req, Resp> grpcRequest) {
            try {
                this.handler.handle(grpcRequest);
            }
            catch (Exception e) {
                grpcRequest.response().fail(e);
            }
        }
    }

    private static class Details {
        final GrpcProtocol protocol;
        final WireFormat format;

        Details(GrpcProtocol protocol, WireFormat format) {
            this.protocol = protocol;
            this.format = format;
        }
    }
}

