/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.transcoding.impl;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.server.GrpcProtocol;
import io.vertx.grpc.server.impl.GrpcServerRequestImpl;
import io.vertx.grpc.server.impl.GrpcServerResponseImpl;
import io.vertx.grpc.transcoding.impl.GrpcTranscodingError;
import io.vertx.grpc.transcoding.impl.MessageWeaver;
import io.vertx.grpc.transcoding.impl.TranscodingGrpcServerRequest;

public class TranscodingGrpcServerResponse<Req, Resp>
extends GrpcServerResponseImpl<Req, Resp> {
    private final TranscodingGrpcServerRequest<Req, Resp> request;
    private final HttpServerResponse httpResponse;
    private final String transcodingResponseBody;

    public TranscodingGrpcServerResponse(ContextInternal context, GrpcServerRequestImpl<Req, Resp> request, GrpcProtocol protocol, HttpServerResponse httpResponse, String transcodingResponseBody, GrpcMessageEncoder<Resp> encoder) {
        super(context, request, protocol, httpResponse, encoder);
        this.request = (TranscodingGrpcServerRequest)request;
        this.httpResponse = httpResponse;
        this.transcodingResponseBody = transcodingResponseBody;
    }

    protected Future<Void> sendMessage(Buffer message, boolean compressed) {
        try {
            BufferInternal transcoded = (BufferInternal)MessageWeaver.weaveResponseMessage(message, this.transcodingResponseBody);
            this.httpResponse.putHeader("content-length", Integer.toString(transcoded.length()));
            this.httpResponse.putHeader("content-type", GrpcProtocol.TRANSCODING.mediaType());
            return this.httpResponse.write((Object)transcoded);
        }
        catch (Exception e) {
            this.httpResponse.setStatusCode(500).end();
            return Future.failedFuture((Throwable)e);
        }
    }

    protected void encodeGrpcHeaders(MultiMap grpcHeaders, MultiMap httpHeaders) {
    }

    protected Future<Void> sendEnd() {
        GrpcStatus status = this.status();
        if (status != GrpcStatus.OK) {
            this.httpResponse.setStatusCode(GrpcTranscodingError.fromHttp2Code(status.code).getHttpStatusCode());
        }
        return super.sendEnd();
    }

    protected void sendCancel() {
        this.httpResponse.setStatusCode(400);
        this.httpResponse.end();
    }
}

