/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpcio.common.impl;

import io.grpc.Decompressor;
import io.grpc.KnownLength;
import io.grpc.MethodDescriptor;
import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.WireFormat;
import java.io.IOException;
import java.io.InputStream;

public class BridgeMessageDecoder<T>
implements GrpcMessageDecoder<T> {
    private MethodDescriptor.Marshaller<T> marshaller;
    private Decompressor decompressor;

    public BridgeMessageDecoder(MethodDescriptor.Marshaller<T> marshaller, Decompressor decompressor) {
        this.marshaller = marshaller;
        this.decompressor = decompressor;
    }

    public T decode(GrpcMessage msg) {
        assert (msg.format() == WireFormat.PROTOBUF);
        try (KnownLengthStream kls = new KnownLengthStream(msg.payload());){
            Object object;
            block16: {
                if (msg.encoding().equals("identity")) {
                    Object object2 = this.marshaller.parse((InputStream)((Object)kls));
                    return (T)object2;
                }
                InputStream in = this.decompressor.decompress((InputStream)((Object)kls));
                try {
                    object = this.marshaller.parse(in);
                    if (in == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                in.close();
            }
            return (T)object;
        }
    }

    public boolean accepts(WireFormat format) {
        return format == WireFormat.PROTOBUF;
    }

    private static class KnownLengthStream
    extends ByteBufInputStream
    implements KnownLength {
        public KnownLengthStream(Buffer buffer) {
            super(((BufferInternal)buffer).getByteBuf(), buffer.length());
        }

        public void close() {
            try {
                super.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

