/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.jdbc.impl.JDBCConnectionImpl;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.jdbcclient.impl.actions.JDBCPrepareStatementAction;
import io.vertx.jdbcclient.impl.actions.JDBCPreparedBatch;
import io.vertx.jdbcclient.impl.actions.JDBCPreparedQuery;
import io.vertx.jdbcclient.impl.actions.JDBCQueryAction;
import io.vertx.jdbcclient.impl.actions.JDBCSimpleQueryAction;
import io.vertx.jdbcclient.impl.actions.JDBCTxOp;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import io.vertx.sqlclient.impl.command.TxCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;

public class ConnectionImpl
implements Connection {
    final JDBCStatementHelper helper;
    final ContextInternal context;
    final JDBCConnectionImpl conn;
    final SQLOptions sqlOptions;

    public ConnectionImpl(JDBCStatementHelper helper, ContextInternal context, SQLOptions sqlOptions, JDBCConnectionImpl conn) {
        this.conn = conn;
        this.helper = helper;
        this.context = context;
        this.sqlOptions = sqlOptions;
    }

    public java.sql.Connection getJDBCConnection() {
        return (java.sql.Connection)this.conn.unwrap();
    }

    public SocketAddress server() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean isValid() {
        return true;
    }

    public boolean isSsl() {
        return false;
    }

    public DatabaseMetadata getDatabaseMetaData() {
        throw new UnsupportedOperationException();
    }

    public void init(Connection.Holder holder) {
    }

    public void close(Connection.Holder holder, Promise<Void> promise) {
        this.conn.close((Handler<AsyncResult<Void>>)promise);
    }

    public int getProcessId() {
        throw new UnsupportedOperationException();
    }

    public int getSecretKey() {
        throw new UnsupportedOperationException();
    }

    public <R> Future<R> schedule(ContextInternal contextInternal, CommandBase<R> commandBase) {
        if (commandBase instanceof SimpleQueryCommand) {
            return this.handle((SimpleQueryCommand)commandBase);
        }
        if (commandBase instanceof PrepareStatementCommand) {
            return this.handle((PrepareStatementCommand)commandBase);
        }
        if (commandBase instanceof ExtendedQueryCommand) {
            return this.handle((ExtendedQueryCommand)commandBase);
        }
        if (commandBase instanceof TxCommand) {
            return this.handle((TxCommand)commandBase);
        }
        return Future.failedFuture((String)("Not yet implemented " + commandBase));
    }

    private Future<PreparedStatement> handle(PrepareStatementCommand command) {
        JDBCPrepareStatementAction action = new JDBCPrepareStatementAction(this.helper, this.sqlOptions, command.sql());
        return this.conn.schedule(action);
    }

    private <R> Future<Boolean> handle(ExtendedQueryCommand<R> command) {
        JDBCQueryAction action = command.isBatch() ? new JDBCPreparedBatch(this.helper, this.sqlOptions, command, command.collector(), command.paramsList()) : new JDBCPreparedQuery(this.helper, this.sqlOptions, command, command.collector(), command.params());
        return this.handle(action, command.resultHandler());
    }

    private <R> Future<Boolean> handle(SimpleQueryCommand<R> command) {
        JDBCSimpleQueryAction action = new JDBCSimpleQueryAction(this.helper, this.sqlOptions, command.sql(), command.collector());
        return this.handle(action, command.resultHandler());
    }

    private <R> Future<R> handle(TxCommand<R> command) {
        JDBCTxOp<R> action = new JDBCTxOp<R>(this.helper, command, this.sqlOptions);
        return this.conn.schedule(action);
    }

    private <R> Future<Boolean> handle(JDBCQueryAction<?, R> action, QueryResultHandler<R> handler) {
        return this.conn.schedule(action).map(response -> {
            response.handle(handler);
            return false;
        });
    }
}

