/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.jdbcclient.FetchDirection;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.ResultSetConcurrency;
import io.vertx.jdbcclient.ResultSetType;
import io.vertx.jdbcclient.TransactionIsolation;
import java.util.Map;

public class JDBCConnectOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, JDBCConnectOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "readOnly": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setReadOnly((Boolean)member.getValue());
                    break;
                }
                case "catalog": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCatalog((String)member.getValue());
                    break;
                }
                case "transactionIsolation": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTransactionIsolation(TransactionIsolation.valueOf((String)member.getValue()));
                    break;
                }
                case "resultSetType": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setResultSetType(ResultSetType.valueOf((String)member.getValue()));
                    break;
                }
                case "resultSetConcurrency": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setResultSetConcurrency(ResultSetConcurrency.valueOf((String)member.getValue()));
                    break;
                }
                case "autoGeneratedKeys": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAutoGeneratedKeys((Boolean)member.getValue());
                    break;
                }
                case "schema": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSchema((String)member.getValue());
                    break;
                }
                case "queryTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setQueryTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "fetchDirection": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setFetchDirection(FetchDirection.valueOf((String)member.getValue()));
                    break;
                }
                case "fetchSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setFetchSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "autoGeneratedKeysIndexes": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    obj.setAutoGeneratedKeysIndexes(((JsonArray)member.getValue()).copy());
                    break;
                }
                case "maxRows": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxRows(((Number)member.getValue()).intValue());
                    break;
                }
                case "jdbcUrl": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setJdbcUrl((String)member.getValue());
                    break;
                }
                case "user": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUser((String)member.getValue());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "database": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDatabase((String)member.getValue());
                    break;
                }
                case "connectTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setConnectTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "idleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setIdleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "metricsName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMetricsName((String)member.getValue());
                    break;
                }
                case "tracingPolicy": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTracingPolicy(TracingPolicy.valueOf((String)((String)member.getValue())));
                    break;
                }
                case "extraConfig": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setExtraConfig(((JsonObject)member.getValue()).copy());
                }
            }
        }
    }

    static void toJson(JDBCConnectOptions obj, JsonObject json) {
        JDBCConnectOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(JDBCConnectOptions obj, Map<String, Object> json) {
        json.put("readOnly", obj.isReadOnly());
        if (obj.getCatalog() != null) {
            json.put("catalog", obj.getCatalog());
        }
        if (obj.getTransactionIsolation() != null) {
            json.put("transactionIsolation", obj.getTransactionIsolation().name());
        }
        if (obj.getResultSetType() != null) {
            json.put("resultSetType", obj.getResultSetType().name());
        }
        if (obj.getResultSetConcurrency() != null) {
            json.put("resultSetConcurrency", obj.getResultSetConcurrency().name());
        }
        json.put("autoGeneratedKeys", obj.isAutoGeneratedKeys());
        if (obj.getSchema() != null) {
            json.put("schema", obj.getSchema());
        }
        json.put("queryTimeout", obj.getQueryTimeout());
        if (obj.getFetchDirection() != null) {
            json.put("fetchDirection", obj.getFetchDirection().name());
        }
        json.put("fetchSize", obj.getFetchSize());
        if (obj.getAutoGeneratedKeysIndexes() != null) {
            json.put("autoGeneratedKeysIndexes", obj.getAutoGeneratedKeysIndexes());
        }
        json.put("maxRows", obj.getMaxRows());
        if (obj.getJdbcUrl() != null) {
            json.put("jdbcUrl", obj.getJdbcUrl());
        }
        if (obj.getUser() != null) {
            json.put("user", obj.getUser());
        }
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getDatabase() != null) {
            json.put("database", obj.getDatabase());
        }
        json.put("connectTimeout", obj.getConnectTimeout());
        json.put("idleTimeout", obj.getIdleTimeout());
        if (obj.getMetricsName() != null) {
            json.put("metricsName", obj.getMetricsName());
        }
        if (obj.getTracingPolicy() != null) {
            json.put("tracingPolicy", obj.getTracingPolicy().name());
        }
        if (obj.getExtraConfig() != null) {
            json.put("extraConfig", obj.getExtraConfig());
        }
    }
}

