/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.jdbcclient.SqlOptions;
import io.vertx.jdbcclient.impl.actions.JDBCAction;
import io.vertx.jdbcclient.impl.actions.JDBCClose;
import io.vertx.jdbcclient.impl.actions.JDBCPrepareStatementAction;
import io.vertx.jdbcclient.impl.actions.JDBCPreparedBatch;
import io.vertx.jdbcclient.impl.actions.JDBCPreparedQuery;
import io.vertx.jdbcclient.impl.actions.JDBCQueryAction;
import io.vertx.jdbcclient.impl.actions.JDBCSimpleQueryAction;
import io.vertx.jdbcclient.impl.actions.JDBCStatementHelper;
import io.vertx.jdbcclient.impl.actions.JDBCTxOp;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.PreparedStatement;
import io.vertx.sqlclient.internal.QueryResultHandler;
import io.vertx.sqlclient.internal.command.CommandBase;
import io.vertx.sqlclient.internal.command.ExtendedQueryCommand;
import io.vertx.sqlclient.internal.command.PrepareStatementCommand;
import io.vertx.sqlclient.internal.command.SimpleQueryCommand;
import io.vertx.sqlclient.internal.command.TxCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionImpl
implements io.vertx.sqlclient.internal.Connection {
    final JDBCStatementHelper helper;
    final ContextInternal context;
    final Connection conn;
    final ClientMetrics<?, ?, ?> metrics;
    final String user;
    final String database;
    final SocketAddress server;
    SqlOptions sqlOptions;

    public ConnectionImpl(JDBCStatementHelper helper, ContextInternal context, SqlOptions sqlOptions, Connection conn, ClientMetrics<?, ?, ?> metrics, String user, String database, SocketAddress server) {
        this.conn = conn;
        this.helper = helper;
        this.context = context;
        this.sqlOptions = sqlOptions;
        this.user = user;
        this.database = database;
        this.server = server;
        this.metrics = metrics;
    }

    public Connection getJDBCConnection() {
        return this.conn;
    }

    public TracingPolicy tracingPolicy() {
        return TracingPolicy.PROPAGATE;
    }

    public String database() {
        return this.database;
    }

    public String user() {
        return this.user;
    }

    public ClientMetrics metrics() {
        return this.metrics;
    }

    public int pipeliningLimit() {
        return 1;
    }

    public SocketAddress server() {
        return this.server;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isSsl() {
        return false;
    }

    public DatabaseMetadata getDatabaseMetaData() {
        throw new UnsupportedOperationException();
    }

    public void init(Connection.Holder holder) {
    }

    public void close(Connection.Holder holder, Promise<Void> promise) {
        this.schedule(new JDBCClose(this.sqlOptions, null, null)).andThen(ar -> {
            if (this.metrics != null) {
                this.metrics.close();
            }
        }).onComplete(promise);
    }

    public int getProcessId() {
        throw new UnsupportedOperationException();
    }

    public int getSecretKey() {
        throw new UnsupportedOperationException();
    }

    public <R> void schedule(CommandBase<R> cmd, Completable<R> handler) {
        Object fut = cmd instanceof SimpleQueryCommand ? this.handle((SimpleQueryCommand)cmd) : (cmd instanceof PrepareStatementCommand ? this.handle((PrepareStatementCommand)cmd) : (cmd instanceof ExtendedQueryCommand ? this.handle((ExtendedQueryCommand)cmd) : (cmd instanceof TxCommand ? this.handle((TxCommand)cmd) : (cmd instanceof JDBCAction ? this.schedule((JDBCAction)cmd) : Future.failedFuture((String)("Not yet implemented " + String.valueOf(cmd)))))));
        fut.onComplete(handler);
    }

    private Future<PreparedStatement> handle(PrepareStatementCommand command) {
        JDBCPrepareStatementAction action = new JDBCPrepareStatementAction(this.helper, this.sqlOptions, command.sql());
        return this.schedule(action);
    }

    private <R> Future<Boolean> handle(ExtendedQueryCommand<R> command) {
        JDBCQueryAction action = command.isBatch() ? new JDBCPreparedBatch(this.helper, this.sqlOptions, command, command.collector(), command.paramsList()) : new JDBCPreparedQuery(this.helper, this.sqlOptions, command, command.collector(), (Tuple)command.params());
        return this.handle(action, command.resultHandler());
    }

    private <R> Future<Boolean> handle(SimpleQueryCommand<R> command) {
        JDBCSimpleQueryAction action = new JDBCSimpleQueryAction(this.helper, this.sqlOptions, command.sql(), command.collector());
        return this.handle(action, command.resultHandler());
    }

    private <R> Future<R> handle(TxCommand<R> command) {
        JDBCTxOp<R> action = new JDBCTxOp<R>(this.helper, command, this.sqlOptions);
        return this.schedule(action);
    }

    private <R> Future<Boolean> handle(JDBCQueryAction<?, R> action, QueryResultHandler<R> handler) {
        return this.schedule(action).map(response -> {
            response.handle(handler);
            return false;
        });
    }

    public <T> Future<T> schedule(JDBCAction<T> action) {
        return this.context.executeBlocking(() -> {
            ConnectionImpl.applyConnectionOptions(this.conn, this.sqlOptions);
            return action.execute(this.conn);
        });
    }

    public static void applyConnectionOptions(Connection conn, SqlOptions sqlOptions) throws SQLException {
        if (sqlOptions != null) {
            if (sqlOptions.isReadOnly()) {
                conn.setReadOnly(true);
            }
            if (sqlOptions.getCatalog() != null) {
                conn.setCatalog(sqlOptions.getCatalog());
            }
            if (sqlOptions.getSchema() != null) {
                conn.setSchema(sqlOptions.getSchema());
            }
        }
    }
}

