/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.internal.ArrayTuple;
import io.vertx.sqlclient.internal.RowDesc;
import java.util.List;
import java.util.Objects;

public class JDBCRow
extends ArrayTuple
implements Row {
    private final RowDesc desc;

    public JDBCRow(RowDesc desc) {
        super(desc.columnNames().size());
        this.desc = desc;
    }

    public String getColumnName(int pos) {
        List columnNames = this.desc.columnNames();
        return pos < 0 || columnNames.size() - 1 < pos ? null : (String)columnNames.get(pos);
    }

    public int getColumnIndex(String name) {
        Objects.requireNonNull(name, "'name' cannot be null");
        return this.desc.columnNames().indexOf(name);
    }

    public <T> T get(Class<T> type, int pos) {
        if (type.isEnum()) {
            return type.cast(this.getEnum(type, pos));
        }
        return (T)super.get(type, pos);
    }

    private Object getEnum(Class enumType, int position) {
        Object val = this.getValue(position);
        if (val != null) {
            T[] constants;
            int ordinal;
            if (val.getClass().isAssignableFrom(enumType)) {
                return enumType.cast(val);
            }
            if (val instanceof String) {
                return Enum.valueOf(enumType, (String)val);
            }
            if (val instanceof Number && (ordinal = ((Number)val).intValue()) >= 0 && ordinal < (constants = enumType.getEnumConstants()).length) {
                return constants[ordinal];
            }
        }
        return null;
    }
}

