/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.core.json.JsonArray;
import io.vertx.jdbcclient.SqlOptions;
import io.vertx.jdbcclient.impl.actions.CachedParameterMetaData;
import io.vertx.jdbcclient.impl.actions.JDBCAction;
import io.vertx.jdbcclient.impl.actions.JDBCStatementHelper;
import io.vertx.jdbcclient.spi.JDBCColumnDescriptorProvider;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;

public abstract class AbstractJDBCAction<T>
implements JDBCAction<T> {
    protected final SqlOptions options;
    protected final JDBCStatementHelper helper;
    private static final JsonArray EMPTY = new JsonArray(Collections.unmodifiableList(new ArrayList()));

    protected AbstractJDBCAction(SqlOptions options) {
        this(null, options);
    }

    protected AbstractJDBCAction(JDBCStatementHelper helper, SqlOptions options) {
        this.options = options;
        this.helper = helper;
    }

    @Override
    public abstract T execute(Connection var1) throws SQLException;

    protected void applyStatementOptions(Statement statement) throws SQLException {
        if (this.options != null) {
            if (this.options.getQueryTimeout() > 0) {
                statement.setQueryTimeout(this.options.getQueryTimeout());
            }
            if (this.options.getFetchDirection() != null) {
                statement.setFetchDirection(this.options.getFetchDirection().getType());
            }
            if (this.options.getFetchSize() != 0) {
                statement.setFetchSize(this.options.getFetchSize());
            }
            if (this.options.getMaxRows() > 0) {
                statement.setMaxRows(this.options.getMaxRows());
            }
        }
    }

    protected void fillStatement(PreparedStatement statement, JsonArray in) throws SQLException {
        CachedParameterMetaData md = new CachedParameterMetaData(statement);
        JDBCColumnDescriptorProvider provider = JDBCColumnDescriptorProvider.fromParameterMetaData(md);
        this.fillStatement(statement, in, provider);
    }

    protected void fillStatement(PreparedStatement statement, JsonArray in, JDBCColumnDescriptorProvider provider) throws SQLException {
        if (in == null) {
            in = EMPTY;
        }
        for (int pos = 1; pos <= in.size(); ++pos) {
            statement.setObject(pos, this.helper.getEncoder().encode(in, pos, provider));
        }
    }

    protected void fillStatement(CallableStatement statement, JsonArray in, JsonArray out, JDBCColumnDescriptorProvider provider) throws SQLException {
        if (in == null) {
            in = EMPTY;
        }
        if (out == null) {
            out = EMPTY;
        }
        int max = Math.max(in.size(), out.size());
        for (int i = 0; i < max; ++i) {
            Object value;
            boolean set = false;
            if (i < in.size() && (value = this.helper.getEncoder().encode(in, i + 1, provider)) != null) {
                statement.setObject(i + 1, value);
                set = true;
            }
            value = null;
            if (i < out.size()) {
                value = out.getValue(i);
            }
            if (value != null) {
                if (value instanceof String) {
                    statement.registerOutParameter(i + 1, (int)JDBCType.valueOf((String)value).getVendorTypeNumber());
                } else if (value instanceof Number) {
                    statement.registerOutParameter(i + 1, ((Number)value).intValue());
                }
                set = true;
            }
            if (set) continue;
            statement.setNull(i + 1, 0);
        }
    }
}

