/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.jdbcclient.impl.actions.JDBCColumnDescriptor;
import java.sql.JDBCType;
import java.sql.SQLException;

public interface JDBCPropertyAccessor<T> {
    public static final Logger LOG = LoggerFactory.getLogger(JDBCColumnDescriptor.class);

    public T get() throws SQLException;

    public static <T> JDBCPropertyAccessor<T> create(JDBCPropertyAccessor<T> accessor) {
        return JDBCPropertyAccessor.create(accessor, null);
    }

    public static <T> JDBCPropertyAccessor<T> create(JDBCPropertyAccessor<T> accessor, T fallbackIfUnsupported) {
        return () -> {
            try {
                return accessor.get();
            }
            catch (SQLException e) {
                LOG.debug((Object)"Unsupported access properties in SQL metadata", (Throwable)e);
                return fallbackIfUnsupported;
            }
        };
    }

    public static JDBCPropertyAccessor<Integer> jdbcType(JDBCPropertyAccessor<Integer> accessor) {
        return JDBCPropertyAccessor.create(accessor, JDBCType.OTHER.getVendorTypeNumber());
    }
}

