/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common.dsl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.common.SchemaURNId;
import io.vertx.json.schema.common.dsl.ArraySchemaBuilder;
import io.vertx.json.schema.common.dsl.BooleanSchemaBuilder;
import io.vertx.json.schema.common.dsl.GenericSchemaBuilder;
import io.vertx.json.schema.common.dsl.Keyword;
import io.vertx.json.schema.common.dsl.NumberSchemaBuilder;
import io.vertx.json.schema.common.dsl.ObjectSchemaBuilder;
import io.vertx.json.schema.common.dsl.SchemaBuilder;
import io.vertx.json.schema.common.dsl.StringSchemaBuilder;
import io.vertx.json.schema.common.dsl.TupleSchemaBuilder;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class Schemas {
    public static GenericSchemaBuilder schema() {
        return new GenericSchemaBuilder();
    }

    public static NumberSchemaBuilder intSchema() {
        return new NumberSchemaBuilder().asInteger();
    }

    public static NumberSchemaBuilder numberSchema() {
        return new NumberSchemaBuilder();
    }

    public static StringSchemaBuilder stringSchema() {
        return new StringSchemaBuilder();
    }

    public static BooleanSchemaBuilder booleanSchema() {
        return new BooleanSchemaBuilder();
    }

    public static TupleSchemaBuilder tupleSchema() {
        return new TupleSchemaBuilder();
    }

    public static ArraySchemaBuilder arraySchema() {
        return new ArraySchemaBuilder();
    }

    public static ObjectSchemaBuilder objectSchema() {
        return new ObjectSchemaBuilder();
    }

    public static GenericSchemaBuilder constSchema(@Nullable Object constValue) {
        return (GenericSchemaBuilder)new GenericSchemaBuilder().with(new Keyword("const", constValue));
    }

    public static GenericSchemaBuilder enumSchema(Object ... enumValues) {
        return (GenericSchemaBuilder)new GenericSchemaBuilder().with(new Keyword("enum", Arrays.asList(enumValues)));
    }

    public static GenericSchemaBuilder ref(JsonPointer pointer) {
        Objects.requireNonNull(pointer);
        return (GenericSchemaBuilder)new GenericSchemaBuilder().with(new Keyword("$ref", pointer.toURI().toString()));
    }

    public static GenericSchemaBuilder refToAlias(String alias) {
        Objects.requireNonNull(alias);
        return Schemas.ref(new SchemaURNId(alias).toPointer());
    }

    public static GenericSchemaBuilder allOf(SchemaBuilder ... allOf) {
        Objects.requireNonNull(allOf);
        return (GenericSchemaBuilder)new GenericSchemaBuilder().with(new Keyword("allOf", Schemas.collectSchemaBuilders(allOf)));
    }

    public static GenericSchemaBuilder anyOf(SchemaBuilder ... anyOf) {
        Objects.requireNonNull(anyOf);
        return (GenericSchemaBuilder)new GenericSchemaBuilder().with(new Keyword("anyOf", Schemas.collectSchemaBuilders(anyOf)));
    }

    public static GenericSchemaBuilder oneOf(SchemaBuilder ... oneOf) {
        Objects.requireNonNull(oneOf);
        return (GenericSchemaBuilder)new GenericSchemaBuilder().with(new Keyword("oneOf", Schemas.collectSchemaBuilders(oneOf)));
    }

    public static GenericSchemaBuilder not(SchemaBuilder not) {
        Objects.requireNonNull(not);
        return (GenericSchemaBuilder)new GenericSchemaBuilder().with(new Keyword("not", not::toJson));
    }

    private static Supplier<Object> collectSchemaBuilders(SchemaBuilder ... schemaBuilders) {
        return () -> Arrays.stream(schemaBuilders).collect(Collector.of(JsonArray::new, (j, b) -> j.add((Object)b.toJson()), JsonArray::addAll, new Collector.Characteristics[0]));
    }
}

