/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.draft7;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseMutableStateValidator;
import io.vertx.json.schema.common.JsonUtil;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaInternal;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DependenciesValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            JsonObject dependencies = schema.getJsonObject("dependencies");
            JsonPointer baseScope = scope.copy().append("dependencies");
            HashMap keyDeps = new HashMap();
            HashMap keySchemaDeps = new HashMap();
            DependenciesValidator validator = new DependenciesValidator(parent);
            for (Map.Entry entry : dependencies.getMap().entrySet()) {
                if (entry.getValue() instanceof Map || entry.getValue() instanceof Boolean) {
                    keySchemaDeps.put(entry.getKey(), parser.parse(entry.getValue() instanceof Map ? new JsonObject((Map)entry.getValue()) : entry.getValue(), baseScope.copy().append((String)entry.getKey()), (MutableStateValidator)validator));
                    continue;
                }
                if (((List)entry.getValue()).isEmpty()) continue;
                keyDeps.put(entry.getKey(), new HashSet((List)entry.getValue()));
            }
            validator.configure(keyDeps, keySchemaDeps);
            return validator;
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for dependencies keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null dependencies keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("dependencies");
    }

    static class DependenciesValidator
    extends BaseMutableStateValidator {
        Map<String, Set<String>> keyDeps;
        Map<String, SchemaInternal> keySchemaDeps;

        public DependenciesValidator(MutableStateValidator parent) {
            super(parent);
        }

        private void configure(Map<String, Set<String>> keyDeps, Map<String, SchemaInternal> keySchemaDeps) {
            this.keyDeps = keyDeps;
            this.keySchemaDeps = keySchemaDeps;
            this.initializeIsSync();
        }

        private void checkKeyDeps(Map<String, ?> obj) {
            Set<String> objKeys = obj.keySet();
            for (Map.Entry<String, Set<String>> dependency : this.keyDeps.entrySet()) {
                if (!obj.containsKey(dependency.getKey()) || objKeys.containsAll((Collection)dependency.getValue())) continue;
                throw ValidationException.create("dependencies of key " + dependency.getKey() + " are not satisfied: " + dependency.getValue().toString(), "dependencies", obj);
            }
        }

        @Override
        public Future<Void> validateAsync(ValidatorContext context, Object in) {
            if (this.isSync()) {
                return this.validateSyncAsAsync(context, in);
            }
            Object o = JsonUtil.unwrap(in);
            if (o instanceof Map) {
                Map obj = (Map)o;
                try {
                    this.checkKeyDeps(obj);
                }
                catch (ValidationException e2) {
                    return Future.failedFuture((Throwable)((Object)e2));
                }
                List futs = this.keySchemaDeps.entrySet().stream().filter(e -> obj.containsKey(e.getKey())).map(e -> ((SchemaInternal)e.getValue()).validateAsync(context, in)).collect(Collectors.toList());
                if (futs.isEmpty()) {
                    return Future.succeededFuture();
                }
                return CompositeFuture.all(futs).mapEmpty();
            }
            return Future.succeededFuture();
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException, NoSyncValidationException {
            this.checkSync();
            Object o = JsonUtil.unwrap(in);
            if (o instanceof Map) {
                Map obj = (Map)o;
                this.checkKeyDeps(obj);
                this.keySchemaDeps.entrySet().stream().filter(e -> obj.containsKey(e.getKey())).forEach(e -> ((SchemaInternal)e.getValue()).validateSync(context, in));
            }
        }

        @Override
        public boolean calculateIsSync() {
            return this.keySchemaDeps.values().stream().map(Schema::isSync).reduce(true, Boolean::logicalAnd);
        }
    }
}

