/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.JsonUtil;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import java.util.List;

public class MinItemsValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            Number minimum = (Number)schema.getValue("minItems");
            if (minimum.intValue() < 0) {
                throw new SchemaException(schema, "minItems must be >= 0");
            }
            return new MinItemsValidator(minimum.intValue());
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for minItems keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null minItems keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("minItems");
    }

    public static class MinItemsValidator
    extends BaseSyncValidator {
        private final int minimum;

        public MinItemsValidator(int minimum) {
            this.minimum = minimum;
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException {
            List arr;
            Object o = JsonUtil.unwrap(in);
            if (o instanceof List && (arr = (List)o).size() < this.minimum) {
                throw ValidationException.create("provided array should have size >= " + this.minimum, "minItems", in);
            }
        }
    }
}

